/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.token;

import com.alibaba.nls.client.AccessToken;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.service.token.base.TokenConfig;
import com.digiwin.athena.ania.service.token.base.impl.BaseTokenService;
import com.digiwin.athena.ania.service.token.base.impl.RedisTokenConfigImpl;
import com.digiwin.athena.appcore.exception.BusinessException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class AlibabaAccessTokenComponent
extends BaseTokenService {
    private static final Logger log = LoggerFactory.getLogger(AlibabaAccessTokenComponent.class);
    @Value(value="${alibaba.accessKeyId}")
    private String accessKeyId;
    @Value(value="${alibaba.accessKeySecret}")
    private String accessKeySecret;

    public AlibabaAccessTokenComponent(StringRedisTemplate redisTemplate) {
        super.setTokenConfig((TokenConfig)new RedisTokenConfigImpl(redisTemplate, "ASA:ALIBABA_ACCESS_TOKEN"));
    }

    protected Pair<String, Long> getTokenAction() throws BusinessException {
        try {
            AccessToken accessToken = new AccessToken(this.accessKeyId, this.accessKeySecret);
            accessToken.apply();
            String token = accessToken.getToken();
            long expireTime = accessToken.getExpireTime();
            Instant instant = Instant.now();
            long currentTimeInSeconds = instant.getEpochSecond();
            return Pair.of((Object)token, (Object)(expireTime - currentTimeInSeconds));
        }
        catch (Exception ex) {
            throw BusinessException.create((Throwable)ex);
        }
    }

    public ResultBean<Map<String, Object>> getAccessToken(String refresh) {
        try {
            String token = super.getToken("force".equals(refresh));
            if (StringUtils.isNotBlank((CharSequence)token)) {
                Long expiredTime = super.getTokenConfig().tokenExpiredTime();
                HashMap<String, Object> accessToken = new HashMap<String, Object>();
                accessToken.put("token", token);
                accessToken.put("expireTime", expiredTime);
                return ResultBean.success((Integer)0, accessToken);
            }
            return ResultBean.fail((String)"access token blank");
        }
        catch (Exception e) {
            return ResultBean.fail((String)"access token failed");
        }
    }
}

