/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.token.base.impl;

import com.digiwin.athena.ania.service.token.base.impl.DefaultTokenConfigImpl;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisTokenConfigImpl
extends DefaultTokenConfigImpl {
    protected String tokenKey;
    private StringRedisTemplate redisTemplate;

    public RedisTokenConfigImpl(StringRedisTemplate redisTemplate, String tokenKey) {
        this.tokenKey = tokenKey;
        this.redisTemplate = redisTemplate;
    }

    public String getToken() {
        String token = (String)this.redisTemplate.opsForValue().get((Object)this.tokenKey);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            Long expire = this.redisTemplate.getExpire((Object)this.tokenKey);
            super.setExpiresTime(expire.longValue());
        }
        return token;
    }

    public boolean isTokenExpired() {
        return false;
    }

    public Long tokenExpiredTime() {
        return super.tokenExpiredTime();
    }

    public synchronized void updateApplicationToken(String token, long expiresInSeconds) {
        long expiresTime = expiresInSeconds > 0L ? expiresInSeconds : 1L;
        this.redisTemplate.opsForValue().set((Object)this.tokenKey, (Object)token, expiresTime, TimeUnit.SECONDS);
        super.setToken(token);
        super.setExpiresTime(expiresTime);
    }

    public void expireToken() {
        this.redisTemplate.expire((Object)this.tokenKey, 0L, TimeUnit.SECONDS);
        super.expireToken();
    }
}

