/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.sse;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.knowledge.context.KnowledgeContext;
import com.digiwin.athena.ania.knowledge.context.RichSseEmitter;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public abstract class SseEmitterCancelListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(SseEmitterCancelListener.class);
    @Resource
    private SseEventDataService sseEventDataService;

    public void onMessage(Message message, byte[] pattern) {
        String id = null;
        try {
            id = new String(message.getBody());
            id = id.replace("\"", "");
            log.info("SseEmitterCancelListener.onMessage:{}", (Object)id);
            this.cancel(id);
        }
        catch (Exception e) {
            log.error("SseEmitterCancelListener onMessage error id:{}", (Object)id, (Object)e);
        }
    }

    protected abstract void cancel(String var1);

    private void stop(SseEventParams sseEventParam) {
        EventData completed = new EventData(SseEventlEnum.CHAT_COMPLETED.getEvent(), null);
        this.sseEventDataService.saveEventDataLog(sseEventParam, completed);
        EventData.EventMessage eventMessage = new EventData.EventMessage();
        eventMessage.setType(SseEventlEnum.SseEventDataTypeEnum.VERBOSE.getType());
        eventMessage.setMessage(new JSONObject().fluentPut("canceled", (Object)true).toString());
        EventData doneData = new EventData(SseEventlEnum.CHAT_DONE.getEvent(), eventMessage);
        this.sseEventDataService.saveEventDataLog(sseEventParam, doneData);
        SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEventParam.getId());
        if (Objects.nonNull(sseEmitter)) {
            try {
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)completed);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)doneData);
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)completed);
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)doneData);
            }
            catch (IOException e) {
                log.error("SseEmitterCallbackComponent.sendAnswerDone is error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop(RichSseEmitter richSseEmitter) {
        try {
            SseEventParams sseEventParam = richSseEmitter.getSseEventParams();
            EventData completed = new EventData(SseEventlEnum.CHAT_COMPLETED.getEvent(), null);
            this.sseEventDataService.saveEventDataLog(sseEventParam, completed);
            EventData.EventMessage eventMessage = new EventData.EventMessage();
            eventMessage.setType(SseEventlEnum.SseEventDataTypeEnum.VERBOSE.getType());
            eventMessage.setMessage(new com.alibaba.fastjson2.JSONObject().fluentPut("canceled", (Object)true).toString());
            EventData doneData = new EventData(SseEventlEnum.CHAT_DONE.getEvent(), eventMessage);
            this.sseEventDataService.saveEventDataLog(sseEventParam, doneData);
            try {
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)completed);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)doneData);
                SseEmitterUtils.send((SseEmitter)richSseEmitter, (EventData)completed);
                SseEmitterUtils.send((SseEmitter)richSseEmitter, (EventData)doneData);
            }
            catch (IOException e) {
                log.error("AgentSseStopListener.stop is error", (Throwable)e);
            }
        }
        finally {
            richSseEmitter.complete();
        }
    }
}

