/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.util;

import com.digiwin.athena.appcore.util.TimeUtils;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    public static final String DATE_TIME_NORMAL_FORMATTER = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_NORMAL_FORMATTER = "yyyy-MM-dd";
    public static final String TIME_NORMAL_FORMATTER = "HH:mm:ss";
    public static final String DATE_TIME_FORMATTER = "yyyyMMddHHmmss";
    public static final String YEAR = "year";
    public static final String MONTH = "month";
    public static final String DAY = "day";
    public static final String HOUR = "hour";
    public static final String MINUTE = "minute";
    public static final String SECOND = "second";
    public static final String WEEK = "week";

    public static String getNowTime(String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            format = DATE_TIME_NORMAL_FORMATTER;
        }
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(format));
    }

    public static String addDate(String dateStr, String pattern, int step, String type) {
        if (dateStr == null) {
            return dateStr;
        }
        Date date1 = TimeUtils.parseDate((String)dateStr, (String)pattern);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        switch (type) {
            case "year": {
                cal.add(1, step);
                break;
            }
            case "month": {
                cal.add(2, step);
                break;
            }
            case "week": {
                cal.add(4, step);
                break;
            }
            case "day": {
                cal.add(5, step);
                break;
            }
            case "hour": {
                cal.add(10, step);
                break;
            }
            case "minute": {
                cal.add(12, step);
                break;
            }
            case "second": {
                cal.add(13, step);
                break;
            }
        }
        return TimeUtils.format((Date)cal.getTime(), (String)pattern);
    }

    public static int compare(Date beginDate, Date endDate) {
        long endTime;
        int ret = 1;
        long beginTime = beginDate.getTime();
        if (beginTime > (endTime = endDate.getTime())) {
            ret = 2;
        }
        if (beginTime == endTime) {
            ret = 1;
        }
        if (beginTime < endTime) {
            ret = 0;
        }
        return ret;
    }

    public static boolean validateDate(String dateParam, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            Date date = formatter.parse(dateParam);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String calDateDifference(Date nowDate, Date endDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f";
    }

    public static String dateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_NORMAL_FORMATTER);
        String dateString = sdf.format(date);
        return dateString;
    }

    public static String parseDateOfPattern(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static Long dataStr2Timestamp(String dataStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_NORMAL_FORMATTER);
        try {
            Date date = sdf.parse(dataStr);
            long timestamp = date.getTime();
            return timestamp;
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

