/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.util;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.knowledge.intentflow.dto.IntentFlowEventData;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.knowledge.server.dto.sse.EventMessageData;
import com.digiwin.athena.ania.knowledge.server.dto.sse.StreamEventData;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.EventSourceListenerUtils;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventSourceListenerUtils {
    private static final Logger log = LoggerFactory.getLogger(EventSourceListenerUtils.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(EventSourceListenerUtils.class);

    private EventSourceListenerUtils() {
    }

    public static EventData convertEventData(JSONObject data, SseEventParams sseEventParams) {
        String eventType = MapUtils.getString((Map)data, (Object)"type");
        SseEventlEnum.SseEventDataTypeEnum eventDataType = SseEventlEnum.SseEventDataTypeEnum.getEventDataType((String)eventType);
        if (Objects.isNull(eventDataType)) {
            return null;
        }
        switch (1.$SwitchMap$com$digiwin$athena$ania$common$enums$SseEventlEnum$SseEventDataTypeEnum[eventDataType.ordinal()]) {
            case 1: {
                return EventSourceListenerUtils.convertAnswerEventData((JSONObject)data, (SseEventParams)sseEventParams);
            }
            case 2: 
            case 3: 
            case 4: {
                return EventSourceListenerUtils.convertFunctionEventData((JSONObject)data, (SseEventParams)sseEventParams, (SseEventlEnum.SseEventDataTypeEnum)eventDataType);
            }
            case 5: {
                return EventSourceListenerUtils.convertVerboseEventData((JSONObject)data, (SseEventParams)sseEventParams);
            }
            case 6: {
                return EventSourceListenerUtils.convertFollowUpEventData((JSONObject)data, (SseEventParams)sseEventParams);
            }
        }
        return null;
    }

    public static EventData convertVerboseEventData(JSONObject data, SseEventParams sseEventParam) {
        String message = MapUtils.getString((Map)data, (Object)"message");
        EventMessageData messageData = EventMessageData.builder().content(message).messageType(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType()).build();
        return EventSourceListenerUtils.buildEventData((SseEventParams)sseEventParam, (SseEventlEnum)SseEventlEnum.MESSAGE_COMPLETED, (SseEventlEnum.SseEventDataTypeEnum)SseEventlEnum.SseEventDataTypeEnum.VERBOSE, (EventMessageData)messageData);
    }

    public static EventData convertFollowUpEventData(JSONObject data, SseEventParams sseEventParam) {
        String message = MapUtils.getString((Map)data, (Object)"message");
        EventMessageData messageData = EventMessageData.builder().content(message).messageType(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType()).build();
        return EventSourceListenerUtils.buildEventData((SseEventParams)sseEventParam, (SseEventlEnum)SseEventlEnum.MESSAGE_COMPLETED, (SseEventlEnum.SseEventDataTypeEnum)SseEventlEnum.SseEventDataTypeEnum.FOLLOW_UP, (EventMessageData)messageData);
    }

    public static EventData convertFunctionEventData(JSONObject data, SseEventParams sseEventParam, SseEventlEnum.SseEventDataTypeEnum functionType) {
        String message = MapUtils.getString((Map)data, (Object)"message");
        LOGGER.info("convertFunctionEventData message:{}", (Object)message);
        if (Objects.isNull(message) || !JSON.isValidObject((String)message)) {
            return null;
        }
        JSONObject function = JSON.parseObject((String)message);
        IntentFlowEventData.IntentEventMessage intentEventMessage = (IntentFlowEventData.IntentEventMessage)JSONUtil.toBean((String)message, IntentFlowEventData.IntentEventMessage.class);
        if (Objects.isNull(intentEventMessage) || MapUtils.isEmpty((Map)intentEventMessage.getExtra_info())) {
            return null;
        }
        String event = SseEventlEnum.MESSAGE_COMPLETED.getEvent();
        switch (1.$SwitchMap$com$digiwin$athena$ania$common$enums$SseEventlEnum$SseEventDataTypeEnum[functionType.ordinal()]) {
            case 2: {
                String title = MapUtils.getString((Map)function, (Object)"title", (String)"...");
                intentEventMessage.setMessageName(title);
            }
            case 3: {
                String status = MapUtils.getString((Map)function, (Object)"status", (String)"fail");
                intentEventMessage.setStatus(status);
                break;
            }
            case 4: {
                String text = MapUtils.getString((Map)function, (Object)"content");
                if (StringUtils.isEmpty((CharSequence)text)) {
                    return null;
                }
                intentEventMessage.setMessage(text);
                event = SseEventlEnum.MESSAGE_DELTA.getEvent();
            }
        }
        intentEventMessage.setType(functionType.getType());
        intentEventMessage.setMessage_type(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType());
        EventMessageData messageData = EventMessageData.builder().content(message).messageType(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType()).build();
        ConversationMessage questionMessage = sseEventParam.getQuestionMessage();
        intentEventMessage.setEventData(StreamEventData.builder().message(messageData).messageId(sseEventParam.getAnswerMessageId()).messageIndex(sseEventParam.getAnswerMessageIndex()).localMessageId(questionMessage.getLocalMessageId()).conversationId(questionMessage.getConversationId()).build());
        return new EventData(event, (EventData.EventMessage)intentEventMessage);
    }

    public static EventData convertAnswerEventData(JSONObject data, SseEventParams sseEventParam) {
        EventMessageData messageData;
        LOGGER.info("convertAnswerEventData is start data:{}", (Object)BaseUseUtils.toJsonString((Object)data));
        String message = MapUtils.getString((Map)data, (Object)"message");
        if (StringUtils.isEmpty((CharSequence)message)) {
            LOGGER.info("convertAnswerEventData message isEmpty data:{}", (Object)BaseUseUtils.toJsonString((Object)data));
            return null;
        }
        LOGGER.info("convertAnswerEventData message:{}", (Object)message);
        String messageType = MapUtils.getString((Map)data, (Object)"message_type", (String)SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType());
        if (SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType().equals(messageType)) {
            String text = new JSONObject().fluentPut(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), (Object)message).toJSONString();
            messageData = EventMessageData.builder().text(message).content(text).messageType(messageType).build();
        } else if (SseEventlEnum.EventDataMessageEnum.CARD.getMessageType().equals(messageType) || SseEventlEnum.EventDataMessageEnum.FILE.getMessageType().equals(messageType)) {
            messageData = EventMessageData.builder().text(message).content(message).messageType(messageType).build();
        } else {
            String text = new JSONObject().fluentPut(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), (Object)message).toJSONString();
            messageData = EventMessageData.builder().text(message).content(text).messageType(messageType).build();
        }
        return EventSourceListenerUtils.buildEventData((SseEventParams)sseEventParam, (SseEventlEnum)SseEventlEnum.MESSAGE_DELTA, (SseEventlEnum.SseEventDataTypeEnum)SseEventlEnum.SseEventDataTypeEnum.ANSWER, (EventMessageData)messageData);
    }

    public static EventData buildEventData(SseEventParams sseEventParam, SseEventlEnum eventEnum, SseEventlEnum.SseEventDataTypeEnum eventDataTypeEnum, EventMessageData messageData) {
        ConversationMessage questionMessage = sseEventParam.getQuestionMessage();
        EventData.EventMessage event = new EventData.EventMessage(eventDataTypeEnum.getType(), messageData.getMessageType(), messageData.getContent());
        event.setMessageId(sseEventParam.getAnswerMessageId());
        event.setMessageIndex(sseEventParam.getAnswerMessageIndex());
        event.setLocalMessageId(questionMessage.getLocalMessageId());
        event.setConversationId(questionMessage.getConversationId());
        event.setEventData(StreamEventData.builder().message(messageData).messageId(sseEventParam.getAnswerMessageId()).messageIndex(sseEventParam.getAnswerMessageIndex()).localMessageId(questionMessage.getLocalMessageId()).conversationId(questionMessage.getConversationId()).build());
        return new EventData(eventEnum.getEvent(), event);
    }
}

