/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.util;

import com.digiwin.athena.ania.common.AgoraConstant;
import com.digiwin.athena.appcore.util.SpringUtil;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

/*
 * Exception performing whole class analysis ignored.
 */
public class RedisUtils {
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);
    private static StringRedisTemplate stringRedisTemplate;
    private static RedisTemplate redisTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StringRedisTemplate getStringRedisTemplate() {
        if (!Objects.isNull(stringRedisTemplate)) return stringRedisTemplate;
        Class<RedisUtils> clazz = RedisUtils.class;
        synchronized (RedisUtils.class) {
            if (!Objects.isNull(stringRedisTemplate)) return stringRedisTemplate;
            stringRedisTemplate = (StringRedisTemplate)SpringUtil.getBean(StringRedisTemplate.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return stringRedisTemplate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisTemplate getRedisTemplate() {
        if (!Objects.isNull(redisTemplate)) return redisTemplate;
        Class<RedisUtils> clazz = RedisUtils.class;
        synchronized (RedisUtils.class) {
            if (!Objects.isNull(redisTemplate)) return redisTemplate;
            redisTemplate = (RedisTemplate)SpringUtil.getBean((String)"redisTemplate");
            // ** MonitorExit[var0] (shouldn't be in output)
            return redisTemplate;
        }
    }

    public static void insertAppToken(String appToken) {
        RedisUtils.getStringRedisTemplate().opsForValue().setIfAbsent((Object)"agora:appToken", (Object)appToken, (long)AgoraConstant.AGORA_APP_TOKEN_REDIS_HOUR.intValue(), TimeUnit.HOURS);
    }

    public static Boolean hasAppTokenKey() {
        return RedisUtils.getStringRedisTemplate().hasKey((Object)"agora:appToken");
    }

    public static String getAppTokenFromRedis() {
        return (String)RedisUtils.getStringRedisTemplate().opsForValue().get((Object)"agora:appToken");
    }

    public static Boolean deleteAppTokenFromRedis() {
        return RedisUtils.getStringRedisTemplate().delete((Object)"agora:appToken");
    }

    public static String getCacheStrData(String key) {
        try {
            return (String)RedisUtils.getStringRedisTemplate().opsForValue().get((Object)key);
        }
        catch (Exception ex) {
            log.error("getCacheStrData is error key:{}", (Object)key, (Object)ex);
            return null;
        }
    }

    public static boolean cacheStrData(String key, String value) {
        try {
            RedisUtils.getStringRedisTemplate().opsForValue().set((Object)key, (Object)value);
            return true;
        }
        catch (Exception ex) {
            log.error("cacheStringData is error key:{},value:{}", new Object[]{key, value, ex});
            return false;
        }
    }

    public static boolean cacheStrData(String key, String value, long timeout, TimeUnit unit) {
        try {
            RedisUtils.getStringRedisTemplate().opsForValue().set((Object)key, (Object)value, timeout, unit);
            return true;
        }
        catch (Exception ex) {
            log.error("cacheStringData is error key:{},value:{},timeout:{},unit:{}", new Object[]{key, value, timeout, unit, ex});
            return false;
        }
    }

    public static void deleteCacheStrData(String key) {
        try {
            RedisUtils.getStringRedisTemplate().delete((Object)key);
        }
        catch (Exception ex) {
            log.error("deleteCacheStrData is error key:{}", (Object)key, (Object)ex);
        }
    }

    public static Boolean hasStrDataKey(String key) {
        try {
            return RedisUtils.getStringRedisTemplate().hasKey((Object)key);
        }
        catch (Exception ex) {
            log.error("hasStrDataKey is error key:{}", (Object)key, (Object)ex);
            return Boolean.FALSE;
        }
    }

    public static Object getCacheObjData(String key) {
        try {
            return RedisUtils.getRedisTemplate().opsForValue().get((Object)key);
        }
        catch (Exception ex) {
            log.error("getCacheObjData is error key:{}", (Object)key, (Object)ex);
            return null;
        }
    }

    public static boolean cacheObjData(String key, Object value) {
        try {
            RedisUtils.getRedisTemplate().opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception ex) {
            log.error("cacheObjData is error key:{},value:{}", new Object[]{key, value, ex});
            return false;
        }
    }

    public static boolean cacheObjData(String key, Object value, long timeout, TimeUnit unit) {
        try {
            RedisUtils.getRedisTemplate().opsForValue().set((Object)key, value, timeout, unit);
            return true;
        }
        catch (Exception ex) {
            log.error("cacheObjData is error key:{},value:{},timeout:{},unit:{}", new Object[]{key, value, timeout, unit, ex});
            return false;
        }
    }

    public static void deleteCacheObjData(String key) {
        try {
            RedisUtils.getRedisTemplate().delete((Object)key);
        }
        catch (Exception ex) {
            log.error("deleteCacheObjData is error key:{}", (Object)key, (Object)ex);
        }
    }

    public static Boolean hasObjDataKey(String key) {
        try {
            return RedisUtils.getRedisTemplate().hasKey((Object)key);
        }
        catch (Exception ex) {
            log.error("hasObjDataKey is error key:{}", (Object)key, (Object)ex);
            return Boolean.FALSE;
        }
    }

    public static boolean isAllowed(String key, int limit) {
        String luaScript = "local key = KEYS[1] local limit = tonumber(ARGV[1]) local current = redis.call('get', key) if current and tonumber(current) >= limit then return 0 end if current then     redis.call('incr', key)     redis.call('expire', key, 1) else     redis.call('set', key, 1)     redis.call('expire', key, 1) end return 1";
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setScriptText(luaScript);
        redisScript.setResultType(Long.class);
        Long isAllowed = Long.parseLong(String.valueOf(RedisUtils.getStringRedisTemplate().execute((RedisScript)redisScript, (RedisSerializer)new StringRedisSerializer(), (RedisSerializer)new Jackson2JsonRedisSerializer(Object.class), Collections.singletonList(key), new Object[]{String.valueOf(limit)})));
        return isAllowed != null && isAllowed == 1L;
    }

    public static boolean noKey(String key, long durationWaitTime) {
        long retryInterval = 50L;
        for (long waitTime = 0L; waitTime < durationWaitTime; waitTime += retryInterval) {
            Boolean b = RedisUtils.hasStrDataKey((String)key);
            if (!BooleanUtils.isTrue((Boolean)b)) {
                return true;
            }
            try {
                Thread.sleep(retryInterval);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    public static void convertAndSend(String channel, Object message) {
        RedisUtils.getRedisTemplate().convertAndSend("ANIA_SSE_DISCONNECT", message);
    }
}

