/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.agent.client;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.alibaba.ttl.TtlRunnable;
import com.digiwin.athena.ania.agent.client.AgentCallbackComponent;
import com.digiwin.athena.ania.agent.context.AgentContext;
import com.digiwin.athena.ania.agent.server.AgentSSeComponent;
import com.digiwin.athena.ania.common.DialogueModeEnum;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.configuration.RedisLock;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.knowledge.context.RichSseEmitter;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.Conversation;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.service.assistant.FusionAssistantService;
import com.digiwin.athena.ania.service.chat.BaseEmitterChatComponent;
import com.digiwin.athena.ania.service.conversation.ConversationIndexService;
import com.digiwin.athena.ania.service.conversation.ConversationMessageService;
import com.digiwin.athena.ania.service.notice.NoticeService;
import com.digiwin.athena.ania.util.FastJsonUtils;
import com.digiwin.athena.ania.util.IdSnowflake;
import com.digiwin.athena.ania.util.LanguageUtils;
import com.digiwin.athena.ania.util.MdcUtil;
import com.digiwin.athena.ania.util.RedisUtils;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.google.common.collect.Lists;
import com.navercorp.pinpoint.sdk.v1.concurrent.TraceRunnable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class AgentCallbackComponent
extends BaseEmitterChatComponent {
    private static final Logger log = LoggerFactory.getLogger(AgentCallbackComponent.class);
    @Resource
    private ConversationIndexService conversationIndexService;
    @Resource
    private FusionAssistantService fusionAssistantService;
    @Resource
    private AgentSSeComponent agentSSeComponent;
    @Resource
    private Executor taskExecutorKnow;
    @Resource
    private NoticeService noticeService;
    @Resource
    private RedisLock redisLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RichSseEmitter topicChatAction(SseEventParams sseEventParam, boolean isTopic) {
        RichSseEmitter richSseEmitter;
        com.alibaba.fastjson2.JSONObject text;
        List<Object> content = new ArrayList();
        List attachment = sseEventParam.getAgentChatInfo().getMessage().getAttachment();
        if (CollectionUtils.isNotEmpty((Collection)attachment)) {
            content = attachment.stream().map(item -> {
                try {
                    return BeanUtils.describe((Object)item);
                }
                catch (Exception e) {
                    throw BusinessException.create((String)" attachment error");
                }
            }).collect(Collectors.toList());
        }
        com.alibaba.fastjson2.JSONObject jSONObject = text = StringUtils.isNotBlank((CharSequence)sseEventParam.getAgentChatInfo().getMessage().getContent()) ? JSON.parseObject((String)sseEventParam.getAgentChatInfo().getMessage().getContent()) : null;
        if (Objects.nonNull(text)) {
            if (StringUtils.isBlank((CharSequence)text.getString("text"))) {
                throw BusinessException.create((String)" message error");
            }
            text.put((Object)"type", (Object)"text");
        }
        if (Objects.nonNull(text)) {
            content.add(text);
        }
        if (CollectionUtils.isEmpty(content)) {
            throw BusinessException.create((String)" message isEmpty");
        }
        ConversationMessage questionMessage = new ConversationMessage();
        questionMessage.setMessageId(IdSnowflake.snowflakeIdStr());
        questionMessage.setLocalMessageId(sseEventParam.getAgentChatInfo().getLocalMessageId());
        questionMessage.setUserId(sseEventParam.getUser().getUserId());
        questionMessage.setTenantId(sseEventParam.getUser().getTenantId());
        questionMessage.setUserType(1);
        questionMessage.setStatus(Integer.valueOf(1));
        questionMessage.setContent(content);
        questionMessage.setExt((Map)JSON.parseObject((String)sseEventParam.getAgentChatInfo().getMessage().getExt()));
        questionMessage.setMsgExt(sseEventParam.getAgentChatInfo().getMessage().getExt());
        String tryLock = null;
        String lockKey = "ania:conversation:chat:" + sseEventParam.getAgentChatInfo().getConversationId();
        try {
            if (StringUtils.isNotBlank((CharSequence)sseEventParam.getAgentChatInfo().getConversationId()) && (Objects.isNull(tryLock = this.redisLock.tryLock(lockKey = "ania:his:chat:" + sseEventParam.getAgentChatInfo().getConversationId(), 5000L)) || RedisUtils.hasStrDataKey((String)("ANIA:ASSISTANT:CHAT:" + sseEventParam.getAgentChatInfo().getConversationId())).booleanValue())) {
                throw BusinessException.create((String)"{\n  \"error_type\": \"chat.user_pushing\",\n  \"message\": \"\u53d1\u9001\u9891\u7387\u8fc7\u9ad8\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5.\"\n}");
            }
            Conversation conversation = this.buildConversation(sseEventParam, questionMessage, isTopic);
            questionMessage.setConversationId(conversation.getConversationId());
            questionMessage.setAgentId(conversation.getAgentId());
            questionMessage.setSectionId(conversation.getSectionId());
            RedisUtils.cacheStrData((String)("ANIA:ASSISTANT:CHAT:" + conversation.getConversationId()), (String)questionMessage.getMessageId(), (long)5L, (TimeUnit)TimeUnit.MINUTES);
            this.conversationMessageService.sendMessage(questionMessage);
            this.readMessage(questionMessage);
            Integer answerMessageIndex = this.conversationIndexService.incrementIndex(questionMessage.getUserId(), questionMessage.getConversationId());
            this.updateConversationTime(conversation.getConversationId(), questionMessage.getUpdateTime().longValue());
            conversation.setUpdateTime(questionMessage.getCreateTime());
            sseEventParam.setQuestionMessage(questionMessage);
            sseEventParam.setAnswerMessageId(IdSnowflake.snowflakeIdStr());
            sseEventParam.setAnswerMessageIndex(answerMessageIndex);
            sseEventParam.setLanguage(LanguageUtils.processSseLanguage());
            sseEventParam.setTraceId(MdcUtil.getPtxOrTraceId());
            RichSseEmitter sseEmitter = new RichSseEmitter(Long.valueOf(300000L));
            sseEventParam.setId(questionMessage.getMessageId());
            AgentContext.setSseEmitter((String)questionMessage.getMessageId(), (SseEmitter)sseEmitter);
            sseEmitter.onTimeout(TraceRunnable.asyncEntry((Runnable)new TimeoutCallback(this, sseEventParam, null)));
            sseEmitter.onError((Consumer)new ErrorCallback(this, sseEventParam, null));
            sseEmitter.onCompletion(TraceRunnable.asyncEntry((Runnable)new CompletionCallback(this, sseEventParam, null)));
            sseEmitter.setSseEventParams(sseEventParam);
            CompletableFuture.runAsync((Runnable)Objects.requireNonNull(TtlRunnable.get((Runnable)new AssistantChatAction(this, sseEventParam, null))), this.taskExecutorKnow);
            richSseEmitter = sseEmitter;
        }
        catch (Throwable throwable) {
            if (Objects.nonNull(tryLock)) {
                this.redisLock.unlock(lockKey, tryLock);
            }
            throw throwable;
        }
        if (Objects.nonNull(tryLock)) {
            this.redisLock.unlock(lockKey, tryLock);
        }
        return richSseEmitter;
    }

    private Conversation buildConversation(SseEventParams sseEventParam, ConversationMessage questionMessage, boolean isTopic) {
        Conversation conversation = null;
        String conversationId = sseEventParam.getAgentChatInfo().getConversationId();
        if (StringUtils.isNotBlank((CharSequence)conversationId) && Objects.isNull(conversation = this.conversationService.getConversation(conversationId, null, sseEventParam.getUser().getTenantId(), sseEventParam.getUser().getUserId()))) {
            throw BusinessException.create((String)"Conversation is not exist");
        }
        if (Objects.isNull(conversation)) {
            if (!isTopic) {
                throw BusinessException.create((String)"Conversation is not exist");
            }
            FusionAssistantInfoDto param = FusionAssistantInfoDto.builder().assistantType(AssistantType.PUBLISH_ASSISTANT.getType()).assistantId(sseEventParam.getAgentChatInfo().getAssistantCode()).auth(Boolean.valueOf(true)).build();
            FusionAssistantVo fusionAssistantVo = this.fusionAssistantService.assistantBaseInfo(param, sseEventParam.getUser());
            if (Objects.isNull(fusionAssistantVo)) {
                throw BusinessException.create((String)"FusionAssistant Is No Permission OR No Exist");
            }
            if (!DialogueModeEnum.topicBasedDialogueMode.equals((Object)fusionAssistantVo.getDialogueModeEnum())) {
                throw BusinessException.create((String)"Chat Model Not Supported");
            }
            this.checkMessage(questionMessage, fusionAssistantVo);
            sseEventParam.setFusionAssistant(fusionAssistantVo);
            String title = "";
            String content = sseEventParam.getAgentChatInfo().getMessage().getContent();
            if (StringUtils.isNotBlank((CharSequence)content) && JSON.isValid((String)content) && StringUtils.isNotBlank((CharSequence)JSON.parseObject((String)content).getString("text"))) {
                title = JSON.parseObject((String)content).getString("text");
            }
            if (StringUtils.isBlank((CharSequence)title)) {
                title = LocalsEnum.isTw((String)LanguageUtils.processSseLanguage()) ? "\u65b0\u5c0d\u8a71" : "\u65b0\u5bf9\u8bdd";
            }
            conversation = this.conversationService.creatConversation(title, fusionAssistantVo, sseEventParam.getUser().getUserId(), sseEventParam.getUser().getTenantId());
        } else {
            FusionAssistantInfoDto param = FusionAssistantInfoDto.builder().assistantType(AssistantType.PUBLISH_ASSISTANT.getType()).assistantId(sseEventParam.getAgentChatInfo().getAssistantCode()).auth(Boolean.valueOf(true)).build();
            FusionAssistantVo fusionAssistantVo = this.fusionAssistantService.assistantBaseInfo(param, sseEventParam.getUser());
            if (Objects.isNull(fusionAssistantVo)) {
                throw BusinessException.create((String)"FusionAssistant is not exist");
            }
            this.checkMessage(questionMessage, fusionAssistantVo);
            sseEventParam.setFusionAssistant(fusionAssistantVo);
        }
        return conversation;
    }

    private void checkMessage(ConversationMessage questionMessage, FusionAssistantVo fusionAssistant) {
        List contentTypes;
        JSONObject inputConfig = fusionAssistant.getInputConfig();
        List type = null;
        if (MapUtils.isNotEmpty((Map)inputConfig)) {
            type = FastJsonUtils.toList((JSONArray)inputConfig.getJSONArray("type"), String.class);
            type.addAll(FastJsonUtils.toList((JSONArray)inputConfig.getJSONArray("options"), String.class));
        }
        if (CollectionUtils.isEmpty(type)) {
            type = Lists.newArrayList((Object[])new String[]{"text"});
        }
        if (!new HashSet(type).containsAll(contentTypes = questionMessage.getContent().stream().map(item -> MapUtils.getString((Map)item, (Object)"type", (String)"text").toString()).distinct().collect(Collectors.toList()))) {
            throw BusinessException.create((String)"Content Type Not Supported");
        }
        this.checkFileFormat(questionMessage, fusionAssistant);
    }

    private void checkFileFormat(ConversationMessage questionMessage, FusionAssistantVo fusionAssistant) {
        JSONObject inputConfig = fusionAssistant.getInputConfig();
        HashSet types = new HashSet();
        if (MapUtils.isNotEmpty((Map)inputConfig)) {
            JSONObject validation = inputConfig.getJSONObject("validation");
            if (null == validation || validation.isEmpty()) {
                return;
            }
            JSONArray image = validation.getJSONArray("image");
            JSONArray file = validation.getJSONArray("file");
            types.addAll(FastJsonUtils.toList((JSONArray)image, String.class));
            types.addAll(FastJsonUtils.toList((JSONArray)file, String.class));
        }
        List fileTypes = questionMessage.getContent().stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getOrDefault("fileType", "").toString())).map(item -> MapUtils.getString((Map)item, (Object)"fileType").toString()).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(types) && !types.containsAll(fileTypes)) {
            fileTypes.removeAll(types);
            String fileTypeStr = fileTypes.stream().collect(Collectors.joining(","));
            throw BusinessException.create((String)("fileType Not Supported [" + fileTypeStr + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(SseEventParams sseEventParam) {
        EventData completed = new EventData(SseEventlEnum.CHAT_COMPLETED.getEvent(), null);
        this.sseEventDataService.saveEventDataLog(sseEventParam, completed);
        EventData doneData = new EventData(SseEventlEnum.CHAT_FAILED.getEvent(), null);
        this.sseEventDataService.saveEventDataLog(sseEventParam, doneData);
        SseEmitter sseEmitter = AgentContext.getSseEmitter((String)sseEventParam.getId());
        if (Objects.nonNull(sseEmitter)) {
            try {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)completed);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)completed);
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)doneData);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)doneData);
            }
            catch (IOException e) {
                log.error("AgentCallbackComponent.sendAnswerDone is error", (Throwable)e);
            }
            finally {
                sseEmitter.complete();
            }
        }
    }

    static /* synthetic */ AgentSSeComponent access$400(AgentCallbackComponent x0) {
        return x0.agentSSeComponent;
    }

    static /* synthetic */ Logger access$500() {
        return log;
    }

    static /* synthetic */ String access$600(AgentCallbackComponent x0, SseEventParams x1, Throwable x2) {
        return x0.errorAnswer(x1, x2);
    }

    static /* synthetic */ SseEventDataService access$700(AgentCallbackComponent x0) {
        return x0.sseEventDataService;
    }

    static /* synthetic */ void access$800(AgentCallbackComponent x0, SseEventParams x1) {
        x0.stop(x1);
    }

    static /* synthetic */ SseEventDataService access$900(AgentCallbackComponent x0) {
        return x0.sseEventDataService;
    }

    static /* synthetic */ void access$1000(AgentCallbackComponent x0, ConversationMessage x1) {
        x0.readMessage(x1);
    }

    static /* synthetic */ NoticeService access$1100(AgentCallbackComponent x0) {
        return x0.noticeService;
    }

    static /* synthetic */ ConversationMessageService access$1200(AgentCallbackComponent x0) {
        return x0.conversationMessageService;
    }
}

