/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.agent.server;

import com.alibaba.fastjson2.JSONObject;
import com.digiwin.athena.ania.agent.context.AgentContext;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.knowledge.context.RichSseEmitter;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.util.RedisUtils;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class AgentConversationDeleteListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(AgentConversationDeleteListener.class);
    @Autowired
    private SseEventDataService sseEventDataService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message, byte[] pattern) {
        String conversationId = new String(message.getBody());
        conversationId = conversationId.replace("\"", "");
        log.info("AgentConversationDeleteListener.onMessage:{}", (Object)conversationId);
        String sseEmitterId = RedisUtils.getCacheStrData((String)("ANIA:ASSISTANT:CHAT:" + conversationId));
        if (StringUtils.isNotBlank((CharSequence)sseEmitterId)) {
            SseEventParams sseEventParams = null;
            try {
                RichSseEmitter richSseEmitter = AgentContext.getRichSseEmitter((String)sseEmitterId);
                if (richSseEmitter == null) {
                    sseEventParams = new SseEventParams();
                    sseEventParams.setId(sseEmitterId);
                    return;
                }
                sseEventParams = richSseEmitter.getSseEventParams();
                this.stop(sseEventParams);
            }
            catch (Exception e) {
                log.warn("AgentConversationDeleteListener.onMessage error", (Throwable)e);
            }
            finally {
                if (Objects.nonNull(sseEventParams)) {
                    AgentContext.getSseEmitter((String)sseEventParams.getId()).complete();
                }
            }
        }
    }

    private void stop(SseEventParams sseEventParam) {
        EventData completed = new EventData(SseEventlEnum.CHAT_COMPLETED.getEvent(), null);
        this.sseEventDataService.saveEventDataLog(sseEventParam, completed);
        EventData.EventMessage eventMessage = new EventData.EventMessage();
        eventMessage.setType(SseEventlEnum.SseEventDataTypeEnum.VERBOSE.getType());
        eventMessage.setMessage(new JSONObject().fluentPut("canceled", (Object)true).toString());
        EventData doneData = new EventData(SseEventlEnum.CHAT_DONE.getEvent(), eventMessage);
        this.sseEventDataService.saveEventDataLog(sseEventParam, doneData);
        SseEmitter sseEmitter = AgentContext.getSseEmitter((String)sseEventParam.getId());
        if (Objects.nonNull(sseEmitter)) {
            try {
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)completed);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)doneData);
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)completed);
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)doneData);
            }
            catch (IOException e) {
                log.error("AgentConversationDeleteListener.stop is error", (Throwable)e);
            }
        }
    }
}

