/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.agent.server;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.agent.server.AgentStrategy;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.service.conversation.ConversationService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class AgentSSeComponent {
    private static final Logger log = LoggerFactory.getLogger(AgentSSeComponent.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Resource
    private SseEventDataService sseEventDataService;
    @Resource
    private ConversationService conversationService;
    private Map<Integer, AgentStrategy> agentTypeStrategyMap = new HashMap();

    @Autowired
    public void setAgentStrategyMap(Map<String, AgentStrategy> agentStrategyMap) {
        agentStrategyMap.forEach((k, v) -> this.agentTypeStrategyMap.put(v.getAgentType(), v));
    }

    public void nlp(SseEventParams sseEventParam) {
        EventData.EventMessage eventMessage = new EventData.EventMessage();
        eventMessage.setType(SseEventlEnum.SseEventDataTypeEnum.VERBOSE.getType());
        ConversationMessage questionMessage = sseEventParam.getQuestionMessage();
        eventMessage.setMessage(new JSONObject().fluentPut("conversation_id", (Object)questionMessage.getConversationId()).fluentPut("message_id", (Object)questionMessage.getMessageId()).fluentPut("local_message_id", (Object)questionMessage.getLocalMessageId()).toString());
        EventData eventData = new EventData(SseEventlEnum.CHAT_CREATED.getEvent(), eventMessage);
        eventData.setEventId(sseEventParam.getId());
        this.sseEventDataService.sendAgentEventData(sseEventParam, eventData);
        ((AgentStrategy)this.agentTypeStrategyMap.get(sseEventParam.getAssistantType())).execute(sseEventParam);
    }
}

