/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.api.controller;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.ania.api.dto.AssistantApiDto;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.service.assistant.AssistantService;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u667a\u9a71\u52a9\u7406\u76f8\u5173Open API")
@RestController
@RequestMapping(value={"/ania/api/assistant"})
public class AssistantApiController {
    private static final Logger log = LoggerFactory.getLogger(AssistantApiController.class);
    @Resource
    private AssistantService assistantService;

    @GetMapping(value={"/getKnowledgeAssistants"})
    public ResultBean getKnowledgeAssistants(@RequestParam String code) {
        ArrayList<AssistantApiDto> assistantApiDtos = new ArrayList<AssistantApiDto>();
        Assistant assistant = this.assistantService.getAssistant(code);
        List assistantScenes = this.assistantService.getAssistantSceneByAssistant(code, "2.0");
        for (AssistantScene assistantScene : assistantScenes) {
            AssistantApiDto assistantApiDto = new AssistantApiDto();
            assistantApiDto.setAssistantCode(assistantScene.getCode());
            assistantApiDto.setName(assistantScene.getName());
            assistantApiDto.setDescription(assistantScene.getDescription());
            assistantApiDto.setCategory(assistant.getCategory());
            assistantApiDto.setAssistantType(assistant.getAssistantType());
            assistantApiDto.setAssistantSubType(assistant.getAssistantSubType());
            assistantApiDto.setKnowledgeBaseType(assistantScene.getKnowledgeBase().getString("type"));
            assistantApiDtos.add(assistantApiDto);
        }
        log.info("AssistantApiController.getKnowledgeAssistants responseData:{}", (Object)JSON.toJSONString(assistantApiDtos));
        return ResultBean.success(assistantApiDtos);
    }
}

