/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.common.enums;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ElementEnum {
    OTHER("other", "O", "\u6587\u672c", true),
    PEOPLE("people", "P", "\u5361\u7247\uff08\u53ea\u8bfb\u6587\u672c\uff09", true),
    DATE("date", "D", "\u65e5\u671f", true),
    DATETIME("datetime", "T", "\u65e5\u671f\u65f6\u95f4", true),
    TIME("time", "tt", "\u65e5\u671f\u65f6\u95f4", true),
    DATETIMERANGE("datetimeRange", "C", "\u65f6\u95f4\u533a\u95f4", true),
    DURATION("duration", "R", "\u65f6\u957f", true),
    INT("int", "I", "\u6570\u503c", true),
    PLACE("place", "L", "\u6587\u672c", true),
    LOCATION("location", "LL", "\u5b9a\u4f4d\u5730\u5740", true),
    BOOL("bool", "B", "\u5e03\u5c14", true),
    RADIO("radio", "", "\u5355\u9009", false),
    FILE("file", "", "\u6587\u4ef6", true),
    OBJECT("object", "", "\u6587\u672c", true),
    NOTHAVERADIO("notHaveRadio", "", "\u4e0d\u5fc5\u5355\u9009", false);

    private final String code;
    private final String simpleCode;
    private final String name;
    private final boolean basicType;

    public static boolean isValid(String type) {
        ElementEnum typeEnum = ElementEnum.getTypeEnum((String)type);
        return Objects.nonNull(typeEnum);
    }

    public static ElementEnum getTypeEnum(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        ElementEnum typeEnum = null;
        ElementEnum elementEnum = ElementEnum.valueOf((String)type.toUpperCase());
        if (Objects.nonNull(elementEnum) && Objects.equals(type, elementEnum.code)) {
            typeEnum = elementEnum;
        }
        return typeEnum;
    }

    public static ElementEnum getElementByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        for (ElementEnum elementEnum : ElementEnum.values()) {
            if (!elementEnum.code.equals(code)) continue;
            return elementEnum;
        }
        return null;
    }

    public static boolean isText(String code) {
        ElementEnum element = ElementEnum.getElementByCode((String)code);
        if (Objects.nonNull(element)) {
            return element.equals((Object)OTHER) || element.equals((Object)PLACE);
        }
        return false;
    }

    public static boolean isTime(String code) {
        ElementEnum element = ElementEnum.getElementByCode((String)code);
        if (Objects.nonNull(element)) {
            return element.equals((Object)DATE) || element.equals((Object)DATETIME) || element.equals((Object)DATETIMERANGE);
        }
        return false;
    }

    public static boolean isInt(String code) {
        ElementEnum element = ElementEnum.getElementByCode((String)code);
        if (Objects.nonNull(element)) {
            return element.equals((Object)INT);
        }
        return false;
    }

    public static boolean isBool(String code) {
        ElementEnum element = ElementEnum.getElementByCode((String)code);
        if (Objects.nonNull(element)) {
            return element.equals((Object)BOOL);
        }
        return false;
    }

    public static boolean isNotSelect(String code) {
        ElementEnum element = ElementEnum.getElementByCode((String)code);
        if (Objects.nonNull(element)) {
            return element.equals((Object)BOOL) || element.equals((Object)FILE) || element.equals((Object)PEOPLE);
        }
        return true;
    }

    public static boolean isNeedFile(String code) {
        ElementEnum element = ElementEnum.getElementByCode((String)code);
        if (Objects.nonNull(element)) {
            return element.equals((Object)OTHER) || element.equals((Object)PLACE);
        }
        return false;
    }

    public static String getElementCodeBySimpleCode(String simpleCode) {
        if (StringUtils.isBlank((CharSequence)simpleCode)) {
            return null;
        }
        for (ElementEnum elementEnum : ElementEnum.values()) {
            if (!elementEnum.simpleCode.equals(simpleCode)) continue;
            return elementEnum.code;
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getSimpleCode() {
        return this.simpleCode;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBasicType() {
        return this.basicType;
    }

    private ElementEnum(String code, String simpleCode, String name, boolean basicType) {
        this.code = code;
        this.simpleCode = simpleCode;
        this.name = name;
        this.basicType = basicType;
    }
}

