/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.configuration;

import com.google.common.eventbus.AsyncEventBus;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class AsyncEventConfig {
    @Value(value="${ania.asyncevent.corePoolSize:5}")
    private Integer corePoolSize;
    @Value(value="${ania.asyncevent.maxPoolSize:100}")
    private Integer maxPoolSize;
    @Value(value="${ania.asyncevent.queueCapacity:5000}")
    private Integer queueCapacity;
    @Value(value="${ania.asyncevent.keepAliveSeconds:60}")
    private Integer keepAliveSeconds;
    @Value(value="${ania.asyncevent.rejectHandler:discard}")
    private String rejectHandler;

    @Bean
    @Primary
    public AsyncEventBus asyncEventBus() {
        Executor executor = this.asyncEventBusExecutor();
        return new AsyncEventBus(executor);
    }

    @Bean
    public Executor asyncEventBusExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.corePoolSize.intValue());
        executor.setMaxPoolSize(this.maxPoolSize.intValue());
        executor.setQueueCapacity(this.queueCapacity.intValue());
        executor.setKeepAliveSeconds(this.keepAliveSeconds.intValue());
        executor.setThreadNamePrefix("AsyncEventBus");
        if ("abort".equals(this.rejectHandler)) {
            executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        } else if ("discard".equals(this.rejectHandler)) {
            executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
        } else if ("discardOldest".equals(this.rejectHandler)) {
            executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy());
        } else if ("callerRuns".equals(this.rejectHandler)) {
            executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        }
        executor.initialize();
        return executor;
    }
}

