/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.configuration;

import com.digiwin.athena.ania.configuration.CustomerWebMvcConfigurationSupport;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.List;
import java.util.Locale;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
public class CustomerWebMvcConfigurationSupport
extends WebMvcConfigurationSupport {
    protected void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (HttpMessageConverter<?> httpMessageConverter : converters) {
            if (!MappingJackson2HttpMessageConverter.class.isInstance(httpMessageConverter)) continue;
            ((MappingJackson2HttpMessageConverter)httpMessageConverter).setObjectMapper(JsonUtils.createObjectMapper());
        }
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOriginPatterns(new String[]{"*"}).allowedMethods(new String[]{"POST", "GET", "PUT", "OPTIONS", "DELETE", "PATCH", "HEAD", "FETCH"}).allowedHeaders(new String[]{"*"}).maxAge(3600L).exposedHeaders(new String[]{"Content-Disposition", "t"}).allowCredentials(true);
    }

    @Bean
    public LocaleResolver localeResolver() {
        1 localeResolver = new /* Unavailable Anonymous Inner Class!! */;
        localeResolver.setDefaultLocale(Locale.forLanguageTag("zh-CN"));
        return localeResolver;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"}).addResourceLocations(new String[]{"classpath:/resources/"}).addResourceLocations(new String[]{"classpath:/static/"});
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        registry.addResourceHandler(new String[]{"/swagger-ui/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/springfox-swagger-ui/"});
        super.addResourceHandlers(registry);
    }
}

