/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.configuration;

import java.nio.charset.Charset;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.stereotype.Service;

@Service
public class RedisLock {
    private static final Logger log = LoggerFactory.getLogger(RedisLock.class);
    private static final String unlockScript = "if redis.call(\"get\",KEYS[1]) == ARGV[1]\nthen\n    return redis.call(\"del\",KEYS[1])\nelse\n    return 0\nend";
    @Resource
    private RedisTemplate<String, String> stringRedisTemplate;

    public String lock(String name, long expire, long timeout) {
        String token;
        long startTime = System.currentTimeMillis();
        do {
            if ((token = this.tryLock(name, expire)) != null) continue;
            if (System.currentTimeMillis() - startTime > timeout - 50L) break;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
                return null;
            }
        } while (token == null);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tryLock(String name, long expire) {
        String token = UUID.randomUUID().toString();
        RedisConnectionFactory factory = this.stringRedisTemplate.getConnectionFactory();
        RedisConnection conn = factory.getConnection();
        try {
            Boolean result = conn.set(name.getBytes(Charset.forName("UTF-8")), token.getBytes(Charset.forName("UTF-8")), Expiration.from((long)expire, (TimeUnit)TimeUnit.MILLISECONDS), RedisStringCommands.SetOption.SET_IF_ABSENT);
            if (result != null && result.booleanValue()) {
                String string = token;
                return string;
            }
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)conn, (RedisConnectionFactory)factory);
        }
        return null;
    }

    public boolean acquireLock(String lockKey, String lockValue, long expireTimeMillis, long maxWaitTimeMillis) {
        long retryInterval = 50L;
        for (long waitTime = 0L; waitTime < maxWaitTimeMillis; waitTime += retryInterval) {
            Boolean success = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)lockValue, Duration.ofMillis(expireTimeMillis));
            if (Boolean.TRUE.equals(success)) {
                return true;
            }
            try {
                Thread.sleep(retryInterval);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    public void releaseLock(String lockKey) {
        this.stringRedisTemplate.delete((Object)lockKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(String name, String token) {
        byte[][] keysAndArgs = new byte[][]{name.getBytes(Charset.forName("UTF-8")), token.getBytes(Charset.forName("UTF-8"))};
        RedisConnectionFactory factory = this.stringRedisTemplate.getConnectionFactory();
        RedisConnection conn = factory.getConnection();
        try {
            Long result = (Long)conn.scriptingCommands().eval(unlockScript.getBytes(Charset.forName("UTF-8")), ReturnType.INTEGER, 1, (byte[][])keysAndArgs);
            if (result != null && result > 0L) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)conn, (RedisConnectionFactory)factory);
        }
        return false;
    }
}

