/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.configuration;

import com.digiwin.athena.ania.common.AlarmConstant;
import com.digiwin.athena.ania.common.enums.AlarmEnum;
import com.digiwin.athena.ania.configuration.SpringContextHolder;
import com.digiwin.athena.ania.entity.AlarmRequest;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.IamHelper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.MessageUtils;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;

@Component
public class RestTemplateErrorHandlerInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateErrorHandlerInterceptor.class);
    @Autowired
    MessageUtils messageUtils;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    EnvProperties envProperties;
    @Autowired
    WebClient.Builder webClientBuilder;
    static final String alarmMessage = "/restful/standard/alarm/message";
    private WebClient webClient;

    @PostConstruct
    public void init() {
        this.webClient = this.webClientBuilder.baseUrl(this.envProperties.getSmartDataAlarm()).build();
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse response = null;
        ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
        if (Objects.isNull(applicationContext)) {
            response = execution.execute(request, body);
        } else {
            try {
                response = execution.execute(request, body);
                if (!response.getStatusCode().is2xxSuccessful()) {
                    this.handleErrorResponse(request, response);
                }
            }
            catch (Exception e) {
                this.handleIOException(request, e);
            }
        }
        return response;
    }

    private void handleErrorResponse(HttpRequest request, ClientHttpResponse response) {
        this.recordAlarm(request.getURI());
    }

    private void handleIOException(HttpRequest request, Exception e) {
        this.recordAlarm(request.getURI());
    }

    private void recordAlarm(URI uri) {
        if (alarmMessage.equals(uri.getPath()) || !this.envProperties.isAlarm()) {
            return;
        }
        IamHelper iamHelper = (IamHelper)SpringContextHolder.getBean(IamHelper.class);
        try {
            String alarmCode = (String)AlarmConstant.ALARMMAP.get(uri.getPath());
            AlarmEnum alarmEnum = AlarmEnum.getAlarmEnum((String)alarmCode);
            if (Objects.nonNull(alarmEnum)) {
                String tenantId = "";
                if (Objects.nonNull(AppAuthContextHolder.getContext().getAuthoredUser())) {
                    tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
                }
                AlarmRequest alarmRequest = AlarmRequest.builder().appCode("ania").appId(alarmEnum.getAlarmComponent()).isError("1").errorCode(alarmCode).exception(this.messageUtils.getMessage(alarmCode)).pinpointId(Objects.nonNull(MDC.get((String)"PtxId")) ? MDC.get((String)"PtxId") : "").tenantId(StringUtils.isEmpty((CharSequence)tenantId) ? "asa" : tenantId).build();
                ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(alarmMessage, new Object[0])).header("Content-Type", new String[]{"application/json"})).header("token", new String[]{iamHelper.getTenantToken(StringUtils.isEmpty((CharSequence)tenantId) ? "asa" : tenantId)})).bodyValue((Object)alarmRequest).retrieve().bodyToMono(String.class).subscribe(response -> log.debug("\u5bf9\u63a5\u544a\u8b66\u5e73\u53f0\u54cd\u5e94: " + response));
            }
        }
        catch (Exception e) {
            log.error("report SD alarm error", (Throwable)e);
        }
    }
}

