/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.configuration;

import com.alibaba.ttl.threadpool.TtlExecutors;
import com.navercorp.pinpoint.sdk.v1.concurrent.TraceExecutors;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class ThreadPoolConfig {
    public static final int MIGRATE_MESSAGE_QUEUE_SIZE = 500;

    @Bean(value={"taskExecutorKnow"})
    public Executor taskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(100);
        executor.setMaxPoolSize(500);
        executor.setQueueCapacity(5000);
        executor.setKeepAliveSeconds(60);
        executor.setThreadNamePrefix("knowledge");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        executor.initialize();
        return TraceExecutors.wrapExecutor((Executor)executor, (boolean)true);
    }

    @Bean(value={"assistantListExecutor"})
    public ExecutorService assistantListExecutor() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(20, 500, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        return TraceExecutors.wrapExecutorService((ExecutorService)TtlExecutors.getTtlExecutorService((ExecutorService)threadPoolExecutor), (boolean)true);
    }

    @Bean(value={"migrateMessageThreadPool"})
    public ThreadPoolExecutor migrateMessageThreadPool() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 5, 40L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(500), (ThreadFactory)new NamedThreadFactory("m_m"), new ThreadPoolExecutor.AbortPolicy());
        threadPoolExecutor.prestartAllCoreThreads();
        return threadPoolExecutor;
    }

    @Bean
    public Executor streamMessage() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(5);
        executor.setMaxPoolSize(100);
        executor.setQueueCapacity(2000);
        executor.setKeepAliveSeconds(60);
        executor.setThreadNamePrefix("stream_message");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }
}

