/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.controller;

import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.dto.AssistantDeployerDto;
import com.digiwin.athena.ania.helper.AsaHelper;
import com.digiwin.athena.ania.service.AssistantManager;
import com.digiwin.athena.ania.service.assistant.FusionAssistantService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="assistant")
@RequestMapping(value={"/ania/athena/assistant"})
public class AssistantController {
    private static final Logger log = LoggerFactory.getLogger(AssistantController.class);
    @Resource
    private AssistantManager assistantManager;
    @Resource
    private AsaHelper asaHelper;
    @Autowired
    private FusionAssistantService fusionAssistantService;

    @GetMapping(value={"/queryAssistantCount"})
    @ApiOperation(value="B\u5a1c\u67e5\u8be2\u6709\u6743\u9650\u52a9\u7406\u7684\u6570\u91cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean queryAssistantCount(HttpServletRequest httpRequest) {
        String clientType = httpRequest.getParameter("clientType");
        List fusionAssistantVos = this.fusionAssistantService.assistantList(clientType, Boolean.valueOf(true));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("assistantCount", fusionAssistantVos.size());
        return ResultBean.success((Integer)0, map);
    }

    @GetMapping(value={"/queryAssistantAccidList"})
    @ApiOperation(value="B\u5a1c\u67e5\u8be2\u6709\u6240\u6709\u52a9\u7406\u7684accid")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean queryAssistantAccidList(HttpServletRequest httpRequest) {
        String clientType = httpRequest.getParameter("clientType");
        return ResultBean.success((Integer)0, (Object)this.assistantManager.queryAssistantAccidList(clientType));
    }

    @GetMapping(value={"/queryAssistantConfigList"})
    @ApiOperation(value="B\u5a1c\u67e5\u8be2\u6709\u6743\u9650\u7684\u52a9\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean queryAssistantConfigList(HttpServletRequest httpRequest) {
        String clientType = httpRequest.getParameter("clientType");
        String language = httpRequest.getHeader("locale");
        Map map = this.assistantManager.queryAssistantConfigList(clientType, language);
        return ResultBean.success((Integer)0, (Object)map);
    }

    @GetMapping(value={"/saveUserLastAssistantMsgTime"})
    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u5404\u52a9\u7406\u6700\u540e\u53d1\u9001\u6d88\u606f\u7684\u65f6\u95f4\u6233")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header"), @ApiImplicitParam(name="Accept-Language", value="zh-TW/zh-CN", required=true, dataType="String", paramType="Header")})
    public ResultBean saveUserLastAssistantMsgTime(@RequestParam String assistanceCode, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        this.assistantManager.saveUserLastAssistantMsgTime(assistanceCode, String.valueOf(System.currentTimeMillis()), authoredUser);
        return ResultBean.success((Object)"success");
    }

    @PostMapping(value={"/deployerCache"})
    @ApiOperation(value="\u53d1\u7248\u5207\u7248\u540e\u66f4\u65b0\u52a9\u7406\u76f8\u5173\u7f13\u5b58")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean<String> deployerCache(@RequestBody @Validated AssistantDeployerDto assistantDeployer) {
        ResultBean resultBean = this.assistantManager.deployerCache(assistantDeployer);
        this.asaHelper.deployerNotice(assistantDeployer);
        return resultBean;
    }
}

