/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.controller;

import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.service.brush.BrushAppAssistantRelationComponent;
import com.digiwin.athena.ania.service.brush.HisMgsMigrateConversationComponent;
import com.digiwin.athena.ania.service.brush.RemoveOrRestoreAssistantComponent;
import com.digiwin.athena.ania.util.RedisUtils;
import com.navercorp.pinpoint.sdk.v1.concurrent.TraceRunnable;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ania/brush"})
public class BrushDataController {
    private static final Logger log = LoggerFactory.getLogger(BrushDataController.class);
    @Value(value="${rest-url.appToken}")
    private String appToken;
    @Resource
    private HisMgsMigrateConversationComponent hisMgsMigrateConversationComponent;
    @Resource
    private BrushAppAssistantRelationComponent brushAppAssistantRelationComponent;
    @Resource
    private RemoveOrRestoreAssistantComponent removeOrRestoreAssistantComponent;

    @GetMapping(value={"/message/migrate/conversation"})
    public ResultBean<String> migrate(String authCode, String assistantCode, Long startTimestamp) {
        if (StringUtils.isBlank((CharSequence)authCode) || !authCode.equals(this.appToken)) {
            return ResultBean.fail((String)"\u6ca1\u6709\u6743\u9650\u8bbf\u95ee");
        }
        if (RedisUtils.hasStrDataKey((String)"ANIA:MessageMigrateAgoraService:Migrate:STATUS").booleanValue()) {
            return ResultBean.fail((String)"\u8fc1\u79fb\u6b63\u5728\u6267\u884c\u4e2d");
        }
        CompletableFuture.runAsync(TraceRunnable.asyncEntry(() -> this.hisMgsMigrateConversationComponent.migrate(assistantCode, startTimestamp)));
        return ResultBean.success();
    }

    @GetMapping(value={"/assistant/relation/his"})
    public ResultBean<String> hisAppAssistantRelation(String authCode, String assistantCode) {
        if (StringUtils.isBlank((CharSequence)authCode) || !authCode.equals(this.appToken)) {
            return ResultBean.fail((String)"\u6ca1\u6709\u6743\u9650\u8bbf\u95ee");
        }
        this.brushAppAssistantRelationComponent.hisAppAssistantRelation(assistantCode);
        return ResultBean.success();
    }

    @GetMapping(value={"/assistant/relation/publish"})
    public ResultBean<String> publishAppAssistantRelation(String authCode, String assistantCode) {
        if (StringUtils.isBlank((CharSequence)authCode) || !authCode.equals(this.appToken)) {
            return ResultBean.fail((String)"\u6ca1\u6709\u6743\u9650\u8bbf\u95ee");
        }
        this.brushAppAssistantRelationComponent.publishAppAssistantRelation(assistantCode);
        return ResultBean.success();
    }

    @GetMapping(value={"/assistant/remove"})
    public ResultBean<String> removeAssistant(String authCode, String assistantId) {
        if (StringUtils.isBlank((CharSequence)authCode) || !authCode.equals(this.appToken)) {
            return ResultBean.fail((String)"\u6ca1\u6709\u6743\u9650\u8bbf\u95ee");
        }
        this.removeOrRestoreAssistantComponent.remove(assistantId);
        return ResultBean.success();
    }

    @GetMapping(value={"/assistant/restore"})
    public ResultBean<String> restoreAssistant(String authCode, String assistantId) {
        if (StringUtils.isBlank((CharSequence)authCode) || !authCode.equals(this.appToken)) {
            return ResultBean.fail((String)"\u6ca1\u6709\u6743\u9650\u8bbf\u95ee");
        }
        this.removeOrRestoreAssistantComponent.restore(assistantId);
        return ResultBean.success();
    }
}

