/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.controller;

import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.dto.command.CommandChainDto;
import com.digiwin.athena.ania.dto.command.CommandChainPageVo;
import com.digiwin.athena.ania.dto.command.CommandChainQueryDto;
import com.digiwin.athena.ania.dto.command.CommandChainVo;
import com.digiwin.athena.ania.service.command.CommandChainService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ania/command/chain/"})
public class CommandChainController {
    private static final Logger log = LoggerFactory.getLogger(CommandChainController.class);
    @Resource
    private CommandChainService commandChainService;

    @PostMapping(value={"/list"})
    public ResultBean<CommandChainPageVo> queryCommandChain(@RequestBody CommandChainQueryDto query, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        return ResultBean.successful((Object)this.commandChainService.queryCommandChain(authoredUser, query));
    }

    @GetMapping(value={""})
    public ResultBean<List<CommandChainVo>> queryAssistantCommandChain(@RequestParam(value="assistantId") String assistantId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        return ResultBean.successful((Object)this.commandChainService.queryAssistantCommandChain(authoredUser, assistantId));
    }

    @PostMapping(value={"/add"})
    public ResultBean<CommandChainVo> add(@RequestBody @Validated CommandChainDto commandChain, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        return this.commandChainService.addCommandChain(authoredUser, commandChain);
    }

    @PostMapping(value={"/update"})
    public ResultBean<CommandChainVo> update(@RequestBody @Validated CommandChainDto commandChain, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        return this.commandChainService.updateCommandChain(authoredUser, commandChain);
    }

    @GetMapping(value={"/delete"})
    public ResultBean<Boolean> delete(@RequestParam(value="id") String id, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        return ResultBean.successful((Object)this.commandChainService.deleteCommandChain(authoredUser, id));
    }
}

