/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.aspect.Lock;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.controller.TestController;
import com.digiwin.athena.ania.dto.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.FusionAssistantInfoVo;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantPublishDto;
import com.digiwin.athena.ania.entity.ImMessageLog;
import com.digiwin.athena.ania.entity.MessageSearch;
import com.digiwin.athena.ania.entity.MigrateMessageMapping;
import com.digiwin.athena.ania.mapper.mongo.AsaKnowledgeMessageMapper;
import com.digiwin.athena.ania.mapper.mongo.MessageMongoMapper;
import com.digiwin.athena.ania.mapper.mongo.MessageSearchMongoMapper;
import com.digiwin.athena.ania.mapper.mongo.MigrateMessageMapper;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.ChatGptRequestLog;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.domain.EventAnswerDataLog;
import com.digiwin.athena.ania.mongo.domain.FusionAssistant;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantSub;
import com.digiwin.athena.ania.mongo.repository.AssistantDao;
import com.digiwin.athena.ania.mongo.repository.AssistantMgDao;
import com.digiwin.athena.ania.mongo.repository.ChatGptRequestLogMgDao;
import com.digiwin.athena.ania.mongo.repository.ConversationDao;
import com.digiwin.athena.ania.mongo.repository.ConversationMessageDao;
import com.digiwin.athena.ania.mongo.repository.EventAnswerDataLogMgDao;
import com.digiwin.athena.ania.mongo.repository.FusionAssistantMgDao;
import com.digiwin.athena.ania.mongo.repository.FusionAssistantSubMgDao;
import com.digiwin.athena.ania.proxy.dmc.service.DmcService;
import com.digiwin.athena.ania.service.IMigrateMessageService;
import com.digiwin.athena.ania.service.IMongoCopyService;
import com.digiwin.athena.ania.service.MessageSeachService;
import com.digiwin.athena.ania.service.assistant.FusionEventService;
import com.digiwin.athena.ania.service.conversation.ConversationIndexService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.dap.middleware.lmc.http.client.ServiceException;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/test"})
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Autowired
    private FusionEventService fusionEventService;
    @Resource
    private Executor taskExecutorKnow;
    @Autowired
    private AsaKnowledgeMessageMapper asaKnowledgeMessageMapper;
    @Autowired
    private EventAnswerDataLogMgDao eventAnswerDataLogMgDao;
    @Autowired
    private ChatGptRequestLogMgDao chatGptRequestLogMgDao;
    @Autowired
    private MessageMongoMapper messageMongoMapper;
    @Autowired
    private FusionAssistantMgDao fusionAssistantMgDao;
    @Autowired
    private FusionAssistantSubMgDao fusionAssistantSubMgDao;
    @Resource
    private DmcService dmcService;
    @Autowired
    private ConversationMessageDao conversationMessageDao;
    @Autowired
    private ConversationDao conversationDao;
    @Value(value="${rest-url.appToken}")
    private String appToken;
    @Autowired
    private ConversationIndexService conversationIndexService;
    @Resource
    private MessageSeachService messageSeachService;
    @Resource
    private AssistantDao assistantDao;
    @Resource
    private MessageSearchMongoMapper messageSearchMongoMapper;
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private ThreadPoolExecutor migrateMessageThreadPool;
    @Autowired
    private IMigrateMessageService migrateMessageService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private IMongoCopyService mongoCopyService;
    String migrateKey = "MIGRATE_MESSAGE_MAX_TIMESTAMP";
    String businessRefreshKey = "BUSINESS_REFRESH_MAX_TIMESTAMP";
    @Autowired
    MigrateMessageMapper migrateMessageMapper;
    @Autowired
    private AssistantMgDao assistantMgDao;

    @PostMapping(value={"/createData"})
    @Lock(key="createData", expire=200000L)
    public ResultBean createData(@RequestBody JSONObject map) throws Exception {
        return ResultBean.success();
    }

    @GetMapping(value={"/full/message/search"})
    @Lock(key="fullMessageSearch", expire=300000L)
    public ResultBean fullMessageSearch() {
        long timestamp = System.currentTimeMillis();
        List assistantList = this.assistantDao.findAll();
        HashSet<String> set = new HashSet<String>();
        for (Assistant assistant : assistantList) {
            if (assistant.getSourceCustom().booleanValue()) {
                if (!"asaca".equals(assistant.getAssistantCode()) && !"asaaa".equals(assistant.getAssistantCode())) continue;
                set.add(assistant.getAccid());
                continue;
            }
            if (!Objects.equals(3, assistant.getAssistantSubType()) && !Objects.equals(2, assistant.getAssistantSubType()) && !Objects.equals(4, assistant.getAssistantSubType())) continue;
            set.add(assistant.getAccid());
        }
        for (String accid : set) {
            CompletableFuture.runAsync(() -> this.handlerMessage(timestamp, accid), this.taskExecutorKnow);
        }
        return ResultBean.success(null);
    }

    private void handlerMessage(long timestamp, String accid) {
        long count = this.messageMongoMapper.count(timestamp, accid);
        int x = (int)count / 100;
        int y = (int)count % 100;
        int m = 1;
        m = y == 0 ? x + 1 : x + 2;
        long time = 0L;
        for (int i = 1; i < m; ++i) {
            List all;
            if (i == 1) {
                time = timestamp;
            }
            if (CollectionUtils.isNotEmpty((Collection)(all = this.messageMongoMapper.findAll(time, accid)))) {
                time = ((ImMessageLog)all.get(all.size() - 1)).getMsgTimestamp();
            }
            for (ImMessageLog imMessageLog : all) {
                MessageSearch messageSearch = this.messageSearchMongoMapper.findOne(imMessageLog.getMsgidServer());
                if (!Objects.isNull(messageSearch)) continue;
                this.messageSeachService.enterSearch(imMessageLog);
            }
        }
    }

    @GetMapping(value={"/common/string/redisDelete"})
    public String commonDeleteRedis(@RequestParam(value="key") String key) {
        this.redisTemplate.delete((Object)key);
        log.info("\u5220\u9664\u7f13\u5b58\u6210\u529f,key:{}", (Object)key);
        return "delete cache successfully";
    }

    @GetMapping(value={"/common/string/getByRedis"})
    public ResultBean getByRedis(String key) {
        return ResultBean.success((Object)this.redisTemplate.opsForValue().get((Object)key));
    }

    @PostMapping(value={"/common/string/setByRedis"})
    public ResultBean setByRedis(@RequestParam(value="key") String key, @RequestBody Assistant assistant) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)JSONUtil.toJsonStr((Object)assistant));
        return ResultBean.success((Object)"set successfully");
    }

    @PostMapping(value={"/common/string/setAnnualMeetingCache"})
    public ResultBean setAnnualMeetingCache(@RequestParam(value="flag") String flag, @RequestParam(value="tenantId") String tenantId) {
        this.redisTemplate.opsForValue().set((Object)"ANIA:HIS:ASSISTANT:annual:meeting:flag", (Object)flag);
        this.redisTemplate.opsForValue().set((Object)"ANIA:HIS:ASSISTANT:annual:meeting:tenantId", (Object)tenantId);
        return ResultBean.success((Object)"set successfully");
    }

    @GetMapping(value={"/copyCollection"})
    public String copyCollection(@RequestParam String source, @RequestParam String target) {
        this.mongoCopyService.copyCollection(source, target);
        return "Collection copied from " + source + " to " + target;
    }

    @PostMapping(value={"/gpt/message/sync/migrate"})
    public ResultBean syncMigrateMessage(@RequestParam(value="formAccount") String formAccount) {
        long start = System.currentTimeMillis();
        log.info("\u540c\u6b65\u65b9\u5f0f\uff1a\u4e91\u4fe1\u6d88\u606f\u8fc1\u79fb\u5230agora\u5f00\u59cb");
        Object msgMinTimestampObj = this.redisTemplate.opsForValue().get((Object)this.migrateKey);
        Long msgMinTimestamp = Objects.isNull(msgMinTimestampObj) ? new Date().getTime() : Long.parseLong(msgMinTimestampObj.toString());
        long count = this.messageMongoMapper.queryMessageCount(msgMinTimestamp, formAccount);
        if (count == 0L) {
            log.info("\u540c\u6b65\u65b9\u5f0f\uff1a\u6ca1\u6709\u9700\u8981\u8fc1\u79fb\u7684\u5386\u53f2\u6d88\u606f\uff0c\u8fc1\u79fb\u7ed3\u675f");
            return ResultBean.success((Object)"\u540c\u6b65\u65b9\u5f0f\uff1a\u6ca1\u6709\u9700\u8981\u8fc1\u79fb\u7684\u5386\u53f2\u6d88\u606f");
        }
        int pageSize = 200;
        int page = new Long(count).intValue() / pageSize + 1;
        for (int i = 0; i < page; ++i) {
            List messageLogList = this.messageMongoMapper.queryMessage(msgMinTimestamp, pageSize, formAccount);
            messageLogList.stream().forEach(messageLog -> {
                log.info("\u6d88\u606fid\uff1a{}", (Object)messageLog.getMsgidServer());
                this.migrateMessageService.syncMigrateMessage(messageLog);
            });
            msgMinTimestamp = Long.parseLong(String.valueOf(((ImMessageLog)messageLogList.get(messageLogList.size() - 1)).getMsgTimestamp()));
            if (!Strings.isEmpty((CharSequence)formAccount)) continue;
            this.redisTemplate.opsForValue().set((Object)this.migrateKey, (Object)msgMinTimestamp);
        }
        log.info("\u540c\u6b65\u65b9\u5f0f\uff1a\u4e91\u4fe1\u6d88\u606f\u8fc1\u79fb\u5230agora\u7ed3\u675f, \u5171\u6709\u6d88\u606f {}\u6761,\u8017\u65f6\uff1a{}ms", (Object)count, (Object)(System.currentTimeMillis() - start));
        return ResultBean.success((Object)("\u540c\u6b65\u65b9\u5f0f\uff1a\u4e91\u4fe1\u6d88\u606f\u8fc1\u79fb\u5230agora\u7ed3\u675f, \u5171\u6709\u6d88\u606f:" + count + "\u6761,\u8017\u65f6:" + (System.currentTimeMillis() - start) + "ms"));
    }

    @PostMapping(value={"/migrate/message/business/refresh"})
    public ResultBean handleMigrateMessage(@RequestParam(value="formAccount") String formAccount) {
        long start = System.currentTimeMillis();
        log.info("\u5f00\u59cb\u5904\u7406\u4e1a\u52a1\u6570\u636e");
        Object msgMinTimestampObj = this.redisTemplate.opsForValue().get((Object)this.businessRefreshKey);
        Long msgMinTimestamp = Objects.isNull(msgMinTimestampObj) ? new Date().getTime() : Long.parseLong(msgMinTimestampObj.toString());
        long count = this.migrateMessageMapper.queryMigrateMessageMappingCount(msgMinTimestamp, formAccount);
        if (count == 0L) {
            log.info("\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684id\u6620\u5c04\uff0c\u5904\u7406\u7ed3\u675f");
            return ResultBean.success((Object)"\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684id\u6620\u5c04\uff0c\u5904\u7406\u7ed3\u675f");
        }
        int pageSize = 200;
        int page = new Long(count).intValue() / pageSize + 1;
        for (int i = 0; i < page; ++i) {
            List migrateMessageMappingList = this.migrateMessageMapper.queryMigrateMessageMapping(msgMinTimestamp, pageSize, formAccount);
            migrateMessageMappingList.stream().forEach(migrateMessageMapping -> {
                log.info("\u6d88\u606fid\uff1a{}", (Object)migrateMessageMapping.getOriginalMsgidServer());
                this.migrateMessageService.handleMigrateMessage(migrateMessageMapping);
            });
            msgMinTimestamp = Long.parseLong(String.valueOf(((MigrateMessageMapping)migrateMessageMappingList.get(migrateMessageMappingList.size() - 1)).getCreateTime()));
            if (!Strings.isEmpty((CharSequence)formAccount)) continue;
            this.redisTemplate.opsForValue().set((Object)this.businessRefreshKey, (Object)msgMinTimestamp);
        }
        log.info("\u5904\u7406\u4e1a\u52a1\u6570\u636e\u7ed3\u675f, \u5171\u6709 {}\u6761,\u8017\u65f6\uff1a{}ms", (Object)count, (Object)(System.currentTimeMillis() - start));
        return ResultBean.success((Object)("\u5904\u7406\u4e1a\u52a1\u6570\u636e\u7ed3\u675f, \u5171\u6709" + count + "\u6761,\u8017\u65f6:" + (System.currentTimeMillis() - start) + "ms"));
    }

    @PostMapping(value={"/gpt/message/async/migrate"})
    @Deprecated
    public ResultBean asyncMigrateMessage(@RequestParam(value="formAccount") String formAccount) {
        long startTimeStamp = System.currentTimeMillis();
        log.info("\u4e91\u4fe1\u6d88\u606f\u8fc1\u79fb\u5230agora\u5f00\u59cb");
        Object msgMinTimestampObj = this.redisTemplate.opsForValue().get((Object)this.migrateKey);
        Long msgMinTimestamp = Objects.isNull(msgMinTimestampObj) ? new Date().getTime() : Long.parseLong(msgMinTimestampObj.toString());
        long count = this.messageMongoMapper.queryMessageCount(msgMinTimestamp, formAccount);
        if (count == 0L) {
            log.info("\u6ca1\u6709\u9700\u8981\u8fc1\u79fb\u7684\u5386\u53f2\u6d88\u606f\uff0c\u8fc1\u79fb\u7ed3\u675f");
            return ResultBean.success((Object)"\u6ca1\u6709\u9700\u8981\u8fc1\u79fb\u7684\u5386\u53f2\u6d88\u606f");
        }
        int pageSize = 200;
        int page = new Long(count).intValue() / pageSize + 1;
        LinkedBlockingQueue<Long> recordMsgTimestampQueue = new LinkedBlockingQueue<Long>(new Long(count).intValue());
        CompletableFuture.runAsync((Runnable)new RecordMsgTimestampRunnable(this, recordMsgTimestampQueue, formAccount));
        ArrayList futureList = new ArrayList();
        for (int i = 0; i < page; ++i) {
            List messageLogList = this.messageMongoMapper.queryMessage(msgMinTimestamp, pageSize, formAccount);
            messageLogList.stream().forEach(messageLog -> {
                try {
                    if (this.migrateMessageThreadPool.getQueue().size() < 500) {
                        futureList.add(this.migrateMessageThreadPool.submit((Runnable)new MigrateMessageRunnable(this, messageLog, recordMsgTimestampQueue)));
                    } else {
                        Thread.sleep(5L);
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
            msgMinTimestamp = Long.parseLong(String.valueOf(((ImMessageLog)messageLogList.get(messageLogList.size() - 1)).getMsgTimestamp()));
            if (i != page - 1) continue;
            while (!futureList.isEmpty()) {
                Iterator iterable = futureList.iterator();
                while (iterable.hasNext()) {
                    Future future = (Future)iterable.next();
                    if (future.isDone()) {
                        iterable.remove();
                        continue;
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        log.error("", (Throwable)e);
                    }
                }
            }
            try {
                recordMsgTimestampQueue.put(new Long(-1L));
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        long endTimeStamp = System.currentTimeMillis();
        log.info("\u4e91\u4fe1\u6d88\u606f\u8fc1\u79fb\u5230agora\u7ed3\u675f\uff0c\u8017\u65f6\uff1a" + (endTimeStamp - startTimeStamp) + " ms");
        return ResultBean.success((Object)("\u4e91\u4fe1\u6d88\u606f\u8fc1\u79fb\u5230agora\u7ed3\u675f\uff0c\u8017\u65f6\uff1a" + (endTimeStamp - startTimeStamp) + " ms"));
    }

    @PostMapping(value={"/v2/processquestion/log"})
    public ResultBean processQuestionLog(@RequestBody JSONObject jsonObject) {
        String secretKey = jsonObject.getString("secretKey");
        Assert.notBlank((CharSequence)secretKey, () -> new RuntimeException("\u79d8\u94a5\u4e0d\u80fd\u7b49\u4e8e\u7a7a"));
        Assert.isTrue((boolean)secretKey.equals(this.appToken), () -> new RuntimeException("\u65e0\u6743\u8bbf\u95ee"));
        String msgId = jsonObject.getString("msgId");
        String traceId = jsonObject.getString("traceId");
        if (StrUtil.isBlank((CharSequence)msgId) && StrUtil.isBlank((CharSequence)traceId)) {
            throw new ServiceException("\u53c2\u6570msgId,traceId\u90fd\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject asaKnowledge = this.asaKnowledgeMessageMapper.find(jsonObject);
        map.put("asaKnowledge", asaKnowledge);
        if (StrUtil.isBlank((CharSequence)msgId) && Objects.nonNull(asaKnowledge)) {
            msgId = asaKnowledge.getString("msgId");
        }
        if (StrUtil.isBlank((CharSequence)traceId) && Objects.nonNull(asaKnowledge)) {
            traceId = asaKnowledge.getString("traceId");
        }
        EventAnswerDataLog eventAnswerDataLog = new EventAnswerDataLog();
        eventAnswerDataLog.setRequestId(msgId);
        eventAnswerDataLog.setTraceId(traceId);
        List eventAnswerDataLogs = this.eventAnswerDataLogMgDao.findList(eventAnswerDataLog);
        map.put("eventAnswerDataLogs", eventAnswerDataLogs);
        if (StrUtil.isBlank((CharSequence)traceId) && CollectionUtils.isNotEmpty((Collection)eventAnswerDataLogs)) {
            traceId = ((EventAnswerDataLog)eventAnswerDataLogs.get(0)).getTraceId();
        }
        if (StrUtil.isNotBlank((CharSequence)traceId)) {
            ChatGptRequestLog chatGptRequestLog = new ChatGptRequestLog();
            chatGptRequestLog.setTraceId(traceId);
            List chatGptRequestLogs = this.chatGptRequestLogMgDao.findList(chatGptRequestLog);
            map.put("chatGptRequestLogs", chatGptRequestLogs);
        }
        if (StrUtil.isNotBlank((CharSequence)msgId)) {
            List imMessageLogs = this.messageMongoMapper.getMessageByMsgId(msgId);
            map.put("imMessageLogs", imMessageLogs);
            List conversationMessages = this.conversationMessageDao.findByMsgId(msgId);
            if (CollUtil.isNotEmpty((Collection)conversationMessages)) {
                Map messageMap = (Map)conversationMessages.get(0);
                String conversationId = (String)messageMap.get("conversationId");
                List conversationList = this.conversationDao.findList(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"conversationId").is((Object)conversationId)));
                map.put("conversation", conversationList);
                map.put("conversationMessage", conversationMessages);
            }
        }
        return ResultBean.success(map);
    }

    @PostMapping(value={"/refreshAssistantAccidList"})
    public ResultBean processQuestionLog() {
        List assistantList = this.assistantMgDao.findAll();
        if (CollectionUtils.isNotEmpty((Collection)assistantList)) {
            ArrayList accidList = new ArrayList();
            assistantList.stream().forEach(assistant -> accidList.add(assistant.getAccid()));
            this.redisTemplate.opsForValue().set((Object)"ASSISTANT:ALL:ACCID", (Object)JSON.toJSONString(accidList));
            return ResultBean.success((Object)"refreshAssistantAccidList success");
        }
        return ResultBean.success((Object)"assistantList is empty");
    }

    @PostMapping(value={"/assistant/chat"}, produces={"text/event-stream;charset=UTF-8"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public SseEmitter chat(@RequestBody JSONObject question, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        SseEmitterUTF8 emitter = new SseEmitterUTF8(this, Long.valueOf(300000L));
        new Thread(() -> TestController.lambda$chat$7(question, (SseEmitter)emitter)).start();
        return emitter;
    }

    @PostMapping(value={"/assistant/create/topic"})
    public ResultBean publish(@RequestBody FusionAssistantPublishDto dto) {
        this.fusionEventService.event(dto);
        return ResultBean.success((Object)"\u521b\u5efa\u6210\u529f");
    }

    @PostMapping(value={"/assistant/getInspirationPhrases"})
    public ResultBean getInspirationPhrases(@RequestBody FusionAssistantInfoDto fusionAssistantInfoDto) {
        FusionAssistantInfoDto.Assistant assistant = (FusionAssistantInfoDto.Assistant)fusionAssistantInfoDto.getAssistant().get(0);
        FusionAssistantInfoVo fusionAssistantInfoVo = new FusionAssistantInfoVo();
        FusionAssistantInfoVo.Assistant fusionAssistant = new FusionAssistantInfoVo.Assistant();
        fusionAssistant.setAssistantId(assistant.getAssistantId());
        ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>();
        for (int i = 0; i < 4; ++i) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("groupName", (Object)"\u7528\u6237\u6cd5\u5f8b");
            jsonObject.put("queryTemplates", (Object)ListUtil.toList((Object[])new JSONObject[]{new JSONObject().fluentPut("content", (Object)"\u7ecf\u6d4e\u7ea0\u7eb71"), new JSONObject().fluentPut("content", (Object)"\u7ecf\u6d4e\u7ea0\u7eb72")}));
            jsonObjectList.add(jsonObject);
        }
        fusionAssistant.setInspirationPhrases(jsonObjectList);
        fusionAssistantInfoVo.setAssistant((List)ListUtil.toList((Object[])new FusionAssistantInfoVo.Assistant[]{fusionAssistant}));
        return ResultBean.success((Object)fusionAssistantInfoVo);
    }

    @PostMapping(value={"/assistant/getPublishedInfo"})
    public ResultBean topicFusionAssistantInfo(@RequestBody FusionAssistantInfoDto fusionAssistantInfoDto) {
        FusionAssistantInfoDto.Assistant assistant = (FusionAssistantInfoDto.Assistant)fusionAssistantInfoDto.getAssistant().get(0);
        FusionAssistantInfoVo fusionAssistantInfoVo = new FusionAssistantInfoVo();
        FusionAssistantInfoVo.Assistant fusionAssistant = new FusionAssistantInfoVo.Assistant();
        fusionAssistant.setAssistantId(assistant.getAssistantId());
        fusionAssistant.setName("\u4ea7\u54c1\u539f\u578b\u8bbe\u8ba1\u52a9\u624b" + assistant.getAssistantId());
        fusionAssistant.setIconUrl("https://dmc-test.digiwincloud.com.cn/api/dmc/v2/file/Athena/share/22559fb8-987b-4fc3-8dac-b02b10fbb808");
        fusionAssistant.setVersion(assistant.getVersion());
        fusionAssistant.setDialogueMode(new JSONObject().fluentPut("mode", (Object)"topicBasedDialogueMode"));
        HashMap prologueLang = new HashMap();
        HashMap<String, String> prologue = new HashMap<String, String>();
        prologue.put("zh_CN", "\u5f88\u9ad8\u5174\u4e3a\u60a8\u670d\u52a1\uff0c\u8fd9\u91cc\u662ftopic\u6a21\u62df\u52a9\u7406");
        prologue.put("zh_TW", "\u5f88\u9ad8\u8208\u70ba\u60a8\u670d\u52d9\uff0c\u9019\u88cf\u662ftopic\u6a21\u64ec\u52a9\u7406");
        prologue.put("en_US", "\u5f88\u9ad8\u5174\u4e3a\u60a8\u670d\u52a1\uff0c\u8fd9\u91cc\u662ftopic\u6a21\u62df\u52a9\u7406");
        prologueLang.put("prologue", prologue);
        JSONObject prologueJSONObject = new JSONObject();
        prologueJSONObject.put("prologue", (Object)"\u5f88\u9ad8\u5174\u4e3a\u60a8\u670d\u52a1\uff0c\u8fd9\u91cc\u662ftopic\u6a21\u62df\u52a9\u7406");
        prologueJSONObject.put("lang", prologueLang);
        fusionAssistant.setOnboardingInfo(prologueJSONObject);
        fusionAssistant.setClientType((List)ListUtil.toList((Object[])new String[]{"WEB", "APP"}));
        JSONObject inputConfig = new JSONObject();
        inputConfig.put("placeholder", (Object)"\u53d1\u6d88\u606f\u3001\u8f93\u5165/\u4f7f\u7528\u6307\u4ee4");
        inputConfig.put("type", (Object)ListUtil.toList((Object[])new String[]{"text", "file"}));
        inputConfig.put("options", (Object)ListUtil.toList((Object[])new String[]{"image", "doc", "table"}));
        HashMap<String, ArrayList> validation = new HashMap<String, ArrayList>();
        validation.put("image", ListUtil.toList((Object[])new String[]{"jpg", "jpeg", "png", "gif", "svg", "HEIC", "HEIF"}));
        validation.put("file", ListUtil.toList((Object[])new String[]{"pdf", "txt", "doc", "docx", "xls", "xlsx", "ppt", "pptx", "wps"}));
        inputConfig.put("validation", validation);
        fusionAssistant.setInputConfig(inputConfig);
        String pluginCustoms = "[{\"description\":\"\u5b9a\u5236\u52a9\u7406\",\"isMF\":true,\"i18n\":false,\"name\":\"ania\",\"path\":\"remoteEntry.js\",\"root\":\"\",\"remoteName\":\"nanaPlugin\",\"packageName\":\"nana-plugin\",\"urlPrefixType\":\"nanaUrl\",\"languageModule\":{\"moduleName\":\"LanguageModule\",\"exposesPath\":\"LanguageModule\"},\"messageCardComponent\":{\"remoteName\":\"nanaPlugin\",\"type\":\"component\",\"exposedModule\":\"CustomCardComponent\",\"componentClassName\":\"CustomCardComponent\"},\"messageOptionsComponent\":{},\"topOptionsComponent\":{\"remoteName\":\"nanaPlugin\",\"type\":\"component\",\"exposedModule\":\"TopOperationSlotComponent\",\"componentClassName\":\"TopOperationSlotComponent\"},\"bottomOptionsComponent\":{\"remoteName\":\"nanaPlugin\",\"type\":\"component\",\"exposedModule\":\"BottomOptionCustomComponent\",\"componentClassName\":\"BottomOptionCustomComponent\"},\"noticeOptionsComponent\":{}}]";
        JSONArray jsonArray = JSONArray.parseArray((String)pluginCustoms);
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            jsonObjects.add(jsonObject);
        }
        fusionAssistant.setPluginCustoms(jsonObjects);
        fusionAssistantInfoVo.setAssistant((List)ListUtil.toList((Object[])new FusionAssistantInfoVo.Assistant[]{fusionAssistant}));
        this.assistantDao.deleteByAssistantCode(assistant.getAssistantId());
        return ResultBean.success((Object)fusionAssistantInfoVo);
    }

    @PostMapping(value={"/assistant/getVersion"})
    public ResultBean getVersion(@RequestBody FusionAssistantInfoDto fusionAssistantInfoDto) {
        List assistants = fusionAssistantInfoDto.getAssistant().stream().map(assistant -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("assistantId", assistant.getAssistantId());
            map.put("version", "1.0");
            return map;
        }).collect(Collectors.toList());
        return ResultBean.success((Object)new JSONObject().fluentPut("assistant", assistants));
    }

    @GetMapping(value={"/deleteCacheByPrefix"})
    public ResultBean deleteCacheByPrefix(@RequestParam(value="key") String key) {
        Set keys = this.redisTemplate.keys((Object)(key + "*"));
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            this.redisTemplate.delete((Collection)keys);
            log.info("\u5220\u9664\u7f13\u5b58\u6210\u529f,key:{}", (Object)keys);
        }
        return ResultBean.success((Object)"delete cache successfully");
    }

    @GetMapping(value={"/refreshPubAssistantCache"})
    public ResultBean refreshPublishFusionAssistantCache(@RequestParam(value="assistantId") String assistantId) {
        if (StringUtils.isBlank((CharSequence)assistantId)) {
            List fusionAssistantList = this.fusionAssistantMgDao.findVailableFusionAssistant();
            CollUtil.emptyIfNull((List)fusionAssistantList).forEach(assistant -> {
                String tmpAssistantId = assistant.getAssistantId();
                String assistantKey = "ANIA:PUBLISH:ASSISTANT:" + tmpAssistantId;
                this.redisTemplate.opsForValue().set((Object)assistantKey, (Object)JSONUtil.toJsonStr((Object)assistant));
                for (String version : assistant.getVersions()) {
                    FusionAssistantSub fusionAssistantSub = this.fusionAssistantSubMgDao.findByAssistantIdAndVersion(assistantId, version);
                    String assistantSubKey = "ANIA:ASSISTANT:SUB:" + version + tmpAssistantId;
                    this.redisTemplate.opsForValue().set((Object)assistantSubKey, (Object)JSONUtil.toJsonStr((Object)fusionAssistantSub));
                }
            });
        } else {
            FusionAssistant fusionAssistant = this.fusionAssistantMgDao.findByAssistantId(assistantId);
            String key = "ANIA:PUBLISH:ASSISTANT:" + assistantId;
            this.redisTemplate.opsForValue().set((Object)key, (Object)JSONUtil.toJsonStr((Object)fusionAssistant));
            for (String version : fusionAssistant.getVersions()) {
                FusionAssistantSub fusionAssistantSub = this.fusionAssistantSubMgDao.findByAssistantIdAndVersion(assistantId, version);
                String assistantSubKey = "ANIA:ASSISTANT:SUB:" + version + assistantId;
                this.redisTemplate.opsForValue().set((Object)assistantSubKey, (Object)JSONUtil.toJsonStr((Object)fusionAssistantSub));
            }
        }
        return ResultBean.success();
    }

    @PostMapping(value={"/install/uploadpkg"})
    public ResultBean<String> uploadpkg(@RequestParam(value="file") MultipartFile uploadFile) throws IOException {
        String originalFilename = uploadFile.getOriginalFilename();
        String fileName = originalFilename.substring(0, originalFilename.lastIndexOf("."));
        String directoryId = "463b3a7a-4bbd-4ab6-baa8-9803783f6788";
        if (fileName.equals("latest")) {
            directoryId = "00000000-0000-0000-0000-000000000000";
        }
        String fileId = this.dmcService.upload(uploadFile, fileName, directoryId);
        return ResultBean.success((Object)fileId);
    }

    @PostMapping(value={"/install/coverpkg"})
    public ResultBean<String> coverpkg(@RequestParam(value="file") MultipartFile uploadFile, @RequestBody JSONObject fileUpload) throws IOException {
        String fileId = fileUpload.getString("fileId");
        String fileData = this.dmcService.cover(uploadFile, fileId);
        return ResultBean.success((Object)fileData);
    }

    @PostMapping(value={"/install/sharepkg"})
    public ResultBean<String> sharepkg(@RequestBody JSONObject fileUpload) {
        Pair shareInfo = this.dmcService.shareFile(fileUpload.getString("fileId"), null);
        return ResultBean.success((Object)shareInfo.getLeft());
    }

    @GetMapping(value={"/fix/index"})
    public ResultBean fixIndex(String conversationId, String agentId) {
        List conversationList;
        ConversationMessage lastMessage;
        if (StrUtil.isNotBlank((CharSequence)conversationId) && Objects.nonNull(lastMessage = this.conversationMessageDao.getLastMessageByConversationId(conversationId))) {
            this.conversationIndexService.resetMaxIndex(null, lastMessage.getIndex().intValue(), lastMessage.getConversationId());
        }
        if (StrUtil.isNotBlank((CharSequence)agentId) && CollUtil.isNotEmpty((Collection)(conversationList = this.conversationDao.findByAgentId(agentId)))) {
            conversationList.forEach(conversation -> {
                ConversationMessage lastMessage = this.conversationMessageDao.getLastMessageByConversationId(conversation.getConversationId());
                if (Objects.nonNull(lastMessage)) {
                    this.conversationIndexService.resetMaxIndex(null, lastMessage.getIndex().intValue(), lastMessage.getConversationId());
                }
            });
        }
        return ResultBean.success();
    }

    private static /* synthetic */ void lambda$chat$7(JSONObject question, SseEmitter emitter) {
        String md;
        JSONObject questionMessage = question.getJSONObject("message");
        String content = questionMessage.getString("content");
        JSONObject followUpMsg1 = new JSONObject();
        JSONObject followUpMsg2 = new JSONObject();
        JSONObject followUpMsg3 = new JSONObject();
        if (content.contains("\u516c\u53f8") || content.contains("\u8d22\u52a1")) {
            md = "chatgpt/assistant/adviser/introduce_test_1.md";
            followUpMsg1.put("content", (Object)"\u5982\u4f55\u901a\u8fc7\u8d22\u52a1\u62a5\u8868\u5206\u6790\u516c\u53f8\u98ce\u9669?");
            followUpMsg2.put("content", (Object)"\u5982\u4f55\u5229\u7528\u8d22\u52a1\u62a5\u8868\u4e2d\u7684\u6570\u636e\u8bc4\u4f30\u516c\u53f8\u7684\u76c8\u5229\u80fd\u529b\uff1f");
        } else {
            md = "chatgpt/assistant/adviser/introduce_test_2.md";
            followUpMsg1.put("content", (Object)"\u5982\u4f55\u8bc4\u4f30\u4ea7\u54c1\u539f\u578b\u7684\u53ef\u884c\u6027?");
            followUpMsg2.put("content", (Object)"\u6709\u54ea\u4e9b\u5e38\u7528\u7684\u4ea7\u54c1\u539f\u578b\u8bbe\u8ba1\u5de5\u5177\uff1f");
            followUpMsg3.put("content", (Object)"\u600e\u6837\u5c06\u4ea7\u54c1\u539f\u578b\u8f6c\u5316\u4e3a\u53ef\u6267\u884c\u7684\u4ea7\u54c1\uff1f");
        }
        String function_call = "{\"type\":\"function_call\",\"message\":\"{\\\"message_type\\\":\\\"text\\\",\\\"status\\\":\\\"available\\\",\\\"extra_info\\\":{\\\"call_id\\\":\\\"4efceb21cbe14aa5abd74a4c7d833668\\\"},\\\"title\\\":\\\"\u5f00\u59cb\u7406\u89e3\u95ee\u9898\\\",\\\"arguments\\\":{}}\"}";
        String function_response = "{\"type\":\"tool_response\",\"message\":\"{\\\"message_type\\\":\\\"text\\\",\\\"status\\\":\\\"success\\\",\\\"extra_info\\\":{\\\"call_id\\\":\\\"4efceb21cbe14aa5abd74a4c7d833668\\\"}}\"}";
        ArrayList functions = Lists.newArrayList((Object[])new String[]{function_call, function_response});
        for (int i = 0; i < functions.size(); ++i) {
            try {
                emitter.send(SseEmitter.event().id(String.valueOf(System.currentTimeMillis())).name(SseEventlEnum.MESSAGE_COMPLETED.getEvent()).data(functions.get(i), MediaType.TEXT_PLAIN));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ClassPathResource(md).getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                JSONObject msgInfo = new JSONObject();
                msgInfo.fluentPut("type", (Object)"answer").fluentPut("message_type", (Object)"text").fluentPut("message", (Object)new String(line.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
                emitter.send(SseEmitter.event().id(String.valueOf(System.currentTimeMillis())).name(SseEventlEnum.MESSAGE_DELTA.getEvent()).data((Object)msgInfo.toJSONString(), MediaType.TEXT_PLAIN));
                Thread.sleep(20L);
                JSONObject breakmsgInfo = new JSONObject();
                breakmsgInfo.fluentPut("type", (Object)"answer").fluentPut("message_type", (Object)"text").fluentPut("message", (Object)"<br/>");
                emitter.send(SseEmitter.event().id(String.valueOf(System.currentTimeMillis())).name(SseEventlEnum.MESSAGE_DELTA.getEvent()).data((Object)breakmsgInfo.toJSONString(), MediaType.TEXT_PLAIN));
                Thread.sleep(100L);
            }
            JSONArray followUpMsgs = new JSONArray();
            followUpMsgs.add((Object)followUpMsg1);
            followUpMsgs.add((Object)followUpMsg2);
            if (!followUpMsg3.isEmpty()) {
                followUpMsgs.add((Object)followUpMsg3);
            }
            JSONObject followUpInfo = new JSONObject();
            followUpInfo.fluentPut("type", (Object)"follow_up").fluentPut("message", (Object)JSON.toJSONString((Object)followUpMsgs));
            emitter.send(SseEmitter.event().id(String.valueOf(System.currentTimeMillis())).name(SseEventlEnum.MESSAGE_COMPLETED.getEvent()).data((Object)followUpInfo.toJSONString(), MediaType.TEXT_PLAIN));
            Thread.sleep(20L);
            emitter.complete();
        }
        catch (IOException e) {
            try {
                emitter.send(SseEmitter.event().id("error").name("error").data((Object)("\u8bfb\u53d6\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage())));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            emitter.completeWithError((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            emitter.completeWithError((Throwable)e);
        }
        catch (Exception e) {
            emitter.completeWithError((Throwable)e);
        }
    }

    static /* synthetic */ IMigrateMessageService access$000(TestController x0) {
        return x0.migrateMessageService;
    }

    static /* synthetic */ RedisTemplate access$100(TestController x0) {
        return x0.redisTemplate;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }
}

