/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.controller.conversation;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.ania.agent.client.AgentCallbackComponent;
import com.digiwin.athena.ania.agent.server.AgentSSeComponent;
import com.digiwin.athena.ania.common.DialogueModeEnum;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.common.enums.ConversationTypeEnum;
import com.digiwin.athena.ania.dto.conversation.AgentQuestionDto;
import com.digiwin.athena.ania.dto.conversation.ConversationBreakDto;
import com.digiwin.athena.ania.dto.conversation.ConversationDeleteDto;
import com.digiwin.athena.ania.dto.conversation.ConversationInfoQueryDto;
import com.digiwin.athena.ania.dto.conversation.ConversationInfoVo;
import com.digiwin.athena.ania.dto.conversation.ConversationListVo;
import com.digiwin.athena.ania.dto.conversation.ConversationQueryDto;
import com.digiwin.athena.ania.dto.conversation.ConversationUpdateDto;
import com.digiwin.athena.ania.dto.conversation.ConversationVo;
import com.digiwin.athena.ania.dto.conversation.NewSessionDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.service.assistant.FusionAssistantService;
import com.digiwin.athena.ania.service.conversation.ConversationService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ania/assistant/conversation"})
public class ConversationController {
    private static final Logger log = LoggerFactory.getLogger(ConversationController.class);
    @Resource
    private ConversationService conversationService;
    @Resource
    private FusionAssistantService fusionAssistantService;
    @Resource
    private AgentCallbackComponent agentCallbackComponent;
    @Resource
    private AgentSSeComponent agentSSeComponent;

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u91cf\u5386\u53f2\u5bf9\u8bdd")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean<ConversationListVo> getConversationList(@RequestBody ConversationQueryDto queryDto) {
        log.info("ConversationController.getConversationList.start: {}", (Object)JSON.toJSONString((Object)queryDto));
        ConversationListVo result = this.conversationService.getConversations(queryDto);
        log.info("ConversationController.getConversationList.end");
        return ResultBean.success((Integer)0, (Object)result);
    }

    @PostMapping(value={"/info"})
    @ApiOperation(value="\u83b7\u53d6\u5386\u53f2\u5bf9\u8bdd\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean<ConversationInfoVo> getConversationInfo(@RequestBody ConversationInfoQueryDto param, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        FusionAssistantVo fusionAssistantVo;
        FusionAssistantInfoDto dto;
        log.info("ConversationController.getConversationInfo.start: {}", (Object)JSON.toJSONString((Object)param));
        if (StringUtils.isBlank((CharSequence)param.getConversationId()) && StringUtils.isBlank((CharSequence)param.getAgentId())) {
            return ResultBean.fail((String)"illegal parameter");
        }
        ConversationVo conversationVo = null;
        Integer agentType = param.getAgentType();
        if (Objects.equals(AssistantType.EMBEDDED_ASSISTANT.getType(), agentType)) {
            dto = new FusionAssistantInfoDto();
            dto.setAssistantType(agentType);
            dto.setAssistantId(param.getAgentId());
            fusionAssistantVo = this.fusionAssistantService.assistantInfo(dto);
        } else {
            if (StringUtils.isNotBlank((CharSequence)param.getConversationId())) {
                conversationVo = this.conversationService.getConversationInfo(param.getConversationId(), authoredUser.getUserId());
                if (Objects.isNull(conversationVo)) {
                    return ResultBean.fail((String)"Conversation No Exist");
                }
                dto = new FusionAssistantInfoDto();
                dto.setAssistantType(conversationVo.getAgentType());
                dto.setVersion(param.getVersion());
                dto.setAssistantId(conversationVo.getAgentId());
                fusionAssistantVo = this.fusionAssistantService.assistantInfo(dto);
            } else {
                dto = new FusionAssistantInfoDto();
                dto.setAssistantType(agentType);
                dto.setVersion(param.getVersion());
                dto.setAssistantId(param.getAgentId());
                fusionAssistantVo = this.fusionAssistantService.assistantInfo(dto);
                if (Objects.nonNull(fusionAssistantVo) && Objects.equals(DialogueModeEnum.longDialogueMode, fusionAssistantVo.getDialogueModeEnum())) {
                    conversationVo = this.conversationService.createOrQueryLongDialogueConversationInfo(fusionAssistantVo, authoredUser);
                }
            }
            if (Objects.nonNull(fusionAssistantVo) && Objects.nonNull(conversationVo)) {
                conversationVo.setVersion(fusionAssistantVo.getVersion());
                conversationVo.setIconUrl(fusionAssistantVo.getIconUrl());
                conversationVo.setClientType(fusionAssistantVo.getClientType());
                if (Objects.equals(ConversationTypeEnum.LONG.getType(), conversationVo.getConversationType())) {
                    conversationVo.setTitle(fusionAssistantVo.getAssistantName());
                    fusionAssistantVo.setHasConversation(Boolean.valueOf(true));
                    fusionAssistantVo.setConversationId(conversationVo.getConversationId());
                }
            }
        }
        ConversationInfoVo conversationInfoVo = new ConversationInfoVo();
        conversationInfoVo.setAgentInfo(fusionAssistantVo);
        conversationInfoVo.setConversation(conversationVo);
        log.info("ConversationController.getConversationInfo.end");
        return ResultBean.success((Integer)0, (Object)conversationInfoVo);
    }

    @PostMapping(value={"/agent/latest"})
    @ApiOperation(value="\u83b7\u53d6\u667a\u80fd\u4f53\u6700\u65b0\u5386\u53f2\u5bf9\u8bdd")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean<ConversationVo> getAgentLatestConversationInfo(@RequestBody String agentId) {
        ConversationVo conversationVo = this.conversationService.getAgentLatestConversationInfo(agentId);
        return ResultBean.success((Object)conversationVo);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u5386\u53f2\u5bf9\u8bdd")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean deleteConversation(@RequestBody ConversationDeleteDto request) {
        List conversationIds = request.getConversationIds();
        this.conversationService.deleteConversation(conversationIds, AppAuthContextHolder.getContext().getAuthoredUser());
        return ResultBean.success();
    }

    @PostMapping(value={"/updateTopic"})
    @ApiOperation(value="\u66f4\u65b0\u5bf9\u8bddTopic")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean updateTopic(@RequestBody ConversationUpdateDto request) {
        this.conversationService.updateConversationTopic(request.getConversationId(), AppAuthContextHolder.getContext().getAuthoredUser().getUserId(), request.getNewTopic());
        return ResultBean.success();
    }

    @PostMapping(value={"/newsession"})
    @ApiOperation(value="\u5f00\u542f\u65b0\u4f1a\u8bdd")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean newSession(@RequestBody NewSessionDto request) {
        String newSectionId = this.conversationService.newSection(request.getConversationId());
        return ResultBean.success((Object)newSectionId);
    }

    @PostMapping(value={"/chat"}, produces={"text/event-stream"})
    @ApiOperation(value="\u667a\u80fd\u4f53Topic\u5bf9\u8bdd")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public Object chat(@RequestBody AgentQuestionDto question, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        log.info("ConversationController.chat: {}", (Object)JSON.toJSONString((Object)question));
        try {
            SseEventParams sseEventParams = new SseEventParams();
            sseEventParams.setAgentChatInfo(question.getAssistantChat());
            sseEventParams.setUser(authoredUser);
            sseEventParams.setAssistantType(AssistantType.PUBLISH_ASSISTANT.getType());
            return this.agentCallbackComponent.topicChatAction(sseEventParams, true);
        }
        catch (BusinessException bex) {
            log.error("ConversationController.chat is BusinessException", (Throwable)bex);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_PLAIN).body((Object)bex.getDescription());
        }
        catch (Exception e) {
            log.error("ConversationController.chat is error", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_PLAIN).body((Object)"An error occurred while processing your request");
        }
    }

    @PostMapping(value={"/chat/long"}, produces={"text/event-stream"})
    @ApiOperation(value="\u667a\u80fd\u4f53\u957f\u5bf9\u8bdd")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public Object longChat(@RequestBody AgentQuestionDto question, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        try {
            log.info("ConversationController.longChat: {}", (Object)JSON.toJSONString((Object)question));
            SseEventParams sseEventParams = new SseEventParams();
            sseEventParams.setAgentChatInfo(question.getAssistantChat());
            sseEventParams.setUser(authoredUser);
            sseEventParams.setAssistantType(AssistantType.PUBLISH_ASSISTANT.getType());
            return this.agentCallbackComponent.topicChatAction(sseEventParams, false);
        }
        catch (BusinessException bex) {
            log.error("ConversationController.chat is BusinessException", (Throwable)bex);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)bex.getDescription());
        }
        catch (Exception e) {
            log.error("ConversationController.chat is error", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"An error occurred while processing your request");
        }
    }

    @GetMapping(value={"/chat/stop"})
    @ApiOperation(value="\u7ec8\u6b62\u667a\u80fd\u4f53\u5bf9\u8bdd")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean stopChat(@RequestParam String sseEmitterId) {
        log.info("ConversationController.stopChat sseEmitterId:{}", (Object)sseEmitterId);
        return ResultBean.success();
    }

    @PostMapping(value={"/break"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="token", value="token", required=true, dataType="String", paramType="Header")})
    public ResultBean<String> sseDisconnect(@RequestBody ConversationBreakDto conversationBreak) {
        return ResultBean.success();
    }

    @PostMapping(value={"/latest/messagelist"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="token", value="token", required=true, dataType="String", paramType="Header")})
    public ResultBean<String> latestMessagelist(@RequestBody ConversationBreakDto conversationBreak) {
        return ResultBean.success();
    }
}

