/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.dto.dialogue;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.common.enums.PublicEventTypeEnum;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class FusionAssistantPublishDto {
    @NotBlank(message="eventType\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="eventType\u4e0d\u80fd\u4e3a\u7a7a") String eventType;
    @NotBlank(message="eventId\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="eventId\u4e0d\u80fd\u4e3a\u7a7a") String eventId;
    @NotNull(message="event\u4e0d\u80fd\u4e3a\u7a7a")
    @Size(min=1, message="event\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="event\u4e0d\u80fd\u4e3a\u7a7a") @Size(min=1, message="event\u4e0d\u80fd\u4e3a\u7a7a") List<JSONObject> event;

    public void check() {
        for (int i = 0; i < this.event.size(); ++i) {
            JSONObject assistant = (JSONObject)this.event.get(i);
            if (PublicEventTypeEnum.ASSISTANT_PUBLISHED.getType().equals(this.eventType)) {
                Assert.notBlank((CharSequence)assistant.getString("userId"), () -> new ServiceException("event.userId\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.notBlank((CharSequence)assistant.getString("baseURL"), () -> new ServiceException("event.baseURL\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.notBlank((CharSequence)assistant.getString("version"), () -> new ServiceException("event.version\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.notBlank((CharSequence)assistant.getString("assistantId"), () -> new ServiceException("event.assistantId\u4e0d\u80fd\u4e3a\u7a7a"));
                continue;
            }
            if (!PublicEventTypeEnum.ASSISTANT_UNPUBLISH.getType().equals(this.eventType)) continue;
            Assert.notBlank((CharSequence)assistant.getString("userId"), () -> new ServiceException("event.userId\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.notBlank((CharSequence)assistant.getString("assistantId"), () -> new ServiceException("event.assistantId\u4e0d\u80fd\u4e3a\u7a7a"));
        }
    }

    public List<String> getAssistantIds() {
        return this.event.stream().map(jsonObject -> jsonObject.getString("assistantId")).collect(Collectors.toList());
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventId() {
        return this.eventId;
    }

    public List<JSONObject> getEvent() {
        return this.event;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setEvent(List<JSONObject> event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FusionAssistantPublishDto)) {
            return false;
        }
        FusionAssistantPublishDto other = (FusionAssistantPublishDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$eventId = this.getEventId();
        String other$eventId = other.getEventId();
        if (this$eventId == null ? other$eventId != null : !this$eventId.equals(other$eventId)) {
            return false;
        }
        List this$event = this.getEvent();
        List other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !((Object)this$event).equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FusionAssistantPublishDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $eventId = this.getEventId();
        result = result * 59 + ($eventId == null ? 43 : $eventId.hashCode());
        List $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
        return result;
    }

    public String toString() {
        return "FusionAssistantPublishDto(eventType=" + this.getEventType() + ", eventId=" + this.getEventId() + ", event=" + this.getEvent() + ")";
    }
}

