/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.entity;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ImConstants;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.dto.ImConversationMsgDto;
import com.digiwin.athena.ania.entity.ImMessageLog;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.mongo.domain.AsaKnowledgeMessage;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.data.annotation.Transient;

public class ImMessageLog
implements Serializable {
    private String fromAccount;
    private String toAccount;
    private Long msgTimestamp;
    private String msgidServer;
    private String msgidClient;
    private String fromClientType;
    private String msgType;
    private JSONObject msgBody;
    private JSONObject msgExt;
    private String fromUserId;
    private Integer assistantSubType;
    @Transient
    private Assistant assistant;
    @Transient
    private JSONObject answerWrapper;

    public ImMessageLog(ImConversationMsgDto conversationMsg) {
        this.assistant = conversationMsg.getAssistant();
        this.fromAccount = conversationMsg.getFromAccount();
        this.toAccount = conversationMsg.getTo();
        this.msgidServer = conversationMsg.getMsgidServer();
        this.msgidClient = conversationMsg.getMsgidClient();
        this.msgTimestamp = conversationMsg.getMsgTimestamp();
        this.msgType = conversationMsg.getMsgType();
        this.fromClientType = conversationMsg.getFromClientType();
        if (conversationMsg.getMsgType().equals(ImConstants.ImMsgTypeEnum.TEXT.getTypeChar()) || conversationMsg.getMsgType().equals("txt")) {
            this.msgBody = new JSONObject().fluentPut("text", (Object)conversationMsg.getBody());
        }
        if (conversationMsg.getMsgType().equals(ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar()) || conversationMsg.getMsgType().equals("custom")) {
            this.msgBody = JSONObject.parseObject((String)conversationMsg.getAttach());
        }
        this.fromUserId = this.getFromAccount().equals(conversationMsg.getCustomerAccId()) ? null : (String)JSONObject.parseObject((String)conversationMsg.getExt()).get((Object)"userId");
        this.msgExt = JSONObject.parseObject((String)conversationMsg.getExt());
        this.assistantSubType = conversationMsg.getAssistantSubType();
    }

    public void setAnswerWrapper(AsaKnowledgeMessage asaKnowledgeMessage) {
        JSONObject jsonObject = new JSONObject();
        if (Objects.nonNull(asaKnowledgeMessage)) {
            jsonObject.fluentPut("functionList", (Object)asaKnowledgeMessage.getFunctionList());
            ArrayList<EventData.EventMessage> answer = new ArrayList<EventData.EventMessage>();
            List cardList = asaKnowledgeMessage.getCardList();
            String msg = asaKnowledgeMessage.getMsg();
            if (StrUtil.isNotBlank((CharSequence)msg)) {
                EventData.EventMessage eventMessage = new EventData.EventMessage();
                eventMessage.setMessage(msg);
                eventMessage.setType(SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType());
                eventMessage.setMessage_type(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType());
                answer.add(eventMessage);
            }
            if (CollUtil.isNotEmpty((Collection)cardList)) {
                answer.addAll(cardList);
            }
            jsonObject.fluentPut("answer", answer);
            this.answerWrapper = jsonObject;
        }
    }

    public static ImMessageLogBuilder builder() {
        return new ImMessageLogBuilder();
    }

    public String getFromAccount() {
        return this.fromAccount;
    }

    public String getToAccount() {
        return this.toAccount;
    }

    public Long getMsgTimestamp() {
        return this.msgTimestamp;
    }

    public String getMsgidServer() {
        return this.msgidServer;
    }

    public String getMsgidClient() {
        return this.msgidClient;
    }

    public String getFromClientType() {
        return this.fromClientType;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public JSONObject getMsgBody() {
        return this.msgBody;
    }

    public JSONObject getMsgExt() {
        return this.msgExt;
    }

    public String getFromUserId() {
        return this.fromUserId;
    }

    public Integer getAssistantSubType() {
        return this.assistantSubType;
    }

    public Assistant getAssistant() {
        return this.assistant;
    }

    public JSONObject getAnswerWrapper() {
        return this.answerWrapper;
    }

    public void setFromAccount(String fromAccount) {
        this.fromAccount = fromAccount;
    }

    public void setToAccount(String toAccount) {
        this.toAccount = toAccount;
    }

    public void setMsgTimestamp(Long msgTimestamp) {
        this.msgTimestamp = msgTimestamp;
    }

    public void setMsgidServer(String msgidServer) {
        this.msgidServer = msgidServer;
    }

    public void setMsgidClient(String msgidClient) {
        this.msgidClient = msgidClient;
    }

    public void setFromClientType(String fromClientType) {
        this.fromClientType = fromClientType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setMsgBody(JSONObject msgBody) {
        this.msgBody = msgBody;
    }

    public void setMsgExt(JSONObject msgExt) {
        this.msgExt = msgExt;
    }

    public void setFromUserId(String fromUserId) {
        this.fromUserId = fromUserId;
    }

    public void setAssistantSubType(Integer assistantSubType) {
        this.assistantSubType = assistantSubType;
    }

    public void setAssistant(Assistant assistant) {
        this.assistant = assistant;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImMessageLog)) {
            return false;
        }
        ImMessageLog other = (ImMessageLog)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$fromAccount = this.getFromAccount();
        String other$fromAccount = other.getFromAccount();
        if (this$fromAccount == null ? other$fromAccount != null : !this$fromAccount.equals(other$fromAccount)) {
            return false;
        }
        String this$toAccount = this.getToAccount();
        String other$toAccount = other.getToAccount();
        if (this$toAccount == null ? other$toAccount != null : !this$toAccount.equals(other$toAccount)) {
            return false;
        }
        Long this$msgTimestamp = this.getMsgTimestamp();
        Long other$msgTimestamp = other.getMsgTimestamp();
        if (this$msgTimestamp == null ? other$msgTimestamp != null : !((Object)this$msgTimestamp).equals(other$msgTimestamp)) {
            return false;
        }
        String this$msgidServer = this.getMsgidServer();
        String other$msgidServer = other.getMsgidServer();
        if (this$msgidServer == null ? other$msgidServer != null : !this$msgidServer.equals(other$msgidServer)) {
            return false;
        }
        String this$msgidClient = this.getMsgidClient();
        String other$msgidClient = other.getMsgidClient();
        if (this$msgidClient == null ? other$msgidClient != null : !this$msgidClient.equals(other$msgidClient)) {
            return false;
        }
        String this$fromClientType = this.getFromClientType();
        String other$fromClientType = other.getFromClientType();
        if (this$fromClientType == null ? other$fromClientType != null : !this$fromClientType.equals(other$fromClientType)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        JSONObject this$msgBody = this.getMsgBody();
        JSONObject other$msgBody = other.getMsgBody();
        if (this$msgBody == null ? other$msgBody != null : !this$msgBody.equals(other$msgBody)) {
            return false;
        }
        JSONObject this$msgExt = this.getMsgExt();
        JSONObject other$msgExt = other.getMsgExt();
        if (this$msgExt == null ? other$msgExt != null : !this$msgExt.equals(other$msgExt)) {
            return false;
        }
        String this$fromUserId = this.getFromUserId();
        String other$fromUserId = other.getFromUserId();
        if (this$fromUserId == null ? other$fromUserId != null : !this$fromUserId.equals(other$fromUserId)) {
            return false;
        }
        Integer this$assistantSubType = this.getAssistantSubType();
        Integer other$assistantSubType = other.getAssistantSubType();
        if (this$assistantSubType == null ? other$assistantSubType != null : !((Object)this$assistantSubType).equals(other$assistantSubType)) {
            return false;
        }
        Assistant this$assistant = this.getAssistant();
        Assistant other$assistant = other.getAssistant();
        if (this$assistant == null ? other$assistant != null : !this$assistant.equals(other$assistant)) {
            return false;
        }
        JSONObject this$answerWrapper = this.getAnswerWrapper();
        JSONObject other$answerWrapper = other.getAnswerWrapper();
        return !(this$answerWrapper == null ? other$answerWrapper != null : !this$answerWrapper.equals(other$answerWrapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImMessageLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fromAccount = this.getFromAccount();
        result = result * 59 + ($fromAccount == null ? 43 : $fromAccount.hashCode());
        String $toAccount = this.getToAccount();
        result = result * 59 + ($toAccount == null ? 43 : $toAccount.hashCode());
        Long $msgTimestamp = this.getMsgTimestamp();
        result = result * 59 + ($msgTimestamp == null ? 43 : ((Object)$msgTimestamp).hashCode());
        String $msgidServer = this.getMsgidServer();
        result = result * 59 + ($msgidServer == null ? 43 : $msgidServer.hashCode());
        String $msgidClient = this.getMsgidClient();
        result = result * 59 + ($msgidClient == null ? 43 : $msgidClient.hashCode());
        String $fromClientType = this.getFromClientType();
        result = result * 59 + ($fromClientType == null ? 43 : $fromClientType.hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        JSONObject $msgBody = this.getMsgBody();
        result = result * 59 + ($msgBody == null ? 43 : $msgBody.hashCode());
        JSONObject $msgExt = this.getMsgExt();
        result = result * 59 + ($msgExt == null ? 43 : $msgExt.hashCode());
        String $fromUserId = this.getFromUserId();
        result = result * 59 + ($fromUserId == null ? 43 : $fromUserId.hashCode());
        Integer $assistantSubType = this.getAssistantSubType();
        result = result * 59 + ($assistantSubType == null ? 43 : ((Object)$assistantSubType).hashCode());
        Assistant $assistant = this.getAssistant();
        result = result * 59 + ($assistant == null ? 43 : $assistant.hashCode());
        JSONObject $answerWrapper = this.getAnswerWrapper();
        result = result * 59 + ($answerWrapper == null ? 43 : $answerWrapper.hashCode());
        return result;
    }

    public String toString() {
        return "ImMessageLog(fromAccount=" + this.getFromAccount() + ", toAccount=" + this.getToAccount() + ", msgTimestamp=" + this.getMsgTimestamp() + ", msgidServer=" + this.getMsgidServer() + ", msgidClient=" + this.getMsgidClient() + ", fromClientType=" + this.getFromClientType() + ", msgType=" + this.getMsgType() + ", msgBody=" + this.getMsgBody() + ", msgExt=" + this.getMsgExt() + ", fromUserId=" + this.getFromUserId() + ", assistantSubType=" + this.getAssistantSubType() + ", assistant=" + this.getAssistant() + ", answerWrapper=" + this.getAnswerWrapper() + ")";
    }

    public ImMessageLog(String fromAccount, String toAccount, Long msgTimestamp, String msgidServer, String msgidClient, String fromClientType, String msgType, JSONObject msgBody, JSONObject msgExt, String fromUserId, Integer assistantSubType, Assistant assistant, JSONObject answerWrapper) {
        this.fromAccount = fromAccount;
        this.toAccount = toAccount;
        this.msgTimestamp = msgTimestamp;
        this.msgidServer = msgidServer;
        this.msgidClient = msgidClient;
        this.fromClientType = fromClientType;
        this.msgType = msgType;
        this.msgBody = msgBody;
        this.msgExt = msgExt;
        this.fromUserId = fromUserId;
        this.assistantSubType = assistantSubType;
        this.assistant = assistant;
        this.answerWrapper = answerWrapper;
    }

    public ImMessageLog() {
    }
}

