/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.eventbus.agile.scriber;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.eventbus.agile.event.MultipleIntentionsEvent;
import com.digiwin.athena.ania.eventbus.agile.event.TokenEvent;
import com.digiwin.athena.ania.eventbus.gpt.event.SendaiConsumeMessage;
import com.digiwin.athena.ania.knowledge.server.assistant.DialogAssistantComponent;
import com.digiwin.athena.ania.mongo.domain.ChatGptRequestLog;
import com.digiwin.athena.ania.util.BaseUseUtils;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class QuestionSceneListener {
    private static final Logger log = LoggerFactory.getLogger(QuestionSceneListener.class);
    @Resource
    private DialogAssistantComponent dialogAssistantComponent;
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Value(value="${customize.managerServer.rabbitQueueName}")
    private String managerServerRabbitQueueName;

    @Order(value=6)
    @Async
    @EventListener(classes={MultipleIntentionsEvent.class})
    public void doListener(MultipleIntentionsEvent event) {
        try {
            this.dialogAssistantComponent.multipleIntentions(event);
        }
        catch (Exception e) {
            log.error("QuestionSceneListener.doListener is error,event:{}", (Object)BaseUseUtils.toJsonString((Object)event), (Object)e);
        }
    }

    @Order(value=6)
    @Async(value="goalSyncTaskExecutor")
    @EventListener(classes={TokenEvent.class})
    public void sendAiConsumeMessage(TokenEvent event) {
        JSONObject request = event.getRequest();
        JSONObject requestParamData = request.getJSONObject("data");
        ChatGptRequestLog chatGptRequestLog = event.getChatGptRequestLog();
        JSONObject usage = chatGptRequestLog.getResult().getJSONObject("usage");
        if (Objects.nonNull(usage)) {
            SendaiConsumeMessage sendaiConsumeMessage = new SendaiConsumeMessage().setUsage(usage).setCreateTime(event.getCreateTime()).setId(chatGptRequestLog.getId()).setTopic(requestParamData.getString("topic")).setToken(String.valueOf(event.getSource())).setMethod(requestParamData.getString("method"));
            this.rabbitTemplate.convertAndSend(this.managerServerRabbitQueueName, (Object)sendaiConsumeMessage);
            log.info("\u53d1\u9001GPT\u4f7f\u7528\u540e\u7684\u8bb0\u5f55,sendTokenData:{}", (Object)BaseUseUtils.toJsonString((Object)sendaiConsumeMessage));
        } else {
            log.error("\u8c03\u7528\u4e86GPT\uff0c\u4f46\u662f\u7ed3\u679c\u4e2d\u6ca1\u6709\u8fd4\u56deusage\uff0cevent\uff1a{}", (Object)JSONObject.toJSONString((Object)event));
        }
    }
}

