/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.IamHelper;
import com.digiwin.athena.ania.util.JsonUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CacHelper {
    private static final Logger log = LoggerFactory.getLogger(CacHelper.class);
    @Autowired
    private EnvProperties moduleConfig;
    @Autowired
    private RestTemplate restTemplate;
    private static final String CAC_AUTHOR_TENANTS_GOODS = "/api/cac/v4/authorizations/tenants/{}/goods/{}";
    private static final String CAC_AUTHOR_USER_APPS = "/api/cac/v4/authorizations/current/user/apps";
    private static final String CAC_AUTHOR_TEANAT_APPS = "/api/cac/v4/authorizations/current/simple";
    private static final String GOODS_HAS_AUTH = "/api/cac/v4/authorizations/tenants/{tenantId}/users/{userId}/goods/{goodsCode}";
    private static final String USER_GOODS_HAS_AUTH = "/api/cac/v4/authorizations/currentTenant/users/{userId}/enabled";
    private static final String APP_TK = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c";
    @Resource
    private IamHelper iamHelper;

    public ResponseEntity<Map> getCacAssistant(String token, String tenantId, String code) {
        String url = this.moduleConfig.getCacUrl() + CAC_AUTHOR_TENANTS_GOODS;
        url = StrUtil.format((CharSequence)url, (Object[])new Object[]{tenantId, code});
        ResponseEntity response = null;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", APP_TK);
            headers.add("digi-middleware-auth-user", token);
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, Map.class, new Object[0]);
            log.debug("verify if the app is authorized, tenantId:{}, code:{}, result:{}, token:{}", new Object[]{tenantId, code, JSONObject.toJSONString((Object)response), token});
            return response;
        }
        catch (Exception ex) {
            log.error("\u8bbf\u95ee\u7528\u6237\u6709\u6743\u9650\u7684app\u5931\u8d25\uff0curi:{}\uff0c\u9519\u8bef\u4fe1\u606f", (Object)url, (Object)ex);
            return null;
        }
    }

    public Map<String, Date> getCacAuthAssistants(String token) {
        String url = this.moduleConfig.getCacUrl() + CAC_AUTHOR_TEANAT_APPS;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", APP_TK);
        headers.add("digi-middleware-auth-user", token);
        JSONObject param = new JSONObject();
        param.put("queryExpire", (Object)2);
        HttpEntity requestEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
        if (HttpStatus.OK != response.getStatusCode()) {
            log.error("getCacAuthAssistants is error param:{},result:{}", (Object)param, (Object)response);
            throw new ServiceException(Integer.valueOf(500), "\u83b7\u53d6\u5e94\u7528\u6743\u9650\u5f02\u5e38");
        }
        JSONObject body = (JSONObject)response.getBody();
        if (Objects.isNull(body.getInteger("code")) || 200 != body.getInteger("code")) {
            log.error("getCacAuthAssistants is error param:{},tenantId:{},result:{}", (Object)param, (Object)response);
            throw new ServiceException(Integer.valueOf(500), "\u83b7\u53d6\u5e94\u7528\u6743\u9650\u5f02\u5e38");
        }
        JSONArray authorizations = body.getJSONObject("data").getJSONArray("authorizations");
        if (CollectionUtils.isEmpty((Collection)authorizations)) {
            return Collections.emptyMap();
        }
        HashMap<String, Date> codes = new HashMap<String, Date>(authorizations.size());
        for (int i = 0; i < authorizations.size(); ++i) {
            codes.put(authorizations.getJSONObject(i).getString("code"), (Date)DateUtil.parseDate((CharSequence)authorizations.getJSONObject(i).getString("expiredTime")));
        }
        return codes;
    }

    public ResponseEntity<String> getCurentApps(String token) {
        String url = this.moduleConfig.getCacUrl() + CAC_AUTHOR_USER_APPS;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", APP_TK);
            headers.add("digi-middleware-auth-user", token);
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, String.class, new Object[0]);
            return response;
        }
        catch (Exception ex) {
            log.error("\u8bbf\u95ee\u7528\u6237\u6709\u6743\u9650\u7684app\u5931\u8d25\uff0curi:{}\uff0c\u9519\u8bef\u4fe1\u606f", (Object)url, (Object)ex);
            return null;
        }
    }

    public ResponseEntity<JSONObject> getCurrentAppsJsonObject(String token) {
        String url = this.moduleConfig.getCacUrl() + CAC_AUTHOR_USER_APPS;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", APP_TK);
            headers.add("digi-middleware-auth-user", token);
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]);
            return response;
        }
        catch (Exception ex) {
            log.error("\u8bbf\u95ee\u7528\u6237\u6709\u6743\u9650\u7684app\u5931\u8d25\uff0curi:{}\uff0c\u9519\u8bef\u4fe1\u606f", (Object)url, (Object)ex);
            return null;
        }
    }

    public List<String> getCurrentAppCodes(String token) {
        try {
            ResponseEntity curentApps = this.getCurentApps(token);
            ArrayList<String> appCodes = new ArrayList<String>();
            if (Objects.nonNull(curentApps)) {
                JSONObject body = JSONObject.parseObject((String)((String)curentApps.getBody()));
                List dataList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)body.get((Object)"data")), Map.class);
                for (Map app : dataList) {
                    String appCode = MapUtils.getString((Map)app, (Object)"id");
                    if (!StringUtils.isNotBlank((CharSequence)appCode)) continue;
                    appCodes.add(appCode);
                }
            }
            log.info("CacHelper.getCurrentAppCodes.result:{}", (Object)JsonUtil.toJSONString(appCodes));
            return appCodes;
        }
        catch (Exception e) {
            log.error("CacHelper.getCurrentAppCodes token:{}", (Object)token, (Object)e);
            return new ArrayList<String>();
        }
    }

    public boolean hasApplicationAuth(String application, String tenantId, String userId, String iamToken) {
        String url = this.moduleConfig.getCacUrl() + GOODS_HAS_AUTH;
        url = url.replace("{tenantId}", tenantId);
        url = url.replace("{userId}", userId);
        url = url.replace("{goodsCode}", application);
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-app", APP_TK);
        headers.add("digi-middleware-auth-user", iamToken);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity resp = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]);
        if (resp.getStatusCode().is2xxSuccessful()) {
            return MapUtils.getBoolean((Map)((Map)resp.getBody()), (Object)"isSuccess", (Boolean)false);
        }
        return false;
    }

    public Map<String, Map> getHasAuthMap(AuthoredUser authoredUser) {
        log.info("AssistantManager.queryAssistantConfigList userId:{},tenantId:{}", (Object)authoredUser.getUserId(), (Object)authoredUser.getTenantId());
        ResponseEntity currentAppsResponse = this.getCurrentAppsJsonObject(authoredUser.getToken());
        if (currentAppsResponse.getBody() == null || !currentAppsResponse.getStatusCode().is2xxSuccessful()) {
            return new HashMap<String, Map>();
        }
        JSONObject bodyJsonObject = (JSONObject)currentAppsResponse.getBody();
        JSONArray currentListMap = bodyJsonObject.getJSONArray("data");
        if (null == currentListMap || currentListMap.isEmpty()) {
            return new HashMap<String, Map>();
        }
        HashSet appIdList = new HashSet();
        return currentListMap.stream().map(app -> (Map)app).filter(app -> !"Athena".equals(MapUtils.getString((Map)app, (Object)"id"))).peek(app -> appIdList.add(app.get("id").toString())).collect(Collectors.toMap(app -> app.get("id").toString(), Function.identity()));
    }

    public List<String> getCurrentAppCodesByTenant(String tenantId, String userId) {
        return this.getCurrentAppCodesByToken(this.iamHelper.getTenantToken(tenantId), userId);
    }

    public List<String> getCurrentAppCodesByToken(String tenantToken, String userId) {
        try {
            String url = this.moduleConfig.getCacUrl() + USER_GOODS_HAS_AUTH;
            url = url.replace("{userId}", userId);
            HttpHeaders headers = new HttpHeaders();
            headers.add("digi-middleware-auth-app", APP_TK);
            headers.add("digi-middleware-auth-user", tenantToken);
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            ResponseEntity resp = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, String.class, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                return JSON.parseArray((String)((String)resp.getBody()), String.class);
            }
        }
        catch (Exception e) {
            log.error("getCurrentAppCodes is error userId:{}", (Object)userId, (Object)e);
        }
        return Collections.emptyList();
    }

    public List<String> getCurrentAppCodes(AuthoredUser authoredUser) {
        if (StringUtils.isNotBlank((CharSequence)authoredUser.getToken())) {
            return this.getCurrentAppCodes(authoredUser.getToken());
        }
        return this.getCurrentAppCodesByTenant(authoredUser.getTenantId(), authoredUser.getUserId());
    }

    public boolean hasApplicationAuth(@Nonnull AuthoredUser authoredUser, String application) {
        String token = authoredUser.getToken();
        if (StringUtils.isBlank((CharSequence)token)) {
            token = this.iamHelper.getTenantToken(authoredUser.getTenantId());
        }
        return this.hasApplicationAuth(application, authoredUser.getTenantId(), authoredUser.getUserId(), token);
    }
}

