/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.thread.ThreadUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.ChatGptPromptEnum;
import com.digiwin.athena.ania.dto.chatgpt.ChatGptRequest;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.eventbus.agile.event.TokenEvent;
import com.digiwin.athena.ania.eventbus.gpt.event.ChatGptEvent;
import com.digiwin.athena.ania.mongo.domain.ChatGptRequestLog;
import com.digiwin.athena.ania.mongo.repository.ChatGptRequestLogMgDao;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.ChatGptUtils;
import com.digiwin.athena.ania.util.FileUtils;
import com.digiwin.athena.ania.util.JsonUtil;
import com.digiwin.athena.ania.util.MdcUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StopWatch;
import org.springframework.web.client.RestTemplate;

@Component
public class ChatGptHelper {
    private static final Logger log = LoggerFactory.getLogger(ChatGptHelper.class);
    @Autowired
    private AsyncEventBus asyncEventBus;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private ChatGptRequestLogMgDao chatGptRequestLogMgDao;
    @Resource
    private ApplicationEventPublisher applicationEventPublisher;
    private static final String GTP_URL = "/api/ai/RH";
    private static final String CLU_URL = "/api/ai/RequestHDL";
    public static final String GPT_YYYY_MM_DD = "yyyy/MM/dd";
    public static final String GPT_HH_MM = "HH:mm";
    public static final String GPT_YYYY_MM_DD_HH_MM_SS = "yyyy/MM/dd HH:mm:ss";
    public static final String ELEMENT = "#(element)";
    private static final String CONTENT = "#(content)";
    @Autowired
    private Cache<String, String> promptCaffeineCache;

    public String commonRequestGpt(ChatGptRequest chatGptRequest, String token) {
        try {
            JSONObject gptData = this.requestGpt(chatGptRequest, token);
            return gptData.getString("data");
        }
        catch (Throwable ex) {
            log.error("ChatGptHelper.commonRequestGpt is error chatGptRequest:{}", (Object)BaseUseUtils.toJsonString((Object)chatGptRequest), (Object)ex);
            return null;
        }
    }

    public String commonRequestGpt(ChatGptPromptEnum prompt, String token, BasicNameValuePair ... nameValues) {
        try {
            JSONObject gptData = this.getGptData(prompt, token, nameValues);
            return gptData.getString("data");
        }
        catch (Throwable ex) {
            log.error("ChatGptHelper.commonRequestGpt is error prompt:{}", (Object)prompt, (Object)ex);
            return null;
        }
    }

    public JSONObject getGptData(ChatGptPromptEnum chatGptPrompt, String token, BasicNameValuePair ... nameValues) {
        ChatGptRequest chatGptRequest = ArrayUtils.isNotEmpty((Object[])nameValues) ? ChatGptRequest.builder().prompt(chatGptPrompt).userParam(new ArrayList<BasicNameValuePair>(Arrays.asList(nameValues))).build() : ChatGptRequest.builder().prompt(chatGptPrompt).build();
        return this.requestGpt(chatGptRequest, token);
    }

    private JSONObject requestGpt(ChatGptRequest chatGptRequest, String token) {
        String method;
        ChatGptPromptEnum chatGptPrompt = chatGptRequest.getPrompt();
        String system = ChatGptUtils.replaceContent((String)((String)chatGptPrompt.getPromptStandardCases().getKey()), (List)chatGptRequest.getSystemParam());
        Pair user = chatGptPrompt.getUser();
        String userParam = null;
        if (Objects.nonNull(user)) {
            userParam = ChatGptUtils.replaceContent((String)(BooleanUtils.isTrue((Boolean)((Boolean)user.getKey())) ? this.getPrompt((String)user.getValue()) : (String)user.getValue()), (List)chatGptRequest.getUserParam());
        }
        List promptArray = "GPT4o".equals(method = MapUtils.getString((Map)chatGptPrompt.getGptInterface(), (Object)"method")) ? ChatGptUtils.get4oPromptArray((String)system, (String)userParam, (List)chatGptRequest.getTypeParam()) : ChatGptUtils.getPromptArray((String)system, (List)((List)chatGptPrompt.getPromptStandardCases().getValue()), (String)userParam);
        JSONObject requestParam = ChatGptUtils.buildRequestParam((ChatGptPromptEnum)chatGptPrompt, (List)promptArray);
        long startTime = System.currentTimeMillis();
        ResponseEntity result = this.executeGptPost(requestParam, chatGptPrompt, token);
        long endTime = System.currentTimeMillis();
        log.info("\u83b7\u53d6gpt\u5185\u5bb9\u6267\u884c\u65f6\u95f4:{}\u6beb\u79d2", (Object)(endTime - startTime));
        String data = ((JSONObject)result.getBody()).getString("data");
        Integer code = MapUtils.getInteger((Map)((Map)result.getBody()), (Object)"code");
        if (Objects.equals(-1, code) || StringUtils.isBlank((CharSequence)data)) {
            result = this.executeGptPost(requestParam, chatGptPrompt, token);
        }
        if (StringUtils.isNotBlank((CharSequence)(data = ((JSONObject)result.getBody()).getString("data"))) && data.startsWith("json")) {
            data = data.replaceFirst("json", "");
        }
        BaseUseUtils.businessException((boolean)Objects.equals(-1, MapUtils.getInteger((Map)((Map)result.getBody()), (Object)"code")), (String)"\u83b7\u53d6gpt\u5185\u5bb9\u8d85\u65f6");
        BaseUseUtils.isBlankException((String)data, (String)"\u83b7\u53d6gpt\u5185\u5bb9\u4e3a\u7a7a\u6570\u636e");
        JSONObject body = (JSONObject)result.getBody();
        body.put("data", (Object)data);
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseEntity<JSONObject> executeGptPost(JSONObject requestParam, ChatGptPromptEnum chatGptPrompt, String token) {
        ResponseEntity responseEntity;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start(chatGptPrompt.getDesc());
        String gptUrl = null;
        String method = MapUtils.getString((Map)chatGptPrompt.getGptInterface(), (Object)"method");
        gptUrl = "GPT4o".equals(method) ? this.envProperties.getUtasUri() + GTP_URL : ("GPT4o-mini".equals(method) ? this.envProperties.getAirh() + GTP_URL : this.envProperties.getKafkaMiddle() + GTP_URL);
        ResponseEntity result = null;
        try {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.set("digi-middleware-auth-user", token);
            httpHeaders.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
            httpHeaders.add("Content-Type", "application/json");
            HttpEntity entity = new HttpEntity((Object)requestParam, (MultiValueMap)httpHeaders);
            log.info("executeGptPost#pre,url:{},traceId:{},target:{},entity:{}", new Object[]{gptUrl, MdcUtil.getTraceId(), chatGptPrompt.getDesc(), JsonUtil.toJSONString((Object)entity)});
            result = this.restTemplate.postForEntity(gptUrl, (Object)entity, JSONObject.class, new Object[0]);
            log.info("executeGptPost#post,url:{},traceId:{},target:{},result:{}", new Object[]{gptUrl, MdcUtil.getTraceId(), chatGptPrompt.getDesc(), JsonUtil.toJSONString((Object)result)});
            this.checkIsException(result);
            String data = ((JSONObject)result.getBody()).getString("data");
            if (StringUtils.isNotBlank((CharSequence)data) && CharSequenceUtil.startWith((CharSequence)data, (CharSequence)"```json") && CharSequenceUtil.endWith((CharSequence)data, (CharSequence)"```")) {
                ((JSONObject)result.getBody()).put("data", (Object)CharSequenceUtil.removeSuffix((CharSequence)CharSequenceUtil.removePrefix((CharSequence)data, (CharSequence)"```json"), (CharSequence)"```"));
            }
            if (StringUtils.isNotBlank((CharSequence)data) && CharSequenceUtil.startWith((CharSequence)data, (CharSequence)"```") && CharSequenceUtil.endWith((CharSequence)data, (CharSequence)"```")) {
                ((JSONObject)result.getBody()).put("data", (Object)CharSequenceUtil.removeSuffix((CharSequence)CharSequenceUtil.removePrefix((CharSequence)data, (CharSequence)"```"), (CharSequence)"```"));
            }
            responseEntity = result;
        }
        catch (Throwable throwable) {
            stopWatch.stop();
            Long totalTimeMillis = stopWatch.getTotalTimeMillis();
            ChatGptRequestLog chatGptRequestLog = ChatGptRequestLog.save((JSONObject)requestParam, result, (Long)totalTimeMillis, (ChatGptPromptEnum)chatGptPrompt);
            if (Objects.nonNull(chatGptRequestLog)) {
                ThreadUtil.execute(() -> {
                    ChatGptRequestLog cfr_ignored_0 = (ChatGptRequestLog)this.chatGptRequestLogMgDao.save((Object)chatGptRequestLog);
                });
                ChatGptEvent chatGptEvent = new ChatGptEvent();
                chatGptEvent.setRequest(requestParam);
                chatGptEvent.setChatGptRequestLog(chatGptRequestLog);
                chatGptEvent.setCreateTime(new Date());
                chatGptEvent.setSource(token);
                this.asyncEventBus.post((Object)chatGptEvent);
            }
            log.info("ChatGptHelper.executeGptPost\u6267\u884c\u65f6\u95f4:{}", (Object)totalTimeMillis);
            throw throwable;
        }
        stopWatch.stop();
        Long totalTimeMillis = stopWatch.getTotalTimeMillis();
        ChatGptRequestLog chatGptRequestLog = ChatGptRequestLog.save((JSONObject)requestParam, (ResponseEntity)result, (Long)totalTimeMillis, (ChatGptPromptEnum)chatGptPrompt);
        if (Objects.nonNull(chatGptRequestLog)) {
            ThreadUtil.execute(() -> {
                ChatGptRequestLog cfr_ignored_0 = (ChatGptRequestLog)this.chatGptRequestLogMgDao.save((Object)chatGptRequestLog);
            });
            ChatGptEvent chatGptEvent = new ChatGptEvent();
            chatGptEvent.setRequest(requestParam);
            chatGptEvent.setChatGptRequestLog(chatGptRequestLog);
            chatGptEvent.setCreateTime(new Date());
            chatGptEvent.setSource(token);
            this.asyncEventBus.post((Object)chatGptEvent);
        }
        log.info("ChatGptHelper.executeGptPost\u6267\u884c\u65f6\u95f4:{}", (Object)totalTimeMillis);
        return responseEntity;
    }

    public void checkIsException(ResponseEntity<JSONObject> result) {
        BaseUseUtils.businessException((!Objects.equals(result.getStatusCode(), HttpStatus.OK) && !Objects.equals(((JSONObject)result.getBody()).getInteger("code"), 0) ? 1 : 0) != 0, (String)((JSONObject)result.getBody()).getString("msg"));
    }

    private String getPrompt(String resourceLocation) {
        String promptData = (String)this.promptCaffeineCache.getIfPresent((Object)resourceLocation);
        if (StringUtils.isNotBlank((CharSequence)promptData)) {
            return promptData;
        }
        promptData = FileUtils.readFromFilePath((String)resourceLocation);
        BaseUseUtils.businessException((boolean)StringUtils.isBlank((CharSequence)promptData), (String)(resourceLocation + "prompt file not find"));
        promptData = StringUtils.replace((String)promptData, (String)"\\n", (String)"\n");
        this.promptCaffeineCache.put((Object)resourceLocation, (Object)promptData);
        return promptData;
    }

    public String commonRequestCLU(String userText, String token) {
        try {
            JSONObject gptData = this.requestCLUGpt(userText, token);
            return gptData.getJSONObject("data").getJSONObject("candidate_intent").getString("top_intent");
        }
        catch (Throwable ex) {
            log.error("ChatGptHelper.commonRequestCLU is error requestCLUGpt:{}", (Object)userText, (Object)ex);
            return null;
        }
    }

    public JSONObject requestCLUGpt(String userText, String token) {
        JSONObject dataJson = new JSONObject();
        dataJson.fluentPut("topic", (Object)"AI");
        dataJson.fluentPut("method", (Object)"CLU_IE");
        dataJson.fluentPut("model", (Object)"model/inference");
        dataJson.fluentPut("timeout", (Object)30);
        dataJson.fluentPut("data", (Object)new JSONObject().fluentPut("text", (Object)userText).fluentPut("project_name", (Object)"CA_project_v0").fluentPut("threshold", (Object)0.8));
        JSONObject requestBody = new JSONObject();
        requestBody.fluentPut("key", (Object)"0").fluentPut("asynchronous", (Object)false).fluentPut("data", (Object)dataJson);
        long startTime = System.currentTimeMillis();
        ResponseEntity result = this.executeCLUPost(requestBody, token);
        long endTime = System.currentTimeMillis();
        log.info("\u83b7\u53d6clu-gpt\u5185\u5bb9\u6267\u884c\u65f6\u95f4:{}\u6beb\u79d2", (Object)(endTime - startTime));
        String data = ((JSONObject)result.getBody()).getString("data");
        Integer code = MapUtils.getInteger((Map)((Map)result.getBody()), (Object)"code");
        if (Objects.equals(-1, code) || StringUtils.isBlank((CharSequence)data)) {
            result = this.executeCLUPost(requestBody, token);
        }
        data = ((JSONObject)result.getBody()).getString("data");
        BaseUseUtils.businessException((boolean)Objects.equals(-1, MapUtils.getInteger((Map)((Map)result.getBody()), (Object)"code")), (String)"\u83b7\u53d6clu-gpt\u5185\u5bb9\u8d85\u65f6");
        BaseUseUtils.isBlankException((String)data, (String)"\u83b7\u53d6clu-gpt\u5185\u5bb9\u4e3a\u7a7a\u6570\u636e");
        return (JSONObject)result.getBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<JSONObject> executeCLUPost(JSONObject requestParam, String token) {
        String cluUrl = this.envProperties.getKafkaMiddle() + CLU_URL;
        ChatGptRequestLog chatGptRequestLog = ChatGptRequestLog.builder().requestParam((Object)requestParam).traceId(MdcUtil.getTraceId()).masterTraceId(MdcUtil.getMasterTraceId()).createTime(new Date()).build();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.set("digi-middleware-auth-user", token);
            httpHeaders.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
            HttpEntity entity = new HttpEntity((Object)requestParam, (MultiValueMap)httpHeaders);
            log.info("executeCLUPost#pre,url:{},traceId:{}entity:{}", new Object[]{cluUrl, MdcUtil.getTraceId(), BaseUseUtils.toJsonString((Object)entity)});
            ResponseEntity result = this.restTemplate.postForEntity(cluUrl, (Object)entity, JSONObject.class, new Object[0]);
            log.info("executeCLUPost#post,url:{},traceId:{},result:{}", new Object[]{cluUrl, MdcUtil.getTraceId(), BaseUseUtils.toJsonString((Object)result)});
            chatGptRequestLog.setResult((JSONObject)result.getBody());
            BaseUseUtils.businessException((!Objects.equals(result.getStatusCode(), HttpStatus.OK) && !Objects.equals(((JSONObject)result.getBody()).getInteger("code"), 0) ? 1 : 0) != 0, (String)((JSONObject)result.getBody()).getString("msg"));
            String data = ((JSONObject)result.getBody()).getString("data");
            if (StringUtils.isNotBlank((CharSequence)data) && CharSequenceUtil.startWith((CharSequence)data, (CharSequence)"```") && CharSequenceUtil.endWith((CharSequence)data, (CharSequence)"```")) {
                ((JSONObject)result.getBody()).put("data", (Object)CharSequenceUtil.removeSuffix((CharSequence)CharSequenceUtil.removePrefix((CharSequence)data, (CharSequence)"```"), (CharSequence)"```"));
            }
            ResponseEntity responseEntity = result;
            return responseEntity;
        }
        finally {
            stopWatch.stop();
            chatGptRequestLog.setTotalTimeMillis(Long.valueOf(stopWatch.getTotalTimeMillis()));
            this.chatGptRequestLogMgDao.save((Object)chatGptRequestLog);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new TokenEvent((Object)this).setRequest(requestParam).setChatGptRequestLog(chatGptRequestLog).setCreateTime(new Date()));
        }
    }

    public String contentOrganization(String elementName, String language, String content, String token) {
        String result = "zh-TW".equals(language) ? this.commonRequestGpt(ChatGptPromptEnum.CONTENT_ORGANIZATION_NEW, token, new BasicNameValuePair[]{new BasicNameValuePair(ELEMENT, "\u5c07\u7528\u6236\u53cd\u994b\u7684" + elementName + "\u5167\u5bb9\u9032\u884c\u932f\u8aa4\u6821\u6b63\u548c\u66f8\u9762\u5316\u6574\u7406\uff0c\u4e0d\u8981\u589e\u52a0\u4efb\u4f55\u89e3\u91cb\u63cf\u8ff0\u3002"), new BasicNameValuePair("#(language)", "\u8a9e\u8a00\u5225\uff1a" + language), new BasicNameValuePair(CONTENT, "\u7528\u6236\u53cd\u994b\u7684\u5167\u5bb9\uff1a\u300c" + content + "\u300d")}) : this.commonRequestGpt(ChatGptPromptEnum.CONTENT_ORGANIZATION_NEW, token, new BasicNameValuePair[]{new BasicNameValuePair(ELEMENT, "\u5c06\u7528\u6237\u53cd\u9988\u7684" + elementName + "\u5185\u5bb9\u8fdb\u884c\u9519\u8bef\u6821\u6b63\u548c\u4e66\u9762\u5316\u6574\u7406\uff0c\u4e0d\u8981\u589e\u52a0\u4efb\u4f55\u89e3\u91ca\u63cf\u8ff0\u3002"), new BasicNameValuePair("#(language)", "\u8bed\u8a00\u522b\uff1a" + language), new BasicNameValuePair(CONTENT, "\u7528\u6237\u53cd\u9988\u7684\u5185\u5bb9\uff1a\u300c" + content + "\u300d")});
        return "N".equalsIgnoreCase(result) ? content : result;
    }
}

