/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.helper.dto.GetPublishedInfoDto;
import com.digiwin.athena.ania.util.FastJsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class FusionAgentHelper {
    private static final Logger log = LoggerFactory.getLogger(FusionAgentHelper.class);
    @Autowired
    private RestTemplate restTemplate;
    private String GET_PUBLISHED_INFO = "assistant/getPublishedInfo";
    private String GET_ASSISTANT_VERSION = "assistant/getVersion";
    private String GET_INSPIRATION_PHRASES = "assistant/getInspirationPhrases";

    public JSONArray getPublishedInfo(String baseURL, String token, List<GetPublishedInfoDto> dtoList) {
        String url = baseURL.endsWith("/") ? baseURL + this.GET_PUBLISHED_INFO : baseURL + "/" + this.GET_PUBLISHED_INFO;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("token", token);
            headers.add("digi-middleware-auth-user", token);
            HashMap<String, List<GetPublishedInfoDto>> paramMap = new HashMap<String, List<GetPublishedInfoDto>>();
            paramMap.put("assistant", dtoList);
            HttpEntity mapHttpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
            log.info("FusionAgentHelper.getPublishedInfo.param,url:{},token:{},dtoList:{}", new Object[]{url, token, JSONObject.toJSONString(dtoList)});
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.POST, mapHttpEntity, JSONObject.class, new Object[0]);
            log.info("FusionAgentHelper.getPublishedInfo.response.response:{}", (Object)JSONObject.toJSONString((Object)result));
            if (result.getStatusCodeValue() != 200 || null == result.getBody()) {
                log.info("\u83b7\u53d6\u5165\u53e3\u52a9\u7406\u8be6\u60c5\u5931\u8d25 response:{}", (Object)result.getStatusCodeValue());
                throw new ServiceException("\u53d1\u5e03\u52a9\u7406\u5931\u8d25");
            }
            JSONObject response = ((JSONObject)result.getBody()).getJSONObject("response");
            if (null != response && !response.isEmpty()) {
                return response.getJSONArray("assistant");
            }
            return null;
        }
        catch (Exception ex) {
            log.info("\u83b7\u53d6\u5165\u53e3\u52a9\u7406\u8be6\u60c5\u5f02\u5e38", (Throwable)ex);
            throw new ServiceException("\u56de\u8c03\u670d\u52a1\u5546\u52a9\u7406\u8be6\u60c5\u5f02\u5e38" + ex.getMessage());
        }
    }

    public List<Map> getAssistantVersion(String baseURL, String token, List<JSONObject> assistantObjects) {
        String url = baseURL.endsWith("/") ? baseURL + this.GET_ASSISTANT_VERSION : baseURL + "/" + this.GET_ASSISTANT_VERSION;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("token", token);
            headers.add("digi-middleware-auth-user", token);
            HashMap<String, List<JSONObject>> paramMap = new HashMap<String, List<JSONObject>>();
            paramMap.put("assistant", assistantObjects);
            HttpEntity requestEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
            log.info("FusionAgentHelper.getPublishedInfo.param,url:{},token:{},dtoList:{}", new Object[]{url, token, JSONObject.toJSONString(paramMap)});
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            log.info("FusionAgentHelper.getPublishedInfo.response.response:{}", (Object)JSONObject.toJSONString((Object)result));
            if (result.getStatusCodeValue() != 200 || null == result.getBody()) {
                log.info("\u83b7\u53d6\u5165\u53e3\u52a9\u7406\u53ef\u7528\u7248\u672c\u5931\u8d25 response:{}", (Object)result.getStatusCodeValue());
                return Collections.emptyList();
            }
            JSONObject response = ((JSONObject)result.getBody()).getJSONObject("response");
            if (response != null && !response.isEmpty()) {
                JSONArray assistants = response.getJSONArray("assistant");
                return FastJsonUtils.toList((JSONArray)assistants, Map.class);
            }
        }
        catch (Exception ex) {
            log.info("\u83b7\u53d6\u5165\u53e3\u52a9\u7406\u8be6\u60c5\u5f02\u5e38", (Throwable)ex);
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public String getAssistantVersion(String baseUrl, String token, String assistantId) {
        JSONObject assistant = new JSONObject().fluentPut("assistantId", (Object)assistantId);
        List assistantVersion = this.getAssistantVersion(baseUrl, token, (List)ListUtil.toList((Object[])new JSONObject[]{assistant}));
        if (CollUtil.isNotEmpty((Collection)assistantVersion)) {
            return (String)((Map)assistantVersion.get(0)).get("version");
        }
        log.error("\u8c03\u7528\u670d\u52a1\u5546/assistant/getVersion\u6570\u636e\u4e3a\u7a7a");
        return null;
    }

    public JSONObject getInspirationPhrases(String baseURL, String token, String assistantId) {
        ArrayList assistantObjects = ListUtil.toList((Object[])new JSONObject[]{new JSONObject().fluentPut("assistantId", (Object)assistantId)});
        List inspirationPhrases = this.getInspirationPhrases(baseURL, token, (List)assistantObjects);
        if (CollUtil.isNotEmpty((Collection)inspirationPhrases)) {
            return (JSONObject)inspirationPhrases.get(0);
        }
        return null;
    }

    public List<JSONObject> getInspirationPhrases(String baseURL, String token, List<JSONObject> assistantObjects) {
        String url = baseURL.endsWith("/") ? baseURL + this.GET_INSPIRATION_PHRASES : baseURL + "/" + this.GET_INSPIRATION_PHRASES;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("token", token);
            headers.add("digi-middleware-auth-user", token);
            HashMap<String, List<JSONObject>> paramMap = new HashMap<String, List<JSONObject>>();
            paramMap.put("assistant", assistantObjects);
            HttpEntity requestEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
            log.info("FusionAgentHelper.getInspirationPhrases.param,url:{},token:{},dtoList:{}", new Object[]{url, token, JSONObject.toJSONString(paramMap)});
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            log.info("FusionAgentHelper.getInspirationPhrases.response.response:{}", (Object)JSONObject.toJSONString((Object)result));
            if (result.getStatusCodeValue() != 200 || null == result.getBody()) {
                log.info("\u83b7\u53d6\u5165\u53e3\u52a9\u7406\u7075\u611f\u8bdd\u672f\u5931\u8d25 response:{}", (Object)result.getStatusCodeValue());
                return Collections.emptyList();
            }
            JSONObject response = ((JSONObject)result.getBody()).getJSONObject("response");
            if (response != null && !response.isEmpty()) {
                JSONArray assistants = response.getJSONArray("assistant");
                return FastJsonUtils.toList((JSONArray)assistants, JSONObject.class);
            }
        }
        catch (Exception ex) {
            log.info("\u83b7\u53d6\u5165\u53e3\u52a9\u7406\u7075\u611f\u8bdd\u672f\u5f02\u5e38", (Throwable)ex);
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

