/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.IamHelper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class KmHelper {
    private static final Logger log = LoggerFactory.getLogger(KmHelper.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private IamHelper iamHelper;
    @Resource
    private EnvProperties envProperties;
    @Value(value="${chatFile.digi-kai-api-key}")
    private String digiKaiChatApiKey;
    private static final String GET_WEBURL = "/restful/standard/skc/isv/api/store/skill/getWebUrl";

    public String getTenantVersion(String tenantId) {
        String url = String.format(this.envProperties.getKmUrl() + "/restful/service/knowledgegraph/tenant/tenantVersion?tenantId=%s", tenantId);
        HttpHeaders headers = new HttpHeaders();
        String token = this.iamHelper.getTenantToken(tenantId);
        headers.set("token", token);
        headers.set("digi-middleware-auth-user", token);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        log.info("KmHelper.getTenantVersion start tenantId:{}; header:{}", (Object)tenantId, (Object)JSONObject.toJSONString((Object)headers));
        ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.GET, entity, JSONObject.class, new Object[0]);
        log.info("KmHelper.getTenantVersion return result:{}", (Object)result);
        JSONObject parseResult = (JSONObject)result.getBody();
        Integer status = MapUtils.getInteger((Map)parseResult, (Object)"status", (Integer)100);
        if (200 != status) {
            String statusDescription = MapUtils.getString((Map)parseResult, (Object)"statusDescription", (String)"getTenantVersion is error");
            log.error("KmHelper.getTenantVersion is error desc", (Object)statusDescription);
            throw new ServiceException(Integer.valueOf(500), statusDescription);
        }
        return parseResult.getString("response");
    }

    public String getWebUrl(String id, String iamToken) {
        String url = this.envProperties.getKnowledgeUrl() + GET_WEBURL;
        String webUrl = null;
        ResponseEntity response = null;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("token", iamToken);
            headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
            headers.add("digi-kai-api-key", this.digiKaiChatApiKey);
            JSONObject param = new JSONObject();
            param.put("id", (Object)id);
            HttpEntity requestEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
            response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (response.getStatusCodeValue() != 200 || null == response.getBody()) {
                log.info("km.getWebUrl is fail responseEntity:{}", (Object)response);
                return webUrl;
            }
            JSONObject responseBody = (JSONObject)response.getBody();
            JSONObject data = responseBody.getJSONObject("response").getJSONObject("data");
            return org.apache.commons.collections4.MapUtils.getString((Map)data, (Object)"webUrl");
        }
        catch (Exception ex) {
            log.error("\u83b7\u53d6\u5df2\u53d1\u5e03\u6280\u80fd\u5217\u8868\u5931\u8d25\uff0curi:{}\uff0c\u9519\u8bef\u4fe1\u606f", (Object)url, (Object)ex);
            return webUrl;
        }
    }

    public List<Map> queryTenantAgileDataApplication(String token, String tenantId) {
        String url = this.envProperties.getKmUrl() + "/restful/service/knowledgegraph/tenant/tenantMetricApplication";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("routerKey", tenantId);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            log.info("KmHelper.queryTenantAgileDataApplication start tenantId:{}; header:{}", (Object)tenantId, (Object)JSONObject.toJSONString((Object)headers));
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class, new Object[0]);
            log.info("KmHelper.queryTenantAgileDataApplication return response:{}", (Object)response);
            JSONObject parseResult = (JSONObject)response.getBody();
            Integer status = MapUtils.getInteger((Map)parseResult, (Object)"status", (Integer)100);
            if (200 != status) {
                String statusDescription = MapUtils.getString((Map)parseResult, (Object)"statusDescription", (String)"queryTenantAgileDataApplication is error");
                log.error("KmHelper.queryTenantAgileDataApplication is error desc", (Object)statusDescription);
                throw new ServiceException(Integer.valueOf(500), statusDescription);
            }
            return (List)parseResult.get((Object)"response");
        }
        catch (Exception e) {
            log.error("KmHelper.queryTenantAgileDataApplication is error desc", (Object)e.getMessage());
            throw new ServiceException(Integer.valueOf(500), e.getMessage());
        }
    }

    public JSONObject applicationByCode(String application, String tenantId) {
        try {
            String url = String.format(this.envProperties.getKmUrl() + "/restful/service/knowledgegraph/app/applicationByCode?code=%s&tenantId=%s", application, tenantId);
            HttpHeaders headers = new HttpHeaders();
            String token = this.iamHelper.getTenantToken(tenantId);
            headers.set("token", token);
            headers.set("digi-middleware-auth-user", token);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            log.info("KmHelper.applicationByCode start tenantId:{}; header:{}", (Object)tenantId, (Object)JSONObject.toJSONString((Object)headers));
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.GET, entity, JSONObject.class, new Object[0]);
            log.info("KmHelper.applicationByCode return result:{}", (Object)result);
            JSONObject parseResult = (JSONObject)result.getBody();
            Integer status = MapUtils.getInteger((Map)parseResult, (Object)"status", (Integer)100);
            if (200 != status) {
                String statusDescription = MapUtils.getString((Map)parseResult, (Object)"statusDescription", (String)"getTenantVersion is error");
                log.error("KmHelper.applicationByCode is error desc", (Object)statusDescription);
                throw new ServiceException(Integer.valueOf(500), statusDescription);
            }
            return parseResult.getJSONObject("response");
        }
        catch (Exception e) {
            log.info("KmHelper.applicationByCode.error application:{}", (Object)application, (Object)e);
            return null;
        }
    }

    public JSONArray queryCommandIntentions(AuthoredUser authoredUser) {
        try {
            String url = String.format(this.envProperties.getKmUrl() + "/restful/service/knowledgegraph/command/queryAllCommandIntentions?userId=%s", authoredUser.getUserId());
            HttpHeaders headers = new HttpHeaders();
            headers.add("digi-middleware-auth-user", authoredUser.getToken());
            headers.add("routerKey", authoredUser.getTenantId());
            headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity result = this.restTemplate.exchange(url, HttpMethod.GET, entity, JSONObject.class, new Object[0]);
            if (result.getStatusCode().is2xxSuccessful()) {
                JSONObject parseResult = (JSONObject)result.getBody();
                Integer status = MapUtils.getInteger((Map)parseResult, (Object)"status", (Integer)100);
                if (200 != status) {
                    String statusDescription = MapUtils.getString((Map)parseResult, (Object)"statusDescription", (String)"queryCommandIntentions is error");
                    log.error("KmHelper.queryCommandIntentions is error desc statusDescription:{}", (Object)statusDescription);
                    throw new ServiceException(Integer.valueOf(500), statusDescription);
                }
                return Objects.nonNull(parseResult) ? parseResult.getJSONArray("response") : null;
            }
        }
        catch (Exception e) {
            log.info("KmHelper.queryCommandIntentions.error userId:{}", (Object)authoredUser.getUserId(), (Object)e);
        }
        return null;
    }
}

