/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import cn.hutool.core.thread.ThreadUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ChatGptConstants;
import com.digiwin.athena.ania.common.enums.ChatGptPromptEnum;
import com.digiwin.athena.ania.common.enums.RhModelEnum;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.mongo.domain.ChatGptRequestLog;
import com.digiwin.athena.ania.mongo.repository.ChatGptRequestLogMgDao;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.JsonUtil;
import com.digiwin.athena.ania.util.MdcUtil;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StopWatch;
import org.springframework.web.client.RestTemplate;

@Component
public class RhHelper {
    private static final Logger log = LoggerFactory.getLogger(RhHelper.class);
    private static final String CLU_URL = "/api/ai/RequestHDL";
    public static final String DATA_KEY = "data";
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ChatGptRequestLogMgDao chatGptRequestLogMgDao;

    public JSONObject syncRequest(String token, Map<String, Object> requestData, RhModelEnum rhModelEnum) {
        JSONObject result = this.syncRhRequest(token, requestData, rhModelEnum);
        return result.getJSONObject(DATA_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject syncRhRequest(String token, Map<String, Object> requestData, RhModelEnum rhModelEnum) {
        JSONObject jSONObject;
        JSONObject requestParam = new JSONObject();
        requestParam.put("key", (Object)"0");
        requestParam.put("asynchronous", (Object)false);
        JSONObject data = new JSONObject();
        data.putAll(ChatGptConstants.COMMON_INTERFACE_DATA);
        data.put("model", (Object)rhModelEnum.getModel());
        if (Objects.nonNull(rhModelEnum.getTimeout()) && rhModelEnum.getTimeout() > 0) {
            data.put("timeout", (Object)rhModelEnum.getTimeout());
        }
        JSONObject dataJson = new JSONObject();
        dataJson.fluentPut("topic", (Object)"AI");
        dataJson.fluentPut("method", (Object)"CLU_IE");
        dataJson.fluentPut("model", (Object)"model/inference_v1");
        dataJson.fluentPut("timeout", (Object)60);
        dataJson.fluentPut(DATA_KEY, requestData);
        data.put(DATA_KEY, requestData);
        requestParam.put(DATA_KEY, (Object)dataJson);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("syncRhRequest");
        ResponseEntity result = null;
        try {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.set("digi-middleware-auth-user", token);
            httpHeaders.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
            HttpEntity entity = new HttpEntity((Object)requestParam, (MultiValueMap)httpHeaders);
            String aiUrl = this.envProperties.getKafkaMiddle() + CLU_URL;
            String requestParamStr = JsonUtil.toJSONString((Object)requestParam);
            log.info("syncRhRequest#pre,traceId:{},ptxId:{},target:{},entity:{}", new Object[]{MdcUtil.getTraceId(), MdcUtil.get((String)"PtxId"), rhModelEnum.getDesc(), requestParamStr});
            result = this.restTemplate.postForEntity(aiUrl, (Object)entity, JSONObject.class, new Object[0]);
            log.info("syncRhRequest#post,traceId:{},target:{},result:{}", new Object[]{MdcUtil.getTraceId(), rhModelEnum.getDesc(), JsonUtil.toJSONString((Object)result)});
            BaseUseUtils.businessException((!Objects.equals(result.getStatusCode(), HttpStatus.OK) && !Objects.equals(((JSONObject)result.getBody()).getInteger("code"), 0) ? 1 : 0) != 0, (String)((JSONObject)result.getBody()).getString("msg"));
            jSONObject = (JSONObject)result.getBody();
        }
        catch (Throwable throwable) {
            stopWatch.stop();
            Long totalTimeMillis = stopWatch.getTotalTimeMillis();
            ChatGptRequestLog chatGptRequestLog = ChatGptRequestLog.save((JSONObject)requestParam, result, (Long)totalTimeMillis, (ChatGptPromptEnum)ChatGptPromptEnum.INTENT_RECOGNITION);
            if (Objects.nonNull(chatGptRequestLog)) {
                ThreadUtil.execute(() -> {
                    ChatGptRequestLog cfr_ignored_0 = (ChatGptRequestLog)this.chatGptRequestLogMgDao.save((Object)chatGptRequestLog);
                });
            }
            throw throwable;
        }
        stopWatch.stop();
        Long totalTimeMillis = stopWatch.getTotalTimeMillis();
        ChatGptRequestLog chatGptRequestLog = ChatGptRequestLog.save((JSONObject)requestParam, (ResponseEntity)result, (Long)totalTimeMillis, (ChatGptPromptEnum)ChatGptPromptEnum.INTENT_RECOGNITION);
        if (Objects.nonNull(chatGptRequestLog)) {
            ThreadUtil.execute(() -> {
                ChatGptRequestLog cfr_ignored_0 = (ChatGptRequestLog)this.chatGptRequestLogMgDao.save((Object)chatGptRequestLog);
            });
        }
        return jSONObject;
    }
}

