/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.util.MdcUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class SkcHelper {
    private static final Logger log = LoggerFactory.getLogger(SkcHelper.class);
    @Autowired
    private RestTemplate restTemplate;
    @Resource
    private EnvProperties envProperties;
    @Value(value="${chatFile.digi-kai-api-key}")
    private String digiKaiChatApiKey;
    @Value(value="${ania.skc.enable:true}")
    private boolean skcEnable;

    public com.alibaba.fastjson2.JSONObject queryAgentSessionList(String queryType, int pageNo, int pageSize, String iamToken) {
        if (this.skcEnable) {
            String url = this.envProperties.getKnowledgeUrl() + "/restful/standard/skc/skill/session/list";
            ResponseEntity response = null;
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.add("token", iamToken);
                headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
                headers.add("digi-kai-api-key", this.digiKaiChatApiKey);
                com.alibaba.fastjson2.JSONObject param = new com.alibaba.fastjson2.JSONObject();
                param.put((Object)"queryType", (Object)queryType);
                param.put((Object)"pageNo", (Object)pageNo);
                param.put((Object)"pageSize", (Object)pageSize);
                HttpEntity requestEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
                log.info("queryAgentSessionList#pre, traceId:{}, ptxId:{}, entity:{}", new Object[]{MdcUtil.getTraceId(), MdcUtil.get((String)"PtxId"), JSON.toJSONString((Object)requestEntity)});
                response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, com.alibaba.fastjson2.JSONObject.class, new Object[0]);
                log.info("queryAgentSessionList#post, traceId:{}", (Object)MdcUtil.getTraceId());
                if (response.getStatusCodeValue() != 200 || null == response.getBody()) {
                    log.error("Skc queryAgentSessionList is fail responseEntity:{}", (Object)response);
                    return null;
                }
                com.alibaba.fastjson2.JSONObject responseBody = (com.alibaba.fastjson2.JSONObject)response.getBody();
                com.alibaba.fastjson2.JSONObject data = responseBody.getJSONObject("response").getJSONObject("data");
                log.info("queryAgentSessionList#result, traceId:{}, total:{}", (Object)MdcUtil.getTraceId(), (Object)data.getIntValue("total"));
                return data;
            }
            catch (Exception ex) {
                log.error("\u83b7\u53d6\u667a\u80fd\u4f53\u5386\u53f2\u5bf9\u8bdd\u5217\u8868\u5931\u8d25\uff0curi:{}\uff0c\u9519\u8bef\u4fe1\u606f", (Object)url, (Object)ex);
            }
        }
        return null;
    }

    public List<Map> queryAgentList(int pageSize, String iamToken, String language) {
        ArrayList<Map> agentList = new ArrayList<Map>();
        if (this.skcEnable) {
            JSONObject data;
            int pageNum = 1;
            while ((data = this.queryAgentList(pageNum, pageSize, iamToken, language)) != null) {
                int total = MapUtils.getIntValue((Map)data, (Object)"total", (int)0);
                List rows = (List)data.get((Object)"rows");
                agentList.addAll(rows);
                if (agentList.size() >= total) break;
                ++pageNum;
            }
        }
        return agentList;
    }

    public JSONObject queryAgentList(int pageNo, int pageSize, String iamToken, String language) {
        if (this.skcEnable) {
            String url = this.envProperties.getKnowledgeUrl() + "/restful/standard/skc/api/v1/skills/wis/list";
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.add("token", iamToken);
                headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
                headers.add("digi-kai-api-key", this.digiKaiChatApiKey);
                headers.add("Accept-Language", LocalsEnum.isTw((String)language) ? "zh-TW" : "zh-CN");
                com.alibaba.fastjson2.JSONObject param = new com.alibaba.fastjson2.JSONObject();
                param.put((Object)"publishType", (Object)ListUtil.toList((Object[])new String[]{"public", "scope", "private"}));
                param.put((Object)"pageNo", (Object)pageNo);
                param.put((Object)"pageSize", (Object)pageSize);
                HttpEntity requestEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
                log.info("queryAgentList#pre, traceId:{}, ptxId:{} ,entity:{}", new Object[]{MdcUtil.getTraceId(), MdcUtil.get((String)"PtxId"), JSON.toJSONString((Object)requestEntity)});
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
                log.info("queryAgentList#post, traceId:{}", (Object)MdcUtil.getTraceId());
                if (response.getStatusCodeValue() != 200 || null == response.getBody()) {
                    log.error("Skc queryAgentList is fail responseEntity:{}", (Object)response);
                    return null;
                }
                JSONObject responseBody = (JSONObject)response.getBody();
                JSONObject data = responseBody.getJSONObject("response").getJSONObject("data");
                log.info("queryAgentList#result, traceId:{}, total:{}", (Object)MdcUtil.getTraceId(), (Object)data.getIntValue("total"));
                return data;
            }
            catch (Exception ex) {
                log.error("\u83b7\u53d6\u667a\u80fd\u4f53\u5217\u8868\u5931\u8d25\uff0curi:{}\uff0c\u9519\u8bef\u4fe1\u606f", (Object)url, (Object)ex);
            }
        }
        return null;
    }

    public JSONObject queryAgentDetail(String agentCode, String iamToken, String language) {
        if (this.skcEnable) {
            String url = String.format(this.envProperties.getKnowledgeUrl() + "/restful/standard/skc/app/v1/skill/get/%s", agentCode);
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.add("token", iamToken);
                headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
                headers.add("digi-kai-api-key", this.digiKaiChatApiKey);
                headers.add("Accept-Language", LocalsEnum.isTw((String)language) ? "zh-TW" : "zh-CN");
                HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
                log.info("queryAgentDetail#pre, traceId:{}, ptxId:{} ,entity:{}", new Object[]{MdcUtil.getTraceId(), MdcUtil.get((String)"PtxId"), JSON.toJSONString((Object)requestEntity)});
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]);
                log.info("queryAgentDetail#post, traceId:{}", (Object)MdcUtil.getTraceId());
                if (response.getStatusCodeValue() != 200 || null == response.getBody()) {
                    log.error("Skc queryAgentDetail is fail responseEntity:{}", (Object)response);
                    return null;
                }
                JSONObject responseBody = (JSONObject)response.getBody();
                return responseBody.getJSONObject("response").getJSONObject("data");
            }
            catch (Exception ex) {
                log.error("\u83b7\u53d6\u667a\u80fd\u4f53\u8be6\u60c5\u5931\u8d25\uff0curi:{}\uff0c\u9519\u8bef\u4fe1\u606f", (Object)url, (Object)ex);
            }
        }
        return null;
    }
}

