/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.configuration.YunXinConfig;
import com.digiwin.athena.ania.entity.im.ImSendMsgResult;
import com.digiwin.athena.ania.entity.im.ImSessionMsgLog;
import com.digiwin.athena.ania.entity.im.ImSingleChatDelete;
import com.digiwin.athena.ania.entity.im.ImSingleChatQuery;
import com.digiwin.athena.ania.entity.im.SendMessage;
import com.digiwin.athena.ania.helper.im.ImTypeHandler;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.ImCheckSumBuilder;
import com.digiwin.athena.ania.util.JsonUtil;
import com.digiwin.athena.appcore.exception.BusinessException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class YunXinImHelper
implements ImTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(YunXinImHelper.class);
    @Autowired
    private YunXinConfig yunXinConfig;
    @Autowired
    private HttpClient httpClient;

    public String getImType() {
        return "Yunxin";
    }

    public ResultBean pushMessage(String accId, String message, String skillType, JSONObject msgExt) {
        return this.pushMessage(this.buildSingleSendMessage(MDC.get((String)"serverAccid"), accId, message, skillType, 0, msgExt));
    }

    public ResultBean pushMessageNew(String accidFrom, String accIdTo, String message, String skillType, JSONObject msgExt) {
        return this.pushMessage(this.buildSingleSendMessage(accidFrom, accIdTo, message, skillType, 0, msgExt));
    }

    public ResultBean pushCustomMessage(String accId, JSONObject message, String skillType, JSONObject msgExt) {
        return this.pushMessage(this.buildSingleSendMessage(MDC.get((String)"serverAccid"), accId, message.toJSONString(), skillType, 100, msgExt));
    }

    public ResultBean pushCustomMessageNew(String accidFrom, String accIdTo, JSONObject message, String skillType, JSONObject msgExt) {
        return this.pushMessage(this.buildSingleSendMessage(accidFrom, accIdTo, message.toJSONString(), skillType, 100, msgExt));
    }

    public SendMessage buildSingleSendMessage(String from, String to, String message, String skillType, int type, JSONObject msgExt) {
        SendMessage sendMessage = new SendMessage();
        sendMessage.setFrom(from);
        sendMessage.setTo(to);
        sendMessage.setOpe(Integer.valueOf(0));
        sendMessage.setType(Integer.valueOf(type));
        sendMessage.setBody(message);
        sendMessage.setExt(msgExt.fluentPut("skillType", (Object)skillType).fluentPut("imSource", (Object)"AI_ASSISTANT").toJSONString());
        return sendMessage;
    }

    public ResultBean pushMessage(SendMessage message) {
        try {
            return ResultBean.success((Object)this.sendMessage(message));
        }
        catch (BusinessException e) {
            log.error("pushMessage is BusinessException message:{}", (Object)BaseUseUtils.toJsonString((Object)message), (Object)e);
            return new ResultBean(new ServiceException(Integer.valueOf(500), e.getMessage()));
        }
        catch (IOException e) {
            log.error("pushMessage is error message:{}", (Object)BaseUseUtils.toJsonString((Object)message), (Object)e);
            return new ResultBean(new ServiceException(Integer.valueOf(500), "IM\u6d88\u606f\u53d1\u9001\u5931\u8d25"));
        }
    }

    public ImSendMsgResult sendMessage(SendMessage message) throws IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("from", message.getFrom());
        paramMap.put("to", message.getTo());
        paramMap.put("ope", message.getOpe());
        int type = message.getType() == null ? 0 : message.getType();
        paramMap.put("type", type);
        String msg = type == 0 ? new JSONObject().fluentPut("msg", (Object)message.getBody()).toJSONString() : message.getBody();
        paramMap.put("body", msg);
        paramMap.put("env", this.yunXinConfig.getEnv());
        if (StringUtils.isNotBlank((CharSequence)message.getExt())) {
            paramMap.put("ext", message.getExt());
        }
        HttpPost httpPost = this.buildPostRequest(this.yunXinConfig.getMsgUrl(), paramMap);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
        JSONObject result = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset()));
        Integer code = result.getInteger("code");
        String desc = result.getString("desc");
        BaseUseUtils.businessException((!Objects.equals(code, 200) ? 1 : 0) != 0, (String)(StringUtils.isNotBlank((CharSequence)desc) ? desc : "\u53d1\u9001\u4e91\u4fe1\u6d88\u606f\u5931\u8d25"));
        JSONObject data = result.getJSONObject("data");
        ImSendMsgResult sendMsgResult = new ImSendMsgResult();
        sendMsgResult.setMsgId(MapUtils.getLong((Map)data, (Object)"msgid"));
        log.info("msgid:{}", (Object)sendMsgResult.getMsgId());
        sendMsgResult.setMsgSendTime(MapUtils.getLong((Map)data, (Object)"timetag"));
        return sendMsgResult;
    }

    public HttpPost buildPostRequest(String url, Map<String, Object> paramMap) {
        HttpPost httpPost = new HttpPost(url);
        String appKey = this.yunXinConfig.getAppKey();
        String appSecret = this.yunXinConfig.getAppSecret();
        SecureRandom secureRandom = new SecureRandom();
        String nonce = String.valueOf((int)(secureRandom.nextDouble() * 100000.0));
        String curTime = String.valueOf(new Date().getTime() / 1000L);
        String checkSum = ImCheckSumBuilder.getCheckSum((String)appSecret, (String)nonce, (String)curTime);
        httpPost.addHeader("AppKey", appKey);
        httpPost.addHeader("Nonce", nonce);
        httpPost.addHeader("CurTime", curTime);
        httpPost.addHeader("CheckSum", checkSum);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        ArrayList nameValuePairs = new ArrayList();
        paramMap.forEach((k, v) -> nameValuePairs.add(new BasicNameValuePair(k, v.toString())));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, Charset.defaultCharset()));
        return httpPost;
    }

    public List<ImSessionMsgLog> singleChatQuery(ImSingleChatQuery query) throws IOException {
        HttpPost httpPost;
        HttpResponse response;
        JSONObject result;
        HashMap<String, Object> params = new HashMap<String, Object>(7);
        params.put("from", query.getFrom());
        params.put("to", query.getTo());
        params.put("begintime", query.getBeginTime());
        params.put("endtime", query.getEndTime());
        params.put("limit", query.getLimit());
        if (StringUtils.isNotBlank((CharSequence)query.getType())) {
            params.put("type", query.getType());
        }
        if (Objects.nonNull(query.getReverse())) {
            params.put("reverse", Objects.equals(Boolean.TRUE, query.getReverse()) ? 1 : 2);
        }
        BaseUseUtils.businessException((!Objects.equals((result = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)(response = this.httpClient.execute((HttpUriRequest)(httpPost = this.buildPostRequest(this.yunXinConfig.getRecordQuery(), params)))).getEntity(), (Charset)Charset.defaultCharset()))).getInteger("code"), 200) ? 1 : 0) != 0, (String)"\u5355\u804a\u4e91\u7aef\u5386\u53f2\u6d88\u606f\u67e5\u8be2\u5931\u8d25");
        return JsonUtil.parseArray((String)result.getString("msgs"), ImSessionMsgLog.class);
    }

    public void singleChatDelete(ImSingleChatDelete delete) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>(7);
        params.put("from", delete.getFrom());
        params.put("to", delete.getTo());
        params.put("deleteMsgid", delete.getMsgId());
        params.put("timetag", delete.getMsgSendTime());
        params.put("type", 7);
        HttpPost httpPost = this.buildPostRequest("https://api.yunxinapi.com/nimserver/msg/delMsg.action", params);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
        JSONObject result = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset()));
        BaseUseUtils.businessException((!Objects.equals(result.getInteger("code"), 200) ? 1 : 0) != 0, (String)"\u5220\u9664\u5355\u6761\u6d88\u606f\u5931\u8d25");
    }

    public ResultBean handler(String accId, Object message, String skillType, JSONObject msgExt, String url) {
        if (message instanceof JSONObject) {
            JSONObject jsonObjectMessage = JSONObject.parseObject((String)JSONObject.toJSONString((Object)message));
            return this.pushCustomMessage(accId, jsonObjectMessage, skillType, msgExt);
        }
        return this.pushMessage(accId, (String)message, skillType, msgExt);
    }
}

