/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.interfaces.assembler;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.dto.agora.ReceiveMessageDTO;
import com.digiwin.athena.ania.entity.agora.ReceiveMessage;
import com.digiwin.athena.ania.interfaces.assembler.dto.ReceiveMessageDto;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class MessageAssembler {
    private static final List<ReceiveMessageDto> emptyDto = Collections.EMPTY_LIST;

    public static ReceiveMessage messageToDO(ReceiveMessageDto receiveMessageDto) {
        ReceiveMessage receiveMessage = new ReceiveMessage();
        BeanUtils.copyProperties((Object)receiveMessageDto, (Object)receiveMessage);
        receiveMessage.setMsgTimestamp(Long.valueOf(Long.parseLong(receiveMessageDto.getMsgTimestamp())));
        receiveMessage.setTo(receiveMessageDto.getTo());
        return receiveMessage;
    }

    public static List<ReceiveMessageDto> receiveMessageDOsToDto(List<ReceiveMessage> receiveMessageList) {
        if (CollectionUtils.isEmpty(receiveMessageList)) {
            return emptyDto;
        }
        LinkedList<ReceiveMessageDto> receiveMessageDtos = new LinkedList<ReceiveMessageDto>();
        receiveMessageList.forEach(item -> {
            ReceiveMessageDto receiveMessageDto = new ReceiveMessageDto();
            BeanUtils.copyProperties((Object)item, (Object)receiveMessageDto);
            receiveMessageDto.setMsgTimestamp(String.valueOf(item.getMsgTimestamp()));
            receiveMessageDtos.add(receiveMessageDto);
        });
        return receiveMessageDtos;
    }

    public static ReceiveMessage messageToDO(ReceiveMessageDTO receiveMessageDto) {
        ReceiveMessage receiveMessage = new ReceiveMessage();
        receiveMessage.setFromAccount(receiveMessageDto.getFrom());
        receiveMessage.setTo(receiveMessageDto.getTo());
        receiveMessage.setEventType("1");
        receiveMessage.setConvType(receiveMessageDto.getChat_type());
        receiveMessage.setMsgTimestamp(receiveMessageDto.getTimestamp());
        receiveMessage.setMsgidClient(receiveMessageDto.getMsg_id());
        receiveMessage.setMsgidServer(receiveMessageDto.getMsg_id());
        String msgType = (String)((Map)receiveMessageDto.getPayload().getBodies().get(0)).get("type");
        receiveMessage.setMsgType(msgType);
        if (msgType.equals("txt")) {
            receiveMessage.setBody((String)((Map)receiveMessageDto.getPayload().getBodies().get(0)).get("msg"));
        }
        if (msgType.equals("custom")) {
            List maps = JSONObject.parseArray((String)JSONObject.toJSONString(((Map)receiveMessageDto.getPayload().getBodies().get(0)).get("customExts")), Map.class);
            Map map1 = (Map)maps.get(0);
            String msg = MapUtils.getString((Map)map1, (Object)"msg");
            receiveMessage.setAttach(msg);
        }
        receiveMessage.setExt(JSONObject.toJSONString((Object)receiveMessageDto.getPayload().getExt()));
        return receiveMessage;
    }
}

