/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.client.sse;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.util.LanguageUtils;
import com.digiwin.athena.ania.util.MdcUtil;
import java.net.Proxy;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventStreamClient {
    private static final Logger log = LoggerFactory.getLogger(EventStreamClient.class);
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient.Builder().proxy(Proxy.NO_PROXY).connectionPool(new ConnectionPool(10, 5L, TimeUnit.MINUTES)).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).pingInterval(5L, TimeUnit.SECONDS).build();

    public static void executeSSE(String url, String digiKaiChatApiKey, String authToken, EventSourceListener eventSourceListener, JSONObject requestBody, String language, Map<String, Function> functions) {
        EventStreamClient.executeSSE((String)url, (String)digiKaiChatApiKey, (String)authToken, (String)language, null, (JSONObject)requestBody, (EventSourceListener)eventSourceListener);
    }

    public static void executeSSE(String url, String digiKaiChatApiKey, String authToken, EventSourceListener eventSourceListener, JSONObject requestBody, String language) {
        EventStreamClient.executeSSE((String)url, (String)digiKaiChatApiKey, (String)authToken, (String)language, null, (JSONObject)requestBody, (EventSourceListener)eventSourceListener);
    }

    public static void executeSSE(String url, String digiKaiChatApiKey, String authToken, String language, Headers requestHeader, JSONObject requestBody, EventSourceListener eventSourceListener) {
        RequestBody formBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)requestBody.toJSONString());
        Request.Builder requestBuilder = new Request.Builder();
        Headers headers = EventStreamClient.buildHeaders((Headers)requestHeader);
        if (headers != null) {
            requestBuilder.headers(headers);
        }
        requestBuilder.addHeader("content-type", "application/json");
        requestBuilder.addHeader("token", authToken);
        requestBuilder.addHeader("digi-middleware-auth-user", authToken);
        if (StrUtil.isNotBlank((CharSequence)digiKaiChatApiKey)) {
            requestBuilder.addHeader("digi-kai-api-key", digiKaiChatApiKey);
        }
        requestBuilder.addHeader("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        requestBuilder.addHeader("Accept-Language", LanguageUtils.toAcceptLanguage((String)language));
        requestBuilder.addHeader("digi-dap-service-chain-info", MdcUtil.getTraceId());
        requestBuilder.tag(JSONObject.class, (Object)requestBody);
        log.info("EventStreamClient.executeSSE url:{},requestBody:{},token:{},digi-kai-api-key:{},Accept-Language:{}", new Object[]{url, requestBody.toJSONString(), authToken, digiKaiChatApiKey, LanguageUtils.toAcceptLanguage((String)language)});
        Request request = requestBuilder.url(url).post(formBody).build();
        EventSource.Factory factory = EventSources.createFactory((OkHttpClient)HTTP_CLIENT);
        factory.newEventSource(request, eventSourceListener);
    }

    private static Headers buildHeaders(Headers requestHeader) {
        try {
            Headers headers;
            String chainInfo;
            Headers.Builder builder = new Headers.Builder();
            if (Objects.nonNull(requestHeader) && CollectionUtils.isNotEmpty((Collection)requestHeader.names())) {
                String chainInfo2;
                String routerKey;
                Set names = requestHeader.names();
                builder.addAll(requestHeader);
                if (!names.contains("routerKey") && StringUtils.isNotBlank((CharSequence)(routerKey = MdcUtil.getRouterKey()))) {
                    builder.add("routerKey", routerKey);
                }
                if (!names.contains("digi-dap-service-chain-info") && StringUtils.isNotBlank((CharSequence)(chainInfo2 = EventStreamClient.getChainInfo()))) {
                    builder.add("digi-dap-service-chain-info", chainInfo2);
                }
                return builder.build();
            }
            String routerKey = MdcUtil.getRouterKey();
            if (StringUtils.isNotBlank((CharSequence)routerKey)) {
                builder.add("routerKey", routerKey);
            }
            if (StringUtils.isNotBlank((CharSequence)(chainInfo = EventStreamClient.getChainInfo()))) {
                builder.add("digi-dap-service-chain-info", chainInfo);
            }
            return CollectionUtils.isNotEmpty((Collection)(headers = builder.build()).names()) ? headers : null;
        }
        catch (Exception e) {
            log.error("buildHeaders is error", (Throwable)e);
            return requestHeader;
        }
    }

    private static String getChainInfo() {
        String s = MdcUtil.get((String)"digi-dap-service-chain-info");
        if (StringUtils.isNotBlank((CharSequence)s)) {
            return s;
        }
        String traceId = MdcUtil.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId) && traceId.contains("ania")) {
            return traceId;
        }
        return null;
    }
}

