/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.client.sse;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.configuration.KnowledgeAccountConfig;
import com.digiwin.athena.ania.knowledge.client.sse.CommonEventSourceListener;
import com.digiwin.athena.ania.knowledge.context.KnowledgeContext;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import java.io.IOException;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class SceneEventSourceListener
extends CommonEventSourceListener {
    private static final Logger log = LoggerFactory.getLogger(SceneEventSourceListener.class);
    private KnowledgeAccountConfig knowledgeAccountConfig;
    private Boolean buildEvent;

    public SceneEventSourceListener(KnowledgeAccountConfig knowledgeAccountConfig, SseEventParams sseEventParams, SseEventDataService sseEventDataService) {
        this.knowledgeAccountConfig = knowledgeAccountConfig;
        this.sseEventParams = sseEventParams;
        this.sseEventDataService = sseEventDataService;
        this.buildEvent = false;
    }

    public void onOpen(EventSource eventSource, Response response) {
        log.info("SceneEventSourceListener.onOpen sseEventParams:{}", (Object)this.sseEventParams);
        String sseEmitterId = this.sseEventParams.getId();
        KnowledgeContext.setKnowledgeEventSource((String)sseEmitterId, (EventSource)eventSource);
    }

    public void onEvent(EventSource eventSource, String id, String type, String data) {
        this.buildEvent = true;
        log.info("SceneEventSourceListener.onEvent id:{},type:{},data:{}", new Object[]{id, type, data});
        if (StringUtils.isNotEmpty((CharSequence)data)) {
            EventData.EventMessage eventMessage;
            String sseEmitterId = this.sseEventParams.getId();
            String knowledgeType = this.getKnowledgeType(eventSource);
            EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent());
            if ("private".equals(knowledgeType)) {
                if ("status".equals(type) && "success".equals(data)) {
                    log.info("SceneEventSourceListener.onEvent is not need data");
                    return;
                }
                if (SseEventlEnum.EventDataMessageEnum.FILE.getMessageType().equals(type)) {
                    log.info("SceneEventSourceListener.onEvent file is not need data");
                    return;
                }
                eventMessage = new EventData.EventMessage(SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), data);
            } else {
                String message;
                JSONObject knowledgeBaseAnswer = JSONObject.parseObject((String)data);
                if (SseEventlEnum.EventDataMessageEnum.FILE.getMessageType().equals(type)) {
                    message = knowledgeBaseAnswer.getString("message");
                    if (StringUtils.isEmpty((CharSequence)message)) {
                        return;
                    }
                    eventMessage = new EventData.EventMessage(SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.FILE.getMessageType(), message);
                } else {
                    message = knowledgeBaseAnswer.getString("message").replace("`", "");
                    if (StringUtils.isEmpty((CharSequence)message)) {
                        return;
                    }
                    eventMessage = new EventData.EventMessage(SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), message);
                }
            }
            eventData.setData(eventMessage);
            this.sseEventDataService.saveEventDataLog(this.sseEventParams, eventData);
            SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEmitterId);
            if (sseEmitter == null) {
                eventSource.cancel();
                KnowledgeContext.removeKnowledgeEventSource((String)sseEmitterId);
            }
            try {
                if ("file".equals(type)) {
                    if (this.knowledgeAccountConfig.isReferencedAttachmentSwitch() && this.knowledgeAccountConfig.getReferencedAttachmentAssistants().contains(this.sseEventParams.getAssistant().getAssistantCode())) {
                        SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
                    }
                } else {
                    SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
                }
                SseEventContext.setAnswer((String)sseEmitterId, (EventData)eventData);
            }
            catch (IOException e) {
                log.error("SceneEventSourceListener.onEvent is error id:{},type:{},data:{}", new Object[]{id, type, data, e});
                KnowledgeContext.removeKnowledgeEventSource((String)sseEmitterId);
                eventSource.cancel();
                this.chatComplete(sseEmitter);
                this.sendAnswerDone(sseEmitter, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed(EventSource eventSource) {
        boolean success;
        SseEmitter sseEmitter;
        block9: {
            log.info("SceneEventSourceListener.onClosed sseEventParams:{}", (Object)this.sseEventParams);
            sseEmitter = null;
            success = true;
            try {
                String sseEmitterId = this.sseEventParams.getId();
                KnowledgeContext.removeKnowledgeEventSource((String)sseEmitterId);
                sseEmitter = KnowledgeContext.getSseEmitter((String)sseEmitterId);
                if (sseEmitter != null) {
                    if (!BooleanUtils.isTrue((Boolean)this.buildEvent) && !SseEventContext.noSupplyTerminate((String)sseEmitterId)) {
                        success = false;
                        String errorMsg = LocalsEnum.isCn((String)this.getLanguage(eventSource)) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u77e5\u8bc6\u5e93\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u77e5\u8b58\u5eab\u8acb\u6c42\u5931\u6557\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
                        EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), errorMsg);
                        this.sseEventDataService.saveEventDataLog(this.sseEventParams, eventData);
                        SseEventContext.setAnswer((String)sseEmitterId, (EventData)eventData);
                        SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
                    }
                    break block9;
                }
                KnowledgeContext.removeAnswerStatus((String)sseEmitterId);
            }
            catch (Exception ex) {
                try {
                    log.error("SceneEventSourceListener.onClosed is error sseEventParams:{}", (Object)BaseUseUtils.toJsonString((Object)this.sseEventParams), (Object)ex);
                }
                catch (Throwable throwable) {
                    if (Objects.nonNull(sseEmitter)) {
                        this.chatComplete(sseEmitter);
                        this.sendAnswerDone(sseEmitter, success);
                    }
                    throw throwable;
                }
                if (Objects.nonNull(sseEmitter)) {
                    this.chatComplete(sseEmitter);
                    this.sendAnswerDone(sseEmitter, success);
                }
            }
        }
        if (Objects.nonNull(sseEmitter)) {
            this.chatComplete(sseEmitter);
            this.sendAnswerDone(sseEmitter, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(EventSource eventSource, Throwable t, Response response) {
        this.buildEvent = true;
        log.error("SceneEventSourceListener.onFailure:{} response:{},sseEventParams:{}", new Object[]{t, response, this.sseEventParams});
        String sseEmitterId = this.sseEventParams.getId();
        SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEmitterId);
        try {
            String answer;
            if (Objects.isNull(response) || !response.isSuccessful()) {
                String language = this.getLanguage(eventSource);
                answer = LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u77e5\u8bc6\u5e93\u6682\u65e0\u54cd\u5e94\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u77e5\u8b58\u5eab\u66ab\u7121\u97ff\u61c9\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
            } else {
                ResponseBody responseBody = response.body();
                MediaType contentType = responseBody.contentType();
                if (contentType != null && "text".equals(contentType.type()) && contentType.subtype().equals("event-stream")) {
                    answer = KnowledgeContext.getAnswer((String)sseEmitterId);
                    if (StringUtils.isBlank((CharSequence)answer)) {
                        String language = this.getLanguage(eventSource);
                        answer = LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u77e5\u8bc6\u5e93\u8fd4\u56de\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u77e5\u8b58\u5eab\u8fd4\u56de\u6578\u64da\u89e3\u6790\u5f02\u5e38\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
                    }
                } else {
                    if (t instanceof IllegalStateException && t.getMessage().startsWith("ResponseBodyEmitter has already completed")) {
                        return;
                    }
                    answer = this.getErrorMsg(responseBody);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)answer)) {
                EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent());
                eventData.setData(new EventData.EventMessage(SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer));
                this.sseEventDataService.saveEventDataLog(this.sseEventParams, eventData);
                SseEventContext.setAnswer((String)sseEmitterId, (EventData)eventData);
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
            }
        }
        catch (Exception e) {
            log.error("KnowledgeEventSourceListener.onFailure is error sseEmitterId:{}", (Object)sseEmitterId, (Object)e);
        }
        finally {
            this.chatComplete(sseEmitter);
            this.sendAnswerDone(sseEmitter, false);
        }
    }
}

