/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.context;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.digiwin.athena.ania.common.enums.AssistantSubTypeEnum;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.intentflow.dto.IntentFlowEventData;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SseEventContext {
    private static final Logger log = LoggerFactory.getLogger(SseEventContext.class);
    private static Map<String, List<EventData>> answerData = new ConcurrentHashMap();

    public static void setAnswer(String id, EventData data) {
        ArrayList<EventData> eventData = (ArrayList<EventData>)answerData.get(id);
        if (Objects.isNull(eventData)) {
            eventData = new ArrayList<EventData>();
        }
        eventData.add(data);
        answerData.put(id, eventData);
    }

    public static List<EventData> getAnswer(String id) {
        return (List)answerData.get(id);
    }

    public static boolean showAnswer(String id) {
        List answer = SseEventContext.getAnswer((String)id);
        if (CollectionUtils.isNotEmpty((Collection)answer)) {
            return answer.stream().anyMatch(item -> SseEventlEnum.MESSAGE_DELTA.getEvent().equals(item.getEvent()));
        }
        return false;
    }

    public static void removeAnswer(String id) {
        answerData.remove(id);
    }

    public static boolean noSupplyTerminate(String id) {
        List answer = SseEventContext.getAnswer((String)id);
        return SseEventContext.noSupplyTerminate((List)answer);
    }

    public static boolean noSupplyTerminate(List<EventData> answer) {
        if (CollectionUtils.isNotEmpty(answer)) {
            for (int i = answer.size() - 1; i >= 0; --i) {
                EventData item = answer.get(i);
                if (!SseEventlEnum.MESSAGE_DELTA.getEvent().equals(item.getEvent()) && !SseEventlEnum.CHAT_COMPLETED.getEvent().equals(item.getEvent()) && !SseEventlEnum.CHAT_FAILED.getEvent().equals(item.getEvent()) && !SseEventlEnum.CHAT_DONE.getEvent().equals(item.getEvent())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<EventData> getMessageByType(List<EventData> answers, SseEventlEnum.EventDataMessageEnum eventDataMessageEnum) {
        return CollUtil.emptyIfNull(answers).stream().filter(answer -> SseEventlEnum.MESSAGE_DELTA.getEvent().equals(answer.getEvent())).filter(answer -> SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType().equals(answer.getData().getType())).filter(answer -> eventDataMessageEnum.getMessageType().equals(answer.getData().getMessage_type())).collect(Collectors.toList());
    }

    public static List<EventData.EventMessage> functionList(List<EventData> answers) {
        List<EventData.EventMessage> functionList = answers.stream().filter(eventData -> SseEventlEnum.MESSAGE_COMPLETED.getEvent().equals(eventData.getEvent()) || SseEventlEnum.MESSAGE_DELTA.getEvent().equals(eventData.getEvent())).filter(eventData -> Objects.nonNull(eventData.getData())).filter(eventData -> SseEventlEnum.SseEventDataTypeEnum.FUNCTION_CALL.getType().equals(eventData.getData().getType()) || SseEventlEnum.SseEventDataTypeEnum.TOOL_RESPONSE.getType().equals(eventData.getData().getType()) || SseEventlEnum.SseEventDataTypeEnum.FUNCTION_ANSWER.getType().equals(eventData.getData().getType())).map(answer -> answer.getData()).collect(Collectors.toList());
        HashMap<String, IntentFlowEventData.IntentEventMessage> answerFunctionMap = new HashMap<String, IntentFlowEventData.IntentEventMessage>();
        Iterator iterator = functionList.iterator();
        while (iterator.hasNext()) {
            EventData.EventMessage eventMessage = (EventData.EventMessage)iterator.next();
            if (!SseEventlEnum.SseEventDataTypeEnum.FUNCTION_ANSWER.getType().equals(eventMessage.getType())) continue;
            IntentFlowEventData.IntentEventMessage intentEventMessage = (IntentFlowEventData.IntentEventMessage)eventMessage;
            String call_id = intentEventMessage.getExtra_info().getString("call_id");
            IntentFlowEventData.IntentEventMessage answerFunction = (IntentFlowEventData.IntentEventMessage)answerFunctionMap.get(call_id);
            if (Objects.isNull(answerFunction)) {
                answerFunctionMap.put(call_id, intentEventMessage);
                continue;
            }
            String message = answerFunction.getMessage();
            String messageAgg = message + intentEventMessage.getMessage();
            answerFunction.setMessage(messageAgg);
            iterator.remove();
        }
        return functionList;
    }

    public static boolean canceled(List<EventData> answers) {
        return answers.stream().filter(eventData -> SseEventlEnum.CHAT_DONE.getEvent().equals(eventData.getEvent())).filter(eventData -> Objects.nonNull(eventData.getData())).filter(eventData -> SseEventlEnum.SseEventDataTypeEnum.VERBOSE.getType().equals(eventData.getData().getType())).anyMatch(eventData -> {
            JSONObject jsonObject = JSONObject.parseObject((String)eventData.getData().getMessage());
            return jsonObject.getBoolean("canceled") == true;
        });
    }

    public static List<EventData.EventMessage> getCardList(SseEventParams sseEventParams, List<EventData> answers) {
        SseEventParams.ActionScene actionScene;
        if (Objects.nonNull(sseEventParams.getAssistant()) && (AssistantSubTypeEnum.COMPOSITE.getType().equals(sseEventParams.getAssistant().getAssistantSubType()) || AssistantSubTypeEnum.DATA.getType().equals(sseEventParams.getAssistant().getAssistantSubType())) && Objects.nonNull(actionScene = sseEventParams.getActionScene()) && 1 == sseEventParams.getActionScene().getType()) {
            return answers.stream().filter(eventData -> SseEventlEnum.MESSAGE_DELTA.getEvent().equals(eventData.getEvent())).filter(eventData -> Objects.nonNull(eventData.getData())).filter(eventData -> SseEventlEnum.EventDataMessageEnum.CARD.getMessageType().equals(eventData.getData().getMessage_type())).map(eventData -> eventData.getData()).collect(Collectors.toList());
        }
        return null;
    }

    public static EventData lastFunctionCall(String id) {
        List answer = SseEventContext.getAnswer((String)id);
        return SseEventContext.lastFunctionCall((List)answer);
    }

    public static EventData lastFunctionCall(List<EventData> answers) {
        List eventDataList;
        if (CollectionUtils.isNotEmpty(answers) && CollectionUtils.isNotEmpty(eventDataList = answers.stream().filter(eventData -> SseEventlEnum.MESSAGE_COMPLETED.getEvent().equals(eventData.getEvent())).filter(eventData -> Objects.nonNull(eventData.getData())).filter(eventData -> SseEventlEnum.SseEventDataTypeEnum.FUNCTION_CALL.getType().equals(eventData.getData().getType()) || SseEventlEnum.SseEventDataTypeEnum.TOOL_RESPONSE.getType().equals(eventData.getData().getType())).collect(Collectors.toList()))) {
            EventData eventData2 = (EventData)eventDataList.get(eventDataList.size() - 1);
            if (SseEventlEnum.MESSAGE_COMPLETED.getEvent().equals(eventData2.getEvent()) && Objects.nonNull(eventData2.getData()) && SseEventlEnum.SseEventDataTypeEnum.FUNCTION_CALL.getType().equals(eventData2.getData().getType())) {
                return eventData2;
            }
        }
        return null;
    }

    public static List<EventData> getContentEventData(List<EventData> answers) {
        return CollUtil.emptyIfNull(answers).stream().filter(answer -> SseEventlEnum.MESSAGE_DELTA.getEvent().equals(answer.getEvent())).filter(answer -> SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType().equals(answer.getData().getType())).collect(Collectors.toList());
    }

    public static Triple<List<EventData>, List<EventData>, List<EventData>> groupEventData(List<EventData> answers) {
        if (CollectionUtils.isEmpty(answers)) {
            return Triple.of(null, null, null);
        }
        ArrayList<EventData> content = new ArrayList<EventData>();
        ArrayList<EventData> follow = new ArrayList<EventData>();
        ArrayList<EventData> head = new ArrayList<EventData>();
        for (EventData eventData : answers) {
            SseEventlEnum.SseEventDataTypeEnum eventDataType;
            if (!Objects.nonNull(eventData.getData()) || !Objects.nonNull(eventDataType = SseEventlEnum.SseEventDataTypeEnum.getEventDataType((String)eventData.getData().getType()))) continue;
            switch (1.$SwitchMap$com$digiwin$athena$ania$common$enums$SseEventlEnum$SseEventDataTypeEnum[eventDataType.ordinal()]) {
                case 1: {
                    content.add(eventData);
                    break;
                }
                case 2: {
                    follow.add(eventData);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    head.add(eventData);
                }
            }
        }
        return Triple.of(content, head, follow);
    }

    public static List<Map> buildContent(List<EventData> contentEventData) {
        LinkedList<Map> content = new LinkedList<Map>();
        if (CollectionUtils.isEmpty(contentEventData)) {
            return content;
        }
        AtomicInteger prevKey = new AtomicInteger(0);
        List result = IntStream.range(0, contentEventData.size()).boxed().collect(Collectors.groupingBy(i -> {
            int prevIndex = i - 1;
            if (prevIndex < 0) {
                return prevKey.get();
            }
            EventData prev = (EventData)contentEventData.get(prevIndex);
            EventData current = (EventData)contentEventData.get((int)i);
            if (Objects.equals(prev.getData().getMessage_type(), current.getData().getMessage_type())) {
                return prevKey.get();
            }
            return prevKey.addAndGet(1);
        })).values().stream().map(indexList -> indexList.stream().map(contentEventData::get).collect(Collectors.toList())).collect(Collectors.toList());
        for (List data : result) {
            if (SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType().equals(((EventData)data.get(0)).getData().getMessage_type())) {
                String msg = data.stream().map(item -> item.getData().getEventData().getMessage().getText()).collect(Collectors.joining());
                HashMap<String, String> text = new HashMap<String, String>();
                text.put("type", SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType());
                text.put(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), msg);
                content.add(text);
                continue;
            }
            for (EventData noText : data) {
                EventData.EventMessage message = noText.getData();
                HashMap<String, String> contentData = new HashMap<String, String>((Map<String, String>)JSON.parseObject((String)message.getEventData().getMessage().getContent()));
                contentData.put("type", message.getMessage_type());
                contentData.remove("message_type");
                content.add(contentData);
            }
        }
        return content;
    }

    public static void buildTerminateContent(ConversationMessage conversationMessage, SseEventParams sseEventParams) {
        if (CollUtil.isEmpty((Collection)conversationMessage.getContent())) {
            ArrayList content = new ArrayList();
            HashMap<String, String> text = new HashMap<String, String>(1);
            text.put("type", SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType());
            text.put(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), LocalsEnum.isCn((String)sseEventParams.getLanguage()) ? "\u60a8\u5df2\u7ec8\u6b62\u5bf9\u8bdd" : "\u60a8\u5df2\u7d42\u6b62\u5c0d\u8a71");
            content.add(text);
            conversationMessage.setContent(content);
        }
    }
}

