/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.server;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.ChatGptPromptEnum;
import com.digiwin.athena.ania.dto.chatgpt.ChatGptRequest;
import com.digiwin.athena.ania.helper.ChatGptHelper;
import com.digiwin.athena.ania.helper.KmHelper;
import com.digiwin.athena.ania.knowledge.server.dto.HisAssistantChatDto;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.mongo.repository.AssistantSceneDao;
import com.digiwin.athena.ania.util.ChatGptUtils;
import com.digiwin.athena.ania.util.DateUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IntroducerComponent {
    private static final String SCENE_DESC = "%s: \u5f53\u7528\u6237\u8bf7\u6c42\u6211\u6267\u884c%s\u4efb\u52a1\u65f6\uff0c\u5c5e\u4e8e%s\u3002";
    private static final String SCENE_SCRIPT = "\u4f8b\u5982\u7528\u6237\u8baf\u606f%s\uff0c\u8fd9\u4e9b\u8bf7\u6c42\u60c5\u51b5\u88ab\u5f52\u7c7b\u4e3a%s\u3002";
    private static final String SCENE_EXAMPLE_INPUT = "\u8f93\u5165:\u7528\u6237\u4f20\u9001\u7684\u8baf\u606f\u300c\"\u5a1c\u5a1c\"\uff0c%s\u300d\uff0c\u8bf7\u5728\u601d\u8003\u9009\u62e9\u547d\u4ee4\u7684\u539f\u56e0\u540e\u7b80\u77ed\u56de\u7b54JSON\uff0c\u4e0d\u8981\u589e\u52a0\u8bf4\u660e\u989d\u5916\u4fe1\u606f";
    private static final String SCENE_EXAMPLE_OUTPUT = "--> \u8f93\u51fa:{\"command\":\"startTemplate\",\"intentType\":\"%s\", \"scores\": %s}";
    @Autowired
    private KmHelper kmHelper;
    @Autowired
    private ChatGptHelper chatGptHelper;
    @Autowired
    private AssistantSceneDao assistantSceneDao;

    public JSONObject introducerLargeModel(SseEventParams sseEventParams) {
        Assistant assistant = sseEventParams.getAssistant();
        HisAssistantChatDto question = sseEventParams.getQuestion();
        AuthoredUser user = sseEventParams.getUser();
        String token = user.getToken();
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String tenantId = authoredUser.getTenantId();
        String tenantVersion = this.kmHelper.getTenantVersion(tenantId);
        ChatGptRequest chatGptRequest = new ChatGptRequest();
        chatGptRequest.setPrompt(ChatGptPromptEnum.DESIGNER_START_CLASSIFY_COMMAND);
        Date toDay = new Date();
        ArrayList<BasicNameValuePair> systemParam = new ArrayList<BasicNameValuePair>();
        systemParam.add(new BasicNameValuePair("#(userName)", user.getUserName()));
        String toDayDesc = DateUtils.parseDateOfPattern((Date)toDay, (String)"YYYY\u5e74M\u6708d\u65e5") + ChatGptUtils.getWeekOfDate((Date)toDay);
        systemParam.add(new BasicNameValuePair("#(assistantName)", assistant.getName()));
        systemParam.add(new BasicNameValuePair("#(assistantDescription)", assistant.getDescription()));
        systemParam.add(new BasicNameValuePair("#(toDayDesc)", toDayDesc));
        List assistantScenes = this.assistantSceneDao.findAllByAssistantCodeAndVersion(assistant.getAssistantCode(), tenantVersion);
        List sceneNames = assistantScenes.stream().map(AssistantScene::getName).collect(Collectors.toList());
        ArrayList<String> allSceneDesc = new ArrayList<String>();
        ArrayList<String> sceneIntroduces = new ArrayList<String>();
        ArrayList<String> noSceneNames = new ArrayList<String>();
        ArrayList allExamples = new ArrayList();
        ArrayList allScripts = new ArrayList();
        HashMap<String, AssistantScene> assistantSceneMap = new HashMap<String, AssistantScene>();
        for (AssistantScene scene : assistantScenes) {
            if (CollectionUtils.isNotEmpty((Collection)scene.getInspirationPhrase())) {
                allScripts.addAll(scene.getInspirationPhrase());
            }
            noSceneNames.add("\u4e0d\u8981" + scene.getName());
            sceneIntroduces.add("- " + scene.getName() + ":" + scene.getDescription());
            allSceneDesc.add(this.buildSceneDesc(scene));
            List buildSceneExamples = this.buildSceneExamples(scene, sceneNames);
            if (CollectionUtils.isNotEmpty((Collection)buildSceneExamples)) {
                allExamples.addAll(buildSceneExamples);
            }
            assistantSceneMap.put(scene.getName(), scene);
        }
        AtomicInteger index = new AtomicInteger(4);
        String allSceneDescStr = allSceneDesc.stream().map(e -> index.getAndIncrement() + "." + e).collect(Collectors.joining("\n"));
        systemParam.add(new BasicNameValuePair("#(sceneIntroduces)", String.join((CharSequence)"\u3001", sceneIntroduces)));
        systemParam.add(new BasicNameValuePair("#(sceneNames)", String.join((CharSequence)"\u3001", sceneNames)));
        systemParam.add(new BasicNameValuePair("#(allSceneDesc)", allSceneDescStr));
        int number = allSceneDesc.size() + 3;
        for (int i = 1; i <= 7; ++i) {
            systemParam.add(new BasicNameValuePair("#(number_" + i + ")", Integer.toString(number + i)));
        }
        systemParam.add(new BasicNameValuePair("#(noSceneNames)", String.join((CharSequence)"\u3001", noSceneNames)));
        systemParam.add(new BasicNameValuePair("#(examples)", String.join((CharSequence)"\n", allExamples)));
        chatGptRequest.setSystemParam(systemParam);
        BasicNameValuePair content = new BasicNameValuePair("#(content)", question.getMessage().getText().replace("\n", " "));
        chatGptRequest.setUserParam(Collections.singletonList(content));
        String result = this.chatGptHelper.commonRequestGpt(chatGptRequest, token);
        return JSON.parseObject((String)result);
    }

    private String buildSceneDesc(AssistantScene scene) {
        String name = scene.getName();
        String sceneDesc = String.format(SCENE_DESC, name, name, name);
        if (CollectionUtils.isNotEmpty((Collection)scene.getInspirationPhrase())) {
            String collect = scene.getInspirationPhrase().stream().map(item -> "\uff02" + item + "\uff02").collect(Collectors.joining("\u3001"));
            return sceneDesc + String.format(SCENE_SCRIPT, collect, scene.getName());
        }
        return sceneDesc;
    }

    private List<String> buildSceneExamples(AssistantScene scene, List<String> allSceneNames) {
        if (CollectionUtils.isNotEmpty((Collection)scene.getInspirationPhrase())) {
            JSONObject scores = new JSONObject();
            allSceneNames.forEach(name -> {
                int num = 1;
                if (name.equals(scene.getName())) {
                    num = 10;
                }
                scores.put(name, (Object)num);
            });
            return scene.getInspirationPhrase().stream().map(script -> {
                String sceneExampleInput = String.format(SCENE_EXAMPLE_INPUT, CharSequenceUtil.removeSuffix((CharSequence)script, (CharSequence)"\u5a1c\u5a1c\uff0c"));
                String sceneExampleOutput = String.format(SCENE_EXAMPLE_OUTPUT, scene.getName(), scores.toJSONString());
                return sceneExampleInput + "\n" + sceneExampleOutput;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

