/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.server;

import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.im.ImTypeHandlerStrategy;
import com.digiwin.athena.ania.knowledge.context.KnowledgeContext;
import com.digiwin.athena.ania.knowledge.server.KnowledgeSseEmitterComponent;
import com.digiwin.athena.ania.knowledge.server.dto.KnowledgeAssistantRequestDto;
import com.digiwin.athena.ania.mongo.repository.AsaKnowledgeMessageDao;
import com.digiwin.athena.ania.util.LanguageUtils;
import com.digiwin.athena.appcore.exception.BusinessException;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class KnowledgeSseEmitterComponent {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeSseEmitterComponent.class);
    @Resource
    private EnvProperties envProperties;
    @Autowired
    private ImTypeHandlerStrategy imTypeHandlerStrategy;
    @Resource
    private AsaKnowledgeMessageDao asaKnowledgeMessageDao;
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Value(value="${yunxin.knowledgeQueueName}")
    private String knowledgeQueueName;

    public SseEmitter generateSseEmitter(String id, KnowledgeAssistantRequestDto requestParam) {
        SseEmitter sseEmitter = new SseEmitter(Long.valueOf(300000L));
        String language = LanguageUtils.processSseLanguage();
        KnowledgeContext.setSseEmitter((String)id, (SseEmitter)sseEmitter);
        sseEmitter.onTimeout((Runnable)new TimeoutCallback(this, id, language, null));
        sseEmitter.onError((Consumer)new ErrorCallback(this, id, language, null));
        sseEmitter.onCompletion((Runnable)new CompletionCallback(this, id, language, requestParam, null));
        return sseEmitter;
    }

    public void requestFail(String id, String language, Throwable t) {
        log.error("KnowledgeSseEmitterComponent.requestFail id:{},language:{}", new Object[]{id, language, t});
        String answer = KnowledgeContext.getAnswer((String)id);
        if (StringUtils.isEmpty((CharSequence)answer)) {
            if (t instanceof BusinessException) {
                BusinessException businessException = (BusinessException)t;
                answer = businessException.getMessage();
            }
            if (StringUtils.isEmpty((CharSequence)answer)) {
                answer = LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u77e5\u8bc6\u5e93\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u77e5\u8b58\u5eab\u8acb\u6c42\u5931\u6557\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
            }
            this.sendEnd(id, answer, true);
        }
    }

    private void sendEnd(String id, String answer, boolean complete) {
        SseEmitter sseEmitter = null;
        try {
            sseEmitter = KnowledgeContext.getSseEmitter((String)id);
            if (sseEmitter == null) {
                return;
            }
            KnowledgeContext.setAnswerStatus((String)id, (String)"fail");
            sseEmitter.send(SseEmitter.event().data((Object)KnowledgeContext.buildData((String)"answer", (String)"success", (String)answer)));
            KnowledgeContext.setAnswer((String)id, (String)answer);
            if (complete) {
                sseEmitter.complete();
            }
        }
        catch (IllegalStateException e) {
            if (sseEmitter != null && e.getMessage().startsWith("ResponseBodyEmitter has already completed")) {
                KnowledgeContext.setAnswer((String)id, (String)answer);
                sseEmitter.completeWithError((Throwable)BusinessException.create((String)answer));
            }
        }
        catch (Exception e) {
            log.error("sendEnd is error id:{},answer:{}", new Object[]{id, answer, e});
        }
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }

    static /* synthetic */ void access$400(KnowledgeSseEmitterComponent x0, String x1, String x2, boolean x3) {
        x0.sendEnd(x1, x2, x3);
    }

    static /* synthetic */ AsaKnowledgeMessageDao access$500(KnowledgeSseEmitterComponent x0) {
        return x0.asaKnowledgeMessageDao;
    }

    static /* synthetic */ RabbitTemplate access$600(KnowledgeSseEmitterComponent x0) {
        return x0.rabbitTemplate;
    }

    static /* synthetic */ String access$700(KnowledgeSseEmitterComponent x0) {
        return x0.knowledgeQueueName;
    }
}

