/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mapper.mongo;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.mongo.domain.AsaKnowledgeMessage;
import com.digiwin.dap.middleware.lmc.http.client.ServiceException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class AsaKnowledgeMessageMapper {
    @Resource
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplate;
    private static final String COLLECTION_NAME = "asaKnowledgeMessage";

    public List<AsaKnowledgeMessage> getAsaKnowledgeMessages(String from, String code, Integer historyNum) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"to").is((Object)from), Criteria.where((String)"assistantSceneCode").is((Object)code), Criteria.where((String)"finish").is((Object)true)});
        query.addCriteria((CriteriaDefinition)criteria);
        query.limit(historyNum.intValue());
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        List asaKnowledgeMessageList = this.mongoTemplate.find(query, AsaKnowledgeMessage.class, COLLECTION_NAME);
        if (CollectionUtils.isEmpty((Collection)asaKnowledgeMessageList)) {
            return Collections.emptyList();
        }
        return asaKnowledgeMessageList;
    }

    public List<AsaKnowledgeMessage> getMessages(List<String> ids) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        List asaKnowledgeMessageList = this.mongoTemplate.find(query, AsaKnowledgeMessage.class, COLLECTION_NAME);
        if (CollectionUtils.isEmpty((Collection)asaKnowledgeMessageList)) {
            return Collections.emptyList();
        }
        return asaKnowledgeMessageList;
    }

    public JSONObject find(JSONObject jsonObject) {
        String msgId = jsonObject.getString("msgId");
        String traceId = jsonObject.getString("traceId");
        if (StrUtil.isBlank((CharSequence)msgId) && StrUtil.isBlank((CharSequence)traceId)) {
            throw new ServiceException("\u53c2\u6570msgId,traceId\u90fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        if (StrUtil.isNotBlank((CharSequence)msgId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"msgId").is((Object)msgId));
        }
        if (StrUtil.isNotBlank((CharSequence)traceId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"traceId").is((Object)traceId));
        }
        return (JSONObject)this.mongoTemplate.findOne(query, JSONObject.class, COLLECTION_NAME);
    }
}

