/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.domain;

import com.digiwin.athena.ania.entity.ImMessageLog;
import com.digiwin.athena.ania.eventbus.agile.event.AgileDataLogEvent;
import com.digiwin.athena.ania.mongo.domain.AgileDataResultLog;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(value="ania_agile_data_result_log")
public class AgileDataResultLog {
    @Id
    private String id;
    private String assistantCode;
    private String userId;
    private String userName;
    private String tenantId;
    private String tenantName;
    private String terminal;
    private String msgidServer;
    private String snapshotId;
    private String question;
    private String errorAnswer;
    private String answerOpinion;
    private String backContent;
    private String checkOpinions;
    private Integer feedbackType;
    private Integer success;
    private String answer;
    private Map<String, Object> params;
    private Map<String, Object> data;
    private Map<String, Object> extendInfo;
    private Map<String, Object> querySchema;
    private LocalDateTime createTime;
    private LocalDateTime createBackTime;
    private LocalDateTime modifyTime;
    private LocalDateTime answerTime;
    private String resSecTime;
    private ImMessageLog imMessageLog;

    public static AgileDataResultLog save(AgileDataLogEvent agileDataLogEvent, ImMessageLog imMessageLog) {
        AgileDataResultLog agileDataResultLog = new AgileDataResultLog();
        agileDataResultLog.setUserId(agileDataLogEvent.getAuthoredUser().getUserId());
        agileDataResultLog.setUserName(agileDataLogEvent.getAuthoredUser().getUserName());
        agileDataResultLog.setTenantId(agileDataLogEvent.getAuthoredUser().getTenantId());
        agileDataResultLog.setTenantName(agileDataLogEvent.getAuthoredUser().getTenantName());
        agileDataResultLog.setTerminal(agileDataLogEvent.getTerminal());
        agileDataResultLog.setAssistantCode(agileDataLogEvent.getAssistantCode());
        agileDataResultLog.setMsgidServer(agileDataLogEvent.getMsgidServer());
        agileDataResultLog.setSnapshotId(agileDataLogEvent.getSnapshotId());
        agileDataResultLog.setSuccess(agileDataLogEvent.getSuccess());
        agileDataResultLog.setErrorAnswer(agileDataLogEvent.getErrorAnswer());
        agileDataResultLog.setAnswerOpinion(agileDataLogEvent.getAnswerOpinion());
        agileDataResultLog.setAnswer(agileDataLogEvent.getAnswer());
        agileDataResultLog.setFeedbackType(agileDataLogEvent.getFeedbackType());
        agileDataResultLog.setParams(MapUtils.isNotEmpty((Map)agileDataLogEvent.getParams()) ? agileDataLogEvent.getParams() : Maps.newHashMap());
        agileDataResultLog.setData(MapUtils.isNotEmpty((Map)agileDataLogEvent.getData()) ? agileDataLogEvent.getData() : Maps.newHashMap());
        agileDataResultLog.setBackContent(agileDataLogEvent.getBackContent());
        agileDataResultLog.setCheckOpinions(agileDataLogEvent.getCheckOpinions());
        agileDataResultLog.setExtendInfo(MapUtils.isNotEmpty((Map)agileDataLogEvent.getExtendInfo()) ? agileDataLogEvent.getExtendInfo() : Maps.newHashMap());
        agileDataResultLog.setCreateTime(LocalDateTime.now());
        agileDataResultLog.setAnswerTime(agileDataLogEvent.getAnswerTime());
        agileDataResultLog.setImMessageLog(imMessageLog);
        Optional<LocalDateTime> askTimeOptional = Optional.ofNullable(agileDataLogEvent.getAskTime());
        Optional<LocalDateTime> answerTimeOptional = Optional.ofNullable(agileDataLogEvent.getAnswerTime());
        if (askTimeOptional.isPresent() && answerTimeOptional.isPresent()) {
            Duration duration = Duration.between(agileDataLogEvent.getAskTime(), agileDataLogEvent.getAnswerTime());
            String resSecTime = String.valueOf(duration.getSeconds());
            agileDataResultLog.setResSecTime(resSecTime);
        }
        return agileDataResultLog;
    }

    public static AgileDataResultLogBuilder builder() {
        return new AgileDataResultLogBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getAssistantCode() {
        return this.assistantCode;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public String getTerminal() {
        return this.terminal;
    }

    public String getMsgidServer() {
        return this.msgidServer;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public String getQuestion() {
        return this.question;
    }

    public String getErrorAnswer() {
        return this.errorAnswer;
    }

    public String getAnswerOpinion() {
        return this.answerOpinion;
    }

    public String getBackContent() {
        return this.backContent;
    }

    public String getCheckOpinions() {
        return this.checkOpinions;
    }

    public Integer getFeedbackType() {
        return this.feedbackType;
    }

    public Integer getSuccess() {
        return this.success;
    }

    public String getAnswer() {
        return this.answer;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public Map<String, Object> getExtendInfo() {
        return this.extendInfo;
    }

    public Map<String, Object> getQuerySchema() {
        return this.querySchema;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public LocalDateTime getCreateBackTime() {
        return this.createBackTime;
    }

    public LocalDateTime getModifyTime() {
        return this.modifyTime;
    }

    public LocalDateTime getAnswerTime() {
        return this.answerTime;
    }

    public String getResSecTime() {
        return this.resSecTime;
    }

    public ImMessageLog getImMessageLog() {
        return this.imMessageLog;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAssistantCode(String assistantCode) {
        this.assistantCode = assistantCode;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }

    public void setMsgidServer(String msgidServer) {
        this.msgidServer = msgidServer;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public void setErrorAnswer(String errorAnswer) {
        this.errorAnswer = errorAnswer;
    }

    public void setAnswerOpinion(String answerOpinion) {
        this.answerOpinion = answerOpinion;
    }

    public void setBackContent(String backContent) {
        this.backContent = backContent;
    }

    public void setCheckOpinions(String checkOpinions) {
        this.checkOpinions = checkOpinions;
    }

    public void setFeedbackType(Integer feedbackType) {
        this.feedbackType = feedbackType;
    }

    public void setSuccess(Integer success) {
        this.success = success;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public void setExtendInfo(Map<String, Object> extendInfo) {
        this.extendInfo = extendInfo;
    }

    public void setQuerySchema(Map<String, Object> querySchema) {
        this.querySchema = querySchema;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setCreateBackTime(LocalDateTime createBackTime) {
        this.createBackTime = createBackTime;
    }

    public void setModifyTime(LocalDateTime modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setAnswerTime(LocalDateTime answerTime) {
        this.answerTime = answerTime;
    }

    public void setResSecTime(String resSecTime) {
        this.resSecTime = resSecTime;
    }

    public void setImMessageLog(ImMessageLog imMessageLog) {
        this.imMessageLog = imMessageLog;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgileDataResultLog)) {
            return false;
        }
        AgileDataResultLog other = (AgileDataResultLog)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$assistantCode = this.getAssistantCode();
        String other$assistantCode = other.getAssistantCode();
        if (this$assistantCode == null ? other$assistantCode != null : !this$assistantCode.equals(other$assistantCode)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$tenantName = this.getTenantName();
        String other$tenantName = other.getTenantName();
        if (this$tenantName == null ? other$tenantName != null : !this$tenantName.equals(other$tenantName)) {
            return false;
        }
        String this$terminal = this.getTerminal();
        String other$terminal = other.getTerminal();
        if (this$terminal == null ? other$terminal != null : !this$terminal.equals(other$terminal)) {
            return false;
        }
        String this$msgidServer = this.getMsgidServer();
        String other$msgidServer = other.getMsgidServer();
        if (this$msgidServer == null ? other$msgidServer != null : !this$msgidServer.equals(other$msgidServer)) {
            return false;
        }
        String this$snapshotId = this.getSnapshotId();
        String other$snapshotId = other.getSnapshotId();
        if (this$snapshotId == null ? other$snapshotId != null : !this$snapshotId.equals(other$snapshotId)) {
            return false;
        }
        String this$question = this.getQuestion();
        String other$question = other.getQuestion();
        if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
            return false;
        }
        String this$errorAnswer = this.getErrorAnswer();
        String other$errorAnswer = other.getErrorAnswer();
        if (this$errorAnswer == null ? other$errorAnswer != null : !this$errorAnswer.equals(other$errorAnswer)) {
            return false;
        }
        String this$answerOpinion = this.getAnswerOpinion();
        String other$answerOpinion = other.getAnswerOpinion();
        if (this$answerOpinion == null ? other$answerOpinion != null : !this$answerOpinion.equals(other$answerOpinion)) {
            return false;
        }
        String this$backContent = this.getBackContent();
        String other$backContent = other.getBackContent();
        if (this$backContent == null ? other$backContent != null : !this$backContent.equals(other$backContent)) {
            return false;
        }
        String this$checkOpinions = this.getCheckOpinions();
        String other$checkOpinions = other.getCheckOpinions();
        if (this$checkOpinions == null ? other$checkOpinions != null : !this$checkOpinions.equals(other$checkOpinions)) {
            return false;
        }
        Integer this$feedbackType = this.getFeedbackType();
        Integer other$feedbackType = other.getFeedbackType();
        if (this$feedbackType == null ? other$feedbackType != null : !((Object)this$feedbackType).equals(other$feedbackType)) {
            return false;
        }
        Integer this$success = this.getSuccess();
        Integer other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        String this$answer = this.getAnswer();
        String other$answer = other.getAnswer();
        if (this$answer == null ? other$answer != null : !this$answer.equals(other$answer)) {
            return false;
        }
        Map this$params = this.getParams();
        Map other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        Map this$data = this.getData();
        Map other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Map this$extendInfo = this.getExtendInfo();
        Map other$extendInfo = other.getExtendInfo();
        if (this$extendInfo == null ? other$extendInfo != null : !((Object)this$extendInfo).equals(other$extendInfo)) {
            return false;
        }
        Map this$querySchema = this.getQuerySchema();
        Map other$querySchema = other.getQuerySchema();
        if (this$querySchema == null ? other$querySchema != null : !((Object)this$querySchema).equals(other$querySchema)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        LocalDateTime this$createBackTime = this.getCreateBackTime();
        LocalDateTime other$createBackTime = other.getCreateBackTime();
        if (this$createBackTime == null ? other$createBackTime != null : !((Object)this$createBackTime).equals(other$createBackTime)) {
            return false;
        }
        LocalDateTime this$modifyTime = this.getModifyTime();
        LocalDateTime other$modifyTime = other.getModifyTime();
        if (this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime)) {
            return false;
        }
        LocalDateTime this$answerTime = this.getAnswerTime();
        LocalDateTime other$answerTime = other.getAnswerTime();
        if (this$answerTime == null ? other$answerTime != null : !((Object)this$answerTime).equals(other$answerTime)) {
            return false;
        }
        String this$resSecTime = this.getResSecTime();
        String other$resSecTime = other.getResSecTime();
        if (this$resSecTime == null ? other$resSecTime != null : !this$resSecTime.equals(other$resSecTime)) {
            return false;
        }
        ImMessageLog this$imMessageLog = this.getImMessageLog();
        ImMessageLog other$imMessageLog = other.getImMessageLog();
        return !(this$imMessageLog == null ? other$imMessageLog != null : !this$imMessageLog.equals(other$imMessageLog));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgileDataResultLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $assistantCode = this.getAssistantCode();
        result = result * 59 + ($assistantCode == null ? 43 : $assistantCode.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $tenantName = this.getTenantName();
        result = result * 59 + ($tenantName == null ? 43 : $tenantName.hashCode());
        String $terminal = this.getTerminal();
        result = result * 59 + ($terminal == null ? 43 : $terminal.hashCode());
        String $msgidServer = this.getMsgidServer();
        result = result * 59 + ($msgidServer == null ? 43 : $msgidServer.hashCode());
        String $snapshotId = this.getSnapshotId();
        result = result * 59 + ($snapshotId == null ? 43 : $snapshotId.hashCode());
        String $question = this.getQuestion();
        result = result * 59 + ($question == null ? 43 : $question.hashCode());
        String $errorAnswer = this.getErrorAnswer();
        result = result * 59 + ($errorAnswer == null ? 43 : $errorAnswer.hashCode());
        String $answerOpinion = this.getAnswerOpinion();
        result = result * 59 + ($answerOpinion == null ? 43 : $answerOpinion.hashCode());
        String $backContent = this.getBackContent();
        result = result * 59 + ($backContent == null ? 43 : $backContent.hashCode());
        String $checkOpinions = this.getCheckOpinions();
        result = result * 59 + ($checkOpinions == null ? 43 : $checkOpinions.hashCode());
        Integer $feedbackType = this.getFeedbackType();
        result = result * 59 + ($feedbackType == null ? 43 : ((Object)$feedbackType).hashCode());
        Integer $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        String $answer = this.getAnswer();
        result = result * 59 + ($answer == null ? 43 : $answer.hashCode());
        Map $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        Map $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Map $extendInfo = this.getExtendInfo();
        result = result * 59 + ($extendInfo == null ? 43 : ((Object)$extendInfo).hashCode());
        Map $querySchema = this.getQuerySchema();
        result = result * 59 + ($querySchema == null ? 43 : ((Object)$querySchema).hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        LocalDateTime $createBackTime = this.getCreateBackTime();
        result = result * 59 + ($createBackTime == null ? 43 : ((Object)$createBackTime).hashCode());
        LocalDateTime $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        LocalDateTime $answerTime = this.getAnswerTime();
        result = result * 59 + ($answerTime == null ? 43 : ((Object)$answerTime).hashCode());
        String $resSecTime = this.getResSecTime();
        result = result * 59 + ($resSecTime == null ? 43 : $resSecTime.hashCode());
        ImMessageLog $imMessageLog = this.getImMessageLog();
        result = result * 59 + ($imMessageLog == null ? 43 : $imMessageLog.hashCode());
        return result;
    }

    public String toString() {
        return "AgileDataResultLog(id=" + this.getId() + ", assistantCode=" + this.getAssistantCode() + ", userId=" + this.getUserId() + ", userName=" + this.getUserName() + ", tenantId=" + this.getTenantId() + ", tenantName=" + this.getTenantName() + ", terminal=" + this.getTerminal() + ", msgidServer=" + this.getMsgidServer() + ", snapshotId=" + this.getSnapshotId() + ", question=" + this.getQuestion() + ", errorAnswer=" + this.getErrorAnswer() + ", answerOpinion=" + this.getAnswerOpinion() + ", backContent=" + this.getBackContent() + ", checkOpinions=" + this.getCheckOpinions() + ", feedbackType=" + this.getFeedbackType() + ", success=" + this.getSuccess() + ", answer=" + this.getAnswer() + ", params=" + this.getParams() + ", data=" + this.getData() + ", extendInfo=" + this.getExtendInfo() + ", querySchema=" + this.getQuerySchema() + ", createTime=" + this.getCreateTime() + ", createBackTime=" + this.getCreateBackTime() + ", modifyTime=" + this.getModifyTime() + ", answerTime=" + this.getAnswerTime() + ", resSecTime=" + this.getResSecTime() + ", imMessageLog=" + this.getImMessageLog() + ")";
    }

    public AgileDataResultLog() {
    }

    public AgileDataResultLog(String id, String assistantCode, String userId, String userName, String tenantId, String tenantName, String terminal, String msgidServer, String snapshotId, String question, String errorAnswer, String answerOpinion, String backContent, String checkOpinions, Integer feedbackType, Integer success, String answer, Map<String, Object> params, Map<String, Object> data, Map<String, Object> extendInfo, Map<String, Object> querySchema, LocalDateTime createTime, LocalDateTime createBackTime, LocalDateTime modifyTime, LocalDateTime answerTime, String resSecTime, ImMessageLog imMessageLog) {
        this.id = id;
        this.assistantCode = assistantCode;
        this.userId = userId;
        this.userName = userName;
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.terminal = terminal;
        this.msgidServer = msgidServer;
        this.snapshotId = snapshotId;
        this.question = question;
        this.errorAnswer = errorAnswer;
        this.answerOpinion = answerOpinion;
        this.backContent = backContent;
        this.checkOpinions = checkOpinions;
        this.feedbackType = feedbackType;
        this.success = success;
        this.answer = answer;
        this.params = params;
        this.data = data;
        this.extendInfo = extendInfo;
        this.querySchema = querySchema;
        this.createTime = createTime;
        this.createBackTime = createBackTime;
        this.modifyTime = modifyTime;
        this.answerTime = answerTime;
        this.resSecTime = resSecTime;
        this.imMessageLog = imMessageLog;
    }
}

