/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.domain;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantPublishDto;
import com.digiwin.athena.ania.helper.dto.GetPublishedInfoDto;
import com.digiwin.athena.ania.mongo.domain.FusionAssistant;
import com.digiwin.athena.ania.util.FastJsonUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(value="fusion_assistant")
public class FusionAssistant {
    @Id
    private String id;
    private String assistantId;
    private String assistantType;
    private String baseURL;
    private Set<String> versions;
    private List<String> clientType;
    private Date createTime;
    private Boolean isAvailable;

    public static List<FusionAssistant> publish(List<FusionAssistant> fusionAssistants, FusionAssistantPublishDto dto, JSONArray assistantsArray) {
        Map assistantIdMap = fusionAssistants.stream().collect(Collectors.toMap(FusionAssistant::getAssistantId, Function.identity()));
        Map assistantMap = GetPublishedInfoDto.getAssistantMap((JSONArray)assistantsArray);
        HashMap<String, JSONObject> insertAssistantMap = new HashMap<String, JSONObject>();
        HashMap<String, Set> assistantVersions = new HashMap<String, Set>();
        for (JSONObject obj : dto.getEvent()) {
            String assistantId = obj.getString("assistantId");
            String version = obj.getString("version");
            FusionAssistant fusionAssistant = (FusionAssistant)assistantIdMap.get(assistantId);
            if (Objects.isNull(fusionAssistant)) {
                insertAssistantMap.putIfAbsent(assistantId, obj);
                assistantVersions.computeIfAbsent(assistantId, k -> new HashSet()).add(version);
                continue;
            }
            JSONObject assistant = (JSONObject)assistantMap.get(assistantId);
            fusionAssistant.setClientType(FastJsonUtils.toList((JSONArray)assistant.getJSONArray("clientType"), String.class));
            fusionAssistant.getVersions().add(version);
            fusionAssistant.setIsAvailable(Boolean.valueOf(true));
            fusionAssistant.setBaseURL(obj.getString("baseURL"));
        }
        List<FusionAssistant> fusionAssistantList = insertAssistantMap.values().stream().map(jsonObject -> {
            FusionAssistant fusionAssistant = new FusionAssistant();
            String assistantId = jsonObject.getString("assistantId");
            JSONObject assistant = (JSONObject)assistantMap.get(assistantId);
            fusionAssistant.setAssistantId(assistantId);
            fusionAssistant.setBaseURL(jsonObject.getString("baseURL"));
            fusionAssistant.setClientType(FastJsonUtils.toList((JSONArray)assistant.getJSONArray("clientType"), String.class));
            fusionAssistant.setVersions((Set)assistantVersions.get(assistantId));
            fusionAssistant.setIsAvailable(Boolean.valueOf(true));
            return fusionAssistant;
        }).collect(Collectors.toList());
        fusionAssistantList.addAll(fusionAssistants);
        return fusionAssistantList;
    }

    public static FusionAssistantBuilder builder() {
        return new FusionAssistantBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public String getAssistantType() {
        return this.assistantType;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public Set<String> getVersions() {
        return this.versions;
    }

    public List<String> getClientType() {
        return this.clientType;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Boolean getIsAvailable() {
        return this.isAvailable;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public void setAssistantType(String assistantType) {
        this.assistantType = assistantType;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public void setVersions(Set<String> versions) {
        this.versions = versions;
    }

    public void setClientType(List<String> clientType) {
        this.clientType = clientType;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setIsAvailable(Boolean isAvailable) {
        this.isAvailable = isAvailable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FusionAssistant)) {
            return false;
        }
        FusionAssistant other = (FusionAssistant)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$assistantId = this.getAssistantId();
        String other$assistantId = other.getAssistantId();
        if (this$assistantId == null ? other$assistantId != null : !this$assistantId.equals(other$assistantId)) {
            return false;
        }
        String this$assistantType = this.getAssistantType();
        String other$assistantType = other.getAssistantType();
        if (this$assistantType == null ? other$assistantType != null : !this$assistantType.equals(other$assistantType)) {
            return false;
        }
        String this$baseURL = this.getBaseURL();
        String other$baseURL = other.getBaseURL();
        if (this$baseURL == null ? other$baseURL != null : !this$baseURL.equals(other$baseURL)) {
            return false;
        }
        Set this$versions = this.getVersions();
        Set other$versions = other.getVersions();
        if (this$versions == null ? other$versions != null : !((Object)this$versions).equals(other$versions)) {
            return false;
        }
        List this$clientType = this.getClientType();
        List other$clientType = other.getClientType();
        if (this$clientType == null ? other$clientType != null : !((Object)this$clientType).equals(other$clientType)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Boolean this$isAvailable = this.getIsAvailable();
        Boolean other$isAvailable = other.getIsAvailable();
        return !(this$isAvailable == null ? other$isAvailable != null : !((Object)this$isAvailable).equals(other$isAvailable));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FusionAssistant;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $assistantId = this.getAssistantId();
        result = result * 59 + ($assistantId == null ? 43 : $assistantId.hashCode());
        String $assistantType = this.getAssistantType();
        result = result * 59 + ($assistantType == null ? 43 : $assistantType.hashCode());
        String $baseURL = this.getBaseURL();
        result = result * 59 + ($baseURL == null ? 43 : $baseURL.hashCode());
        Set $versions = this.getVersions();
        result = result * 59 + ($versions == null ? 43 : ((Object)$versions).hashCode());
        List $clientType = this.getClientType();
        result = result * 59 + ($clientType == null ? 43 : ((Object)$clientType).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Boolean $isAvailable = this.getIsAvailable();
        result = result * 59 + ($isAvailable == null ? 43 : ((Object)$isAvailable).hashCode());
        return result;
    }

    public String toString() {
        return "FusionAssistant(id=" + this.getId() + ", assistantId=" + this.getAssistantId() + ", assistantType=" + this.getAssistantType() + ", baseURL=" + this.getBaseURL() + ", versions=" + this.getVersions() + ", clientType=" + this.getClientType() + ", createTime=" + this.getCreateTime() + ", isAvailable=" + this.getIsAvailable() + ")";
    }

    public FusionAssistant() {
    }

    public FusionAssistant(String id, String assistantId, String assistantType, String baseURL, Set<String> versions, List<String> clientType, Date createTime, Boolean isAvailable) {
        this.id = id;
        this.assistantId = assistantId;
        this.assistantType = assistantType;
        this.baseURL = baseURL;
        this.versions = versions;
        this.clientType = clientType;
        this.createTime = createTime;
        this.isAvailable = isAvailable;
    }
}

