/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.domain;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantPlugin;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantSub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(value="fusion_assistant_plugin")
public class FusionAssistantPlugin {
    @Id
    private String id;
    private String assistantId;
    private String name;
    private String version;
    private Map pluginCustom;

    public static List<FusionAssistantPlugin> map(List<FusionAssistantSub> fusionAssistantSubs) {
        if (CollUtil.isEmpty(fusionAssistantSubs)) {
            return new ArrayList<FusionAssistantPlugin>();
        }
        ArrayList<FusionAssistantPlugin> fusionAssistantPlugins = new ArrayList<FusionAssistantPlugin>();
        for (int i = 0; i < fusionAssistantSubs.size(); ++i) {
            FusionAssistantSub fusionAssistantSub = fusionAssistantSubs.get(i);
            List pluginCustoms = fusionAssistantSub.getPluginCustoms();
            if (!CollUtil.isNotEmpty((Collection)pluginCustoms)) continue;
            for (int i1 = 0; i1 < pluginCustoms.size(); ++i1) {
                Map pluginCustom = (Map)pluginCustoms.get(i);
                FusionAssistantPlugin plugin = new FusionAssistantPlugin();
                plugin.setAssistantId(fusionAssistantSub.getAssistantId());
                plugin.setVersion(fusionAssistantSub.getVersion());
                plugin.setName((String)pluginCustom.get("name"));
                plugin.setPluginCustom(pluginCustom);
                fusionAssistantPlugins.add(plugin);
            }
        }
        return fusionAssistantPlugins;
    }

    public static FusionAssistantPluginBuilder builder() {
        return new FusionAssistantPluginBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Map getPluginCustom() {
        return this.pluginCustom;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setPluginCustom(Map pluginCustom) {
        this.pluginCustom = pluginCustom;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FusionAssistantPlugin)) {
            return false;
        }
        FusionAssistantPlugin other = (FusionAssistantPlugin)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$assistantId = this.getAssistantId();
        String other$assistantId = other.getAssistantId();
        if (this$assistantId == null ? other$assistantId != null : !this$assistantId.equals(other$assistantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Map this$pluginCustom = this.getPluginCustom();
        Map other$pluginCustom = other.getPluginCustom();
        return !(this$pluginCustom == null ? other$pluginCustom != null : !((Object)this$pluginCustom).equals(other$pluginCustom));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FusionAssistantPlugin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $assistantId = this.getAssistantId();
        result = result * 59 + ($assistantId == null ? 43 : $assistantId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Map $pluginCustom = this.getPluginCustom();
        result = result * 59 + ($pluginCustom == null ? 43 : ((Object)$pluginCustom).hashCode());
        return result;
    }

    public String toString() {
        return "FusionAssistantPlugin(id=" + this.getId() + ", assistantId=" + this.getAssistantId() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", pluginCustom=" + this.getPluginCustom() + ")";
    }

    public FusionAssistantPlugin() {
    }

    public FusionAssistantPlugin(String id, String assistantId, String name, String version, Map pluginCustom) {
        this.id = id;
        this.assistantId = assistantId;
        this.name = name;
        this.version = version;
        this.pluginCustom = pluginCustom;
    }
}

