/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.domain;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantPublishDto;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantSub;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(value="fusion_assistant_sub")
public class FusionAssistantSub {
    @Id
    private String id;
    private String assistantId;
    private String assistantName;
    private String iconUrl;
    private String assistantType;
    private JSONObject dialogueMode;
    private JSONObject inputConfig;
    private JSONObject lang;
    private String version;
    private Date createTime = new Date();
    private String description;
    @Transient
    private JSONObject inspirationPhrases;
    @Transient
    private List<Map> pluginCustoms;
    private JSONObject onboardingInfo;

    public static List<FusionAssistantSub> publish(JSONArray assistants) {
        ArrayList<FusionAssistantSub> fusionAssistantSubs = new ArrayList<FusionAssistantSub>();
        for (int i = 0; i < assistants.size(); ++i) {
            JSONObject assistant = assistants.getJSONObject(i);
            FusionAssistantSub fusionAssistantSub = new FusionAssistantSub();
            fusionAssistantSub.setAssistantId(assistant.getString("assistantId"));
            fusionAssistantSub.setAssistantName(assistant.getString("name"));
            fusionAssistantSub.setIconUrl(assistant.getString("iconUrl"));
            fusionAssistantSub.setInputConfig(assistant.getJSONObject("inputConfig"));
            fusionAssistantSub.setDialogueMode(assistant.getJSONObject("dialogueMode"));
            fusionAssistantSub.setOnboardingInfo(assistant.getJSONObject("onboardingInfo"));
            fusionAssistantSub.setLang(assistant.getJSONObject("lang"));
            fusionAssistantSub.setVersion(assistant.getString("version"));
            fusionAssistantSub.setDescription(assistant.getString("description"));
            fusionAssistantSub.setPluginCustoms((List)assistant.getJSONArray("pluginCustoms"));
            fusionAssistantSubs.add(fusionAssistantSub);
        }
        return fusionAssistantSubs;
    }

    public static void publicAssistantDetailCheck(JSONArray assistants, FusionAssistantPublishDto dto) {
        if (assistants.isEmpty()) {
            throw new ServiceException("\u6ca1\u6709\u53ef\u53d1\u5e03\u7684\u52a9\u7406\u4fe1\u606f");
        }
        if (assistants.size() != dto.getEvent().size()) {
            throw new ServiceException("\u53d1\u5e03\u52a9\u7406\u5931\u8d25");
        }
        Map<String, String> assistantIdVersionMap = dto.getEvent().stream().collect(Collectors.toMap(event -> event.getString("assistantId"), event -> event.getString("version")));
        for (int i = 0; i < assistants.size(); ++i) {
            JSONObject assistant = assistants.getJSONObject(i);
            String assistantId = assistant.getString("assistantId");
            String version = assistant.getString("version");
            Assert.notBlank((CharSequence)assistantId, () -> new ServiceException("\u670d\u52a1\u5546\u52a9\u7406\u8be6\u60c5\u63a5\u53e3\uff1aassistantId\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.notBlank((CharSequence)assistant.getString("name"), () -> new ServiceException("\u670d\u52a1\u5546\u52a9\u7406\u8be6\u60c5\u63a5\u53e3\uff1aname\u4e0d\u80fd\u4e3a\u7a7a(" + assistantId + ")"));
            Assert.notBlank((CharSequence)assistant.getString("version"), () -> new ServiceException("\u670d\u52a1\u5546\u52a9\u7406\u8be6\u60c5\u63a5\u53e3\uff1aversion\u4e0d\u80fd\u4e3a\u7a7a(" + assistantId + ")"));
            JSONArray clientType = assistant.getJSONArray("clientType");
            if (null == clientType || clientType.isEmpty()) {
                throw new ServiceException("\u670d\u52a1\u5546\u52a9\u7406\u8be6\u60c5\u63a5\u53e3\uff1aclientType\u4e0d\u80fd\u4e3a\u7a7a(" + assistantId + ")");
            }
            String publishVersion = assistantIdVersionMap.get(assistantId);
            if (publishVersion.equals(version)) continue;
            throw new ServiceException(assistantId + "\u52a9\u7406\u56de\u8c03\u8be6\u60c5\u8fd4\u56de\u7248\u672c\u53f7\u4e3a\u7a7a\u6216\u7248\u672c\u53f7\u9519\u8bef\uff0c\u8bf7\u6838\u5bf9");
        }
    }

    public static FusionAssistantSubBuilder builder() {
        return new FusionAssistantSubBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public String getAssistantName() {
        return this.assistantName;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getAssistantType() {
        return this.assistantType;
    }

    public JSONObject getDialogueMode() {
        return this.dialogueMode;
    }

    public JSONObject getInputConfig() {
        return this.inputConfig;
    }

    public JSONObject getLang() {
        return this.lang;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getDescription() {
        return this.description;
    }

    public JSONObject getInspirationPhrases() {
        return this.inspirationPhrases;
    }

    public List<Map> getPluginCustoms() {
        return this.pluginCustoms;
    }

    public JSONObject getOnboardingInfo() {
        return this.onboardingInfo;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public void setAssistantName(String assistantName) {
        this.assistantName = assistantName;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public void setAssistantType(String assistantType) {
        this.assistantType = assistantType;
    }

    public void setDialogueMode(JSONObject dialogueMode) {
        this.dialogueMode = dialogueMode;
    }

    public void setInputConfig(JSONObject inputConfig) {
        this.inputConfig = inputConfig;
    }

    public void setLang(JSONObject lang) {
        this.lang = lang;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInspirationPhrases(JSONObject inspirationPhrases) {
        this.inspirationPhrases = inspirationPhrases;
    }

    public void setPluginCustoms(List<Map> pluginCustoms) {
        this.pluginCustoms = pluginCustoms;
    }

    public void setOnboardingInfo(JSONObject onboardingInfo) {
        this.onboardingInfo = onboardingInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FusionAssistantSub)) {
            return false;
        }
        FusionAssistantSub other = (FusionAssistantSub)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$assistantId = this.getAssistantId();
        String other$assistantId = other.getAssistantId();
        if (this$assistantId == null ? other$assistantId != null : !this$assistantId.equals(other$assistantId)) {
            return false;
        }
        String this$assistantName = this.getAssistantName();
        String other$assistantName = other.getAssistantName();
        if (this$assistantName == null ? other$assistantName != null : !this$assistantName.equals(other$assistantName)) {
            return false;
        }
        String this$iconUrl = this.getIconUrl();
        String other$iconUrl = other.getIconUrl();
        if (this$iconUrl == null ? other$iconUrl != null : !this$iconUrl.equals(other$iconUrl)) {
            return false;
        }
        String this$assistantType = this.getAssistantType();
        String other$assistantType = other.getAssistantType();
        if (this$assistantType == null ? other$assistantType != null : !this$assistantType.equals(other$assistantType)) {
            return false;
        }
        JSONObject this$dialogueMode = this.getDialogueMode();
        JSONObject other$dialogueMode = other.getDialogueMode();
        if (this$dialogueMode == null ? other$dialogueMode != null : !this$dialogueMode.equals(other$dialogueMode)) {
            return false;
        }
        JSONObject this$inputConfig = this.getInputConfig();
        JSONObject other$inputConfig = other.getInputConfig();
        if (this$inputConfig == null ? other$inputConfig != null : !this$inputConfig.equals(other$inputConfig)) {
            return false;
        }
        JSONObject this$lang = this.getLang();
        JSONObject other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        JSONObject this$inspirationPhrases = this.getInspirationPhrases();
        JSONObject other$inspirationPhrases = other.getInspirationPhrases();
        if (this$inspirationPhrases == null ? other$inspirationPhrases != null : !this$inspirationPhrases.equals(other$inspirationPhrases)) {
            return false;
        }
        List this$pluginCustoms = this.getPluginCustoms();
        List other$pluginCustoms = other.getPluginCustoms();
        if (this$pluginCustoms == null ? other$pluginCustoms != null : !((Object)this$pluginCustoms).equals(other$pluginCustoms)) {
            return false;
        }
        JSONObject this$onboardingInfo = this.getOnboardingInfo();
        JSONObject other$onboardingInfo = other.getOnboardingInfo();
        return !(this$onboardingInfo == null ? other$onboardingInfo != null : !this$onboardingInfo.equals(other$onboardingInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FusionAssistantSub;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $assistantId = this.getAssistantId();
        result = result * 59 + ($assistantId == null ? 43 : $assistantId.hashCode());
        String $assistantName = this.getAssistantName();
        result = result * 59 + ($assistantName == null ? 43 : $assistantName.hashCode());
        String $iconUrl = this.getIconUrl();
        result = result * 59 + ($iconUrl == null ? 43 : $iconUrl.hashCode());
        String $assistantType = this.getAssistantType();
        result = result * 59 + ($assistantType == null ? 43 : $assistantType.hashCode());
        JSONObject $dialogueMode = this.getDialogueMode();
        result = result * 59 + ($dialogueMode == null ? 43 : $dialogueMode.hashCode());
        JSONObject $inputConfig = this.getInputConfig();
        result = result * 59 + ($inputConfig == null ? 43 : $inputConfig.hashCode());
        JSONObject $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        JSONObject $inspirationPhrases = this.getInspirationPhrases();
        result = result * 59 + ($inspirationPhrases == null ? 43 : $inspirationPhrases.hashCode());
        List $pluginCustoms = this.getPluginCustoms();
        result = result * 59 + ($pluginCustoms == null ? 43 : ((Object)$pluginCustoms).hashCode());
        JSONObject $onboardingInfo = this.getOnboardingInfo();
        result = result * 59 + ($onboardingInfo == null ? 43 : $onboardingInfo.hashCode());
        return result;
    }

    public String toString() {
        return "FusionAssistantSub(id=" + this.getId() + ", assistantId=" + this.getAssistantId() + ", assistantName=" + this.getAssistantName() + ", iconUrl=" + this.getIconUrl() + ", assistantType=" + this.getAssistantType() + ", dialogueMode=" + this.getDialogueMode() + ", inputConfig=" + this.getInputConfig() + ", lang=" + this.getLang() + ", version=" + this.getVersion() + ", createTime=" + this.getCreateTime() + ", description=" + this.getDescription() + ", inspirationPhrases=" + this.getInspirationPhrases() + ", pluginCustoms=" + this.getPluginCustoms() + ", onboardingInfo=" + this.getOnboardingInfo() + ")";
    }

    public FusionAssistantSub() {
    }

    public FusionAssistantSub(String id, String assistantId, String assistantName, String iconUrl, String assistantType, JSONObject dialogueMode, JSONObject inputConfig, JSONObject lang, String version, Date createTime, String description, JSONObject inspirationPhrases, List<Map> pluginCustoms, JSONObject onboardingInfo) {
        this.id = id;
        this.assistantId = assistantId;
        this.assistantName = assistantName;
        this.iconUrl = iconUrl;
        this.assistantType = assistantType;
        this.dialogueMode = dialogueMode;
        this.inputConfig = inputConfig;
        this.lang = lang;
        this.version = version;
        this.createTime = createTime;
        this.description = description;
        this.inspirationPhrases = inspirationPhrases;
        this.pluginCustoms = pluginCustoms;
        this.onboardingInfo = onboardingInfo;
    }
}

