/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public abstract class AbstractMongoDao<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMongoDao.class);
    protected MongoTemplate template;
    protected Class<T> entityClass;

    public MongoTemplate getMongoTemplate() {
        return this.template;
    }

    public long updateById(String id, T update) {
        return this.updateById(id, (Map)new ObjectMapper().convertValue(update, Map.class), update.getClass());
    }

    public long updateById(String id, Map<String, Object> updateParam, Class<T> entityClass) {
        return this.updateById(id, updateParam, this.template.getCollectionName(entityClass));
    }

    public long updateById(String id, Map<String, Object> updateParam, String collectionName) {
        if (StringUtils.isBlank((CharSequence)id) || MapUtils.isEmpty(updateParam)) {
            return 0L;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
        Update update = this.buildUpdate(updateParam);
        UpdateResult result = this.template.updateFirst(query, (UpdateDefinition)update, collectionName);
        return result.getMatchedCount();
    }

    public long updateByIds(List<String> ids, Map<String, Object> updateParam, Class<T> entityClass) {
        return this.updateByIds(ids, updateParam, this.template.getCollectionName(entityClass));
    }

    public long updateByIds(List<String> ids, Map<String, Object> updateParam, String collectionName) {
        if (CollectionUtils.isEmpty(ids) || MapUtils.isEmpty(updateParam)) {
            return 0L;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        Update update = this.buildUpdate(updateParam);
        UpdateResult result = this.template.updateMulti(query, (UpdateDefinition)update, collectionName);
        return result.getMatchedCount();
    }

    private Update buildUpdate(Map<String, Object> updateParam) {
        Update update = new Update();
        if (MapUtils.isNotEmpty(updateParam)) {
            for (Map.Entry<String, Object> entry : updateParam.entrySet()) {
                if (!Objects.nonNull(entry.getValue())) continue;
                update.set(entry.getKey(), entry.getValue());
            }
        }
        return update;
    }

    public Update buildUpdate(T updateParam) {
        return this.buildUpdate(this.buildParamMap(updateParam, true));
    }

    public Query buildWhereQuery(T queryParam) {
        return this.buildWhereQuery(this.buildParamMap(queryParam, false));
    }

    public Query buildWhereQuery(Map<String, Object> updateParam) {
        if (MapUtils.isEmpty(updateParam)) {
            return null;
        }
        ArrayList<Criteria> queryList = new ArrayList<Criteria>();
        for (Map.Entry<String, Object> entry : updateParam.entrySet()) {
            if (!Objects.nonNull(entry.getValue())) continue;
            queryList.add(Criteria.where((String)entry.getKey()).is(entry.getValue()));
        }
        if (CollectionUtils.isEmpty(queryList)) {
            return null;
        }
        Query whereQuery = new Query();
        queryList.forEach(query -> whereQuery.addCriteria(query));
        return whereQuery;
    }

    public UpdateResult updateWhere(Map<String, Object> query, Map<String, Object> updateParam, Class<T> entityClass) {
        return this.template.updateMulti(this.buildWhereQuery(query), (UpdateDefinition)this.buildUpdate(updateParam), entityClass);
    }

    public UpdateResult updateWhere(Map<String, Object> query, T update) {
        return this.update(this.buildWhereQuery(query), update);
    }

    public UpdateResult update(Query query, T update) {
        if (Objects.isNull(update)) {
            return null;
        }
        return this.template.updateMulti(query, (UpdateDefinition)this.buildUpdate(update), update.getClass());
    }

    public Long updateById(String id, Update update) {
        if (Objects.isNull(update) || Objects.isNull(this.entityClass)) {
            return 0L;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
        UpdateResult updateResult = this.template.updateMulti(query, (UpdateDefinition)update, this.entityClass);
        return updateResult.getMatchedCount();
    }

    public UpdateResult update(Query query, Update update) {
        if (Objects.isNull(update) || Objects.isNull(this.entityClass)) {
            return null;
        }
        return this.template.updateFirst(query, (UpdateDefinition)update, this.entityClass);
    }

    public UpdateResult updateMulti(Query query, Update update) {
        if (Objects.isNull(update) || Objects.isNull(this.entityClass)) {
            return null;
        }
        return this.template.updateMulti(query, (UpdateDefinition)update, this.entityClass);
    }

    public long count(T query) {
        return this.template.count(this.buildWhereQuery(query), query.getClass());
    }

    public long count(Query query) {
        return this.template.count(query, this.entityClass);
    }

    private Map<String, Object> buildParamMap(T target, boolean excludeId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Class<?> clazz = target.getClass();
        Document annotation = clazz.getAnnotation(Document.class);
        if (Objects.nonNull(annotation)) {
            Field[] declaredFields = clazz.getDeclaredFields();
            try {
                for (Field field : declaredFields) {
                    field.setAccessible(true);
                    if (field.isAnnotationPresent(Id.class)) {
                        if (excludeId) continue;
                        paramMap.put("_id", field.get(target));
                        continue;
                    }
                    paramMap.put(field.getName(), field.get(target));
                }
            }
            catch (IllegalAccessException e) {
                log.error("CommonAsaMgDao.buildParamMap is error", (Throwable)e);
            }
        }
        return paramMap;
    }

    public T save(T update) {
        return (T)this.template.save(update);
    }

    public Collection<T> insertAll(Collection<T> collection) {
        return this.template.insertAll(collection);
    }

    public T insert(T object) {
        return (T)this.template.insert(object);
    }

    public T findById(Object id) {
        return (T)this.template.findById(id, this.entityClass);
    }

    public T findOne(T query) {
        return (T)this.template.findOne(this.buildWhereQuery(query), query.getClass());
    }

    public DeleteResult delete(T query) {
        return this.template.remove(this.buildWhereQuery(query), query.getClass());
    }

    public DeleteResult delete(Query query) {
        return this.template.remove(query, this.entityClass);
    }

    public T findOne(Query query) {
        return (T)this.template.findOne(query, this.entityClass);
    }

    public T findOne(Map<String, Object> query) {
        return (T)this.template.findOne(this.buildWhereQuery(query), this.entityClass);
    }

    public List<T> findList(Map<String, Object> query) {
        return this.findList(this.buildWhereQuery(query));
    }

    public List<T> findList(T query) {
        return this.template.find(this.buildWhereQuery(query), query.getClass());
    }

    public List<T> findList(Query query) {
        return this.template.find(query, this.entityClass);
    }

    public List<T> findAll() {
        return this.template.findAll(this.entityClass);
    }
}

