/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.repository;

import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.mongo.domain.ApplicationAssistantRelation;
import com.digiwin.athena.ania.mongo.repository.CommonAsaMgDao;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class AppAssistantRelationDao
extends CommonAsaMgDao<ApplicationAssistantRelation> {
    public AppAssistantRelationDao(MongoTemplate template) {
        super(template);
        this.entityClass = ApplicationAssistantRelation.class;
    }

    public List<String> queryAssistant(List<String> currentAppCodes, int assistantType) {
        List list;
        if (CollectionUtils.isNotEmpty(currentAppCodes) && CollectionUtils.isNotEmpty((Collection)(list = super.findList(new Query((CriteriaDefinition)Criteria.where((String)"appCode").in(currentAppCodes).and("assistantType").is((Object)assistantType)))))) {
            return list.stream().map(ApplicationAssistantRelation::getAssistantId).distinct().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Pair<List<String>, List<String>> queryAssistant(List<String> currentAppCodes) {
        if (CollectionUtils.isNotEmpty(currentAppCodes)) {
            List historyAssistant = this.queryAssistant(currentAppCodes, AssistantType.HISTORY_ASSISTANT.getType().intValue());
            if (CollectionUtils.isNotEmpty((Collection)historyAssistant)) {
                currentAppCodes.removeAll(historyAssistant);
            }
            List publishAssistant = this.queryAssistant(currentAppCodes, AssistantType.PUBLISH_ASSISTANT.getType().intValue());
            return Pair.of((Object)historyAssistant, (Object)publishAssistant);
        }
        return Pair.of(null, null);
    }

    public ApplicationAssistantRelation queryAssistantRelation(String assistantId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"assistantId").is((Object)assistantId));
        query.limit(1);
        return (ApplicationAssistantRelation)this.findOne(query);
    }
}

