/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.repository;

import com.digiwin.athena.ania.dto.command.CommandChainQueryDto;
import com.digiwin.athena.ania.mongo.domain.CommandChain;
import com.digiwin.athena.ania.mongo.repository.CommonAsaMgDao;
import com.digiwin.athena.ania.mongo.repository.ICommandChainDao;
import com.google.common.collect.Lists;
import com.mongodb.client.result.UpdateResult;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component
public class CommandChainDao
extends CommonAsaMgDao<CommandChain> {
    @Resource
    private ICommandChainDao iCommandChainDao;

    public CommandChainDao(MongoTemplate template) {
        super(template);
        this.entityClass = CommandChain.class;
    }

    public List<CommandChain> queryAssistantCommandChain(String userId, String tenantId, String assistantId) {
        Sort updateTime = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"updateTime")});
        return this.iCommandChainDao.findCommandChainByUserIdAndTenantIdAndAssistantsContains(userId, tenantId, (List)Lists.newArrayList((Object[])new String[]{assistantId}), updateTime);
    }

    public List<CommandChain> queryCommandChain(String userId, String tenantId, CommandChainQueryDto query) {
        Criteria criteria = Criteria.where((String)"userId").is((Object)userId).and("tenantId").is((Object)tenantId).and("status").is((Object)1);
        if (CollectionUtils.isNotEmpty((Collection)query.getAssistants())) {
            criteria.and("assistants").in((Collection)query.getAssistants());
        }
        if (Objects.nonNull(query.getCursor())) {
            criteria.and("updateTime").lt((Object)query.getCursor());
        }
        if (StringUtils.isNotEmpty((CharSequence)query.getName())) {
            criteria.and("name").regex("^.*" + query.getName() + ".*$");
        }
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"updateTime"});
        PageRequest pageable = PageRequest.of((int)(query.getPageIndex() - 1), (int)query.getPageSize(), (Sort)sort);
        Query queryMg = new Query((CriteriaDefinition)criteria);
        queryMg.with((Pageable)pageable);
        return this.findList(queryMg);
    }

    public boolean deleteCommandChain(String userId, String tenantId, String id) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId).and("tenantId").is((Object)tenantId).and("status").is((Object)1).and("_id").is((Object)id));
        UpdateResult updateResult = this.update(query, new Update().set("status", (Object)0));
        return updateResult.getMatchedCount() > 0L;
    }
}

