/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.repository;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ania.dto.conversation.ConversationSearchDto;
import com.digiwin.athena.ania.mongo.domain.ConversationMessageSearch;
import com.digiwin.athena.ania.mongo.repository.CommonAsaMgDao;
import com.digiwin.athena.ania.mongo.repository.ConversationMessageSearchDao;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class ConversationMessageSearchMgDao
extends CommonAsaMgDao<ConversationMessageSearch> {
    @Resource
    private ConversationMessageSearchDao conversationMessageSearchDao;

    public ConversationMessageSearchMgDao(MongoTemplate mongoTemplate) {
        super(mongoTemplate);
        this.entityClass = ConversationMessageSearch.class;
    }

    public List<ConversationMessageSearch> find(ConversationSearchDto dto, AuthoredUser authoredUser) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)authoredUser.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)authoredUser.getTenantId()));
        if (StrUtil.isNotBlank((CharSequence)dto.getConversationId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"conversationId").is((Object)dto.getConversationId()));
        }
        if (StrUtil.isNotBlank((CharSequence)dto.getKeyword())) {
            Pattern pattern = Pattern.compile("^.*" + dto.getKeyword() + ".*$", 2);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"keyword").regex(pattern));
        }
        query.skip((long)(dto.getPageNum() - 1) * (long)dto.getPageSize().intValue());
        query.limit(dto.getPageSize().intValue());
        return this.template.find(query, this.entityClass);
    }

    public List<ConversationMessageSearch> findLately(Integer latelyNum, AuthoredUser authoredUser) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)authoredUser.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)authoredUser.getTenantId()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"index"}));
        query.limit(latelyNum.intValue());
        return this.template.find(query, this.entityClass);
    }

    public ConversationMessageSearchDao getConversationMessageSearchDao() {
        return this.conversationMessageSearchDao;
    }
}

