/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.repository;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ania.mongo.domain.FusionAssistant;
import com.digiwin.athena.ania.mongo.repository.CommonAsaMgDao;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;

@Component
public class FusionAssistantMgDao
extends CommonAsaMgDao<FusionAssistant> {
    public FusionAssistantMgDao(MongoTemplate template) {
        super(template);
        this.entityClass = FusionAssistant.class;
    }

    public List<FusionAssistant> findVailableFusionAssistant() {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"isAvailable").is((Object)true));
        return this.template.find(query, this.entityClass);
    }

    public List<FusionAssistant> findByClientType(String clientType) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"clientType").in(new Object[]{clientType}));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"isAvailable").is((Object)true));
        return this.template.find(query, this.entityClass);
    }

    public List<FusionAssistant> findByAssistantIds(List<String> assistantIds) {
        Query query = new Query();
        if (CollUtil.isNotEmpty(assistantIds)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"assistantId").in(assistantIds));
        }
        return this.template.find(query, this.entityClass);
    }

    public void upsert(List<FusionAssistant> fusionAssistantList) {
        for (int i = 0; i < fusionAssistantList.size(); ++i) {
            FusionAssistant fusionAssistant = fusionAssistantList.get(i);
            if (StrUtil.isNotBlank((CharSequence)fusionAssistant.getId())) {
                Query query = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)fusionAssistant.getId()));
                Update update = new Update();
                if (CollUtil.isNotEmpty((Collection)fusionAssistant.getVersions())) {
                    update.set("versions", (Object)fusionAssistant.getVersions());
                }
                if (StrUtil.isNotBlank((CharSequence)fusionAssistant.getBaseURL())) {
                    update.set("baseURL", (Object)fusionAssistant.getBaseURL());
                }
                if (CollUtil.isNotEmpty((Collection)fusionAssistant.getClientType())) {
                    update.set("clientType", (Object)fusionAssistant.getClientType());
                }
                if (Objects.nonNull(fusionAssistant.getIsAvailable())) {
                    update.set("isAvailable", (Object)fusionAssistant.getIsAvailable());
                }
                this.template.upsert(query, (UpdateDefinition)update, this.entityClass);
                continue;
            }
            this.template.save((Object)fusionAssistant);
        }
    }

    public FusionAssistant findByAssistantId(String assistantId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"assistantId").is((Object)assistantId));
        return (FusionAssistant)this.template.findOne(query, this.entityClass);
    }
}

