/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.common.enums.AssistantSceneTypeEnum;
import com.digiwin.athena.ania.common.enums.AssistantSubTypeEnum;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.dto.AssistantConfig;
import com.digiwin.athena.ania.dto.AssistantDeployerDto;
import com.digiwin.athena.ania.dto.AssistantMongoDto;
import com.digiwin.athena.ania.dto.LanguageTemplateBO;
import com.digiwin.athena.ania.helper.CacHelper;
import com.digiwin.athena.ania.helper.KmHelper;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.repository.AssistantMgDao;
import com.digiwin.athena.ania.service.assistant.AssistantSceneService;
import com.digiwin.athena.ania.service.assistant.AssistantService;
import com.digiwin.athena.ania.service.assistant.strategy.HistoryAssistantService;
import com.digiwin.athena.ania.util.LanguageUtils;
import com.digiwin.athena.ania.util.RedisUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AssistantManager {
    private static final Logger log = LoggerFactory.getLogger(AssistantManager.class);
    public static final String DEPLOY_VERSION = "1.0";
    @Autowired
    private KmHelper kmHelper;
    @Autowired
    private CacHelper cacHelper;
    @Autowired
    private AssistantMgDao assistantMgDao;
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    @Resource
    private AssistantService assistantService;
    @Value(value="${assistant.designerLegworkCode}")
    private String legworkCode;
    @Value(value="${assistant.customLegworkCode:asaca}")
    private String customLegworkCode;
    @Autowired
    private AssistantSceneService assistantSceneService;
    @Lazy
    @Resource
    private HistoryAssistantService historyAssistantService;

    public Map queryAssistantConfigList(String clientType, String language) {
        return this.queryAssistantConfigList(clientType, language, null, null);
    }

    public Map queryAssistantConfigList(String clientType, String language, String version, Map<String, Map> hasAuthMap) {
        List assistantConfigList;
        Map appIdMapList;
        Set<Object> appIdList;
        HashMap<String, Object> assistantConfigListMap = new HashMap<String, Object>();
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String tenantId = authoredUser.getTenantId();
        if (null == hasAuthMap || hasAuthMap.isEmpty()) {
            appIdList = new HashSet();
            log.info("AssistantManager.queryAssistantConfigList userId:{},tenantId:{}", (Object)authoredUser.getUserId(), (Object)authoredUser.getTenantId());
            ResponseEntity currentAppsResponse = this.cacHelper.getCurrentAppsJsonObject(authoredUser.getToken());
            if (currentAppsResponse.getBody() == null || !currentAppsResponse.getStatusCode().is2xxSuccessful()) {
                assistantConfigListMap.put("assistantConfigList", Collections.emptyList());
                assistantConfigListMap.put("assistantCount", 0);
                return assistantConfigListMap;
            }
            JSONObject bodyJsonObject = (JSONObject)currentAppsResponse.getBody();
            JSONArray currentListMap = bodyJsonObject.getJSONArray("data");
            if (null == currentListMap || currentListMap.isEmpty()) {
                assistantConfigListMap.put("assistantConfigList", Collections.emptyList());
                assistantConfigListMap.put("assistantCount", 0);
                return assistantConfigListMap;
            }
            appIdMapList = currentListMap.stream().map(app -> (Map)app).filter(app -> !"Athena".equals(org.apache.commons.collections4.MapUtils.getString((Map)app, (Object)"id"))).peek(app -> appIdList.add(app.get("id").toString())).collect(Collectors.toMap(app -> app.get("id").toString(), Function.identity()));
        } else {
            appIdMapList = hasAuthMap;
            appIdList = hasAuthMap.keySet().stream().collect(Collectors.toSet());
        }
        if (StringUtils.isNotBlank((CharSequence)this.legworkCode) && appIdList.contains(this.legworkCode) && appIdList.contains(this.customLegworkCode)) {
            appIdList.remove(this.customLegworkCode);
            appIdMapList.remove(this.customLegworkCode);
        }
        String tenantVersion = version;
        if (StrUtil.isBlank((CharSequence)version)) {
            tenantVersion = this.kmHelper.getTenantVersion(authoredUser.getTenantId());
        }
        if (CollUtil.isEmpty((Collection)(assistantConfigList = this.queryAssistantList(tenantId, language, appIdMapList, clientType, appIdList, tenantVersion)))) {
            assistantConfigListMap.put("assistantConfigList", Collections.emptyList());
            assistantConfigListMap.put("assistantCount", 0);
            return assistantConfigListMap;
        }
        return this.aggAssistant(assistantConfigList, appIdList, appIdMapList, tenantVersion);
    }

    public Map<Object, Object> aggAssistant(List<AssistantConfig> assistantConfigList, Set<String> appIdList, Map<String, Map> appIdMapList, String tenantVersion) {
        List assistantScenesList;
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        HashMap<Object, Object> assistantConfigListMap = new HashMap<Object, Object>();
        if (CollUtil.isEmpty(assistantConfigList)) {
            assistantConfigListMap.put("assistantConfigList", Collections.emptyList());
            assistantConfigListMap.put("assistantCount", 0);
            return assistantConfigListMap;
        }
        ArrayList<String> assistantCodes = new ArrayList<String>();
        Iterator<AssistantConfig> iterator = assistantConfigList.iterator();
        while (iterator.hasNext()) {
            AssistantConfig assistantConfig = iterator.next();
            if (StringUtils.isNotBlank((CharSequence)assistantConfig.getKnowledgeType()) && "private".equals(assistantConfig.getKnowledgeType())) {
                if (appIdList.contains("KCF")) {
                    Map appMap = appIdMapList.get("KCF");
                    DateTime expiredTime = DateUtil.parseDate((CharSequence)MapUtils.getString((Map)appMap, (Object)"expiredTime"));
                    if (!expiredTime.after(new Date())) continue;
                    assistantConfig.setLastAssistantMsgTimestamp(this.getLastAssistantMsgTimestamp(authoredUser.getUserId(), assistantConfig.getAssistantCode()));
                    continue;
                }
                iterator.remove();
                continue;
            }
            assistantCodes.add(assistantConfig.getAssistantCode());
        }
        if (CollectionUtils.isNotEmpty(assistantCodes) && CollUtil.isNotEmpty((Collection)(assistantScenesList = this.assistantSceneService.querySkillsByAssistantCode(assistantCodes, appIdList, tenantVersion, Integer.valueOf(4))))) {
            Map<String, List<LanguageTemplateBO>> assistantSceneMap = assistantScenesList.stream().collect(Collectors.groupingBy(LanguageTemplateBO::getAssistantCode));
            iterator = assistantConfigList.iterator();
            while (iterator.hasNext()) {
                AssistantConfig assistantConfig = iterator.next();
                if (StringUtils.isNotBlank((CharSequence)assistantConfig.getKnowledgeType()) && "private".equals(assistantConfig.getKnowledgeType())) continue;
                List<LanguageTemplateBO> assistantScenes = assistantSceneMap.get(assistantConfig.getAssistantCode());
                List filterAuthScene = this.assistantSceneService.filterAuthScene(assistantConfig, assistantScenes, appIdMapList, appIdList);
                if (AssistantSubTypeEnum.COMPOSITE.getType().equals(assistantConfig.getAssistantSubType())) {
                    if (CollectionUtils.isEmpty((Collection)filterAuthScene)) {
                        iterator.remove();
                    } else if (filterAuthScene.size() == 1 && this.isPrivateScene((LanguageTemplateBO)filterAuthScene.get(0)) && !appIdList.contains(assistantConfig.getAssistantCode())) {
                        iterator.remove();
                    }
                } else if (AssistantSubTypeEnum.DATA.getType().equals(assistantConfig.getAssistantSubType())) {
                    filterAuthScene = this.buildAgileDataLanguageTemplate(assistantConfig, authoredUser);
                }
                assistantConfig.setLanguageTemplate(filterAuthScene);
                assistantConfig.setLastAssistantMsgTimestamp(this.getLastAssistantMsgTimestamp(authoredUser.getUserId(), assistantConfig.getAssistantCode()));
                if (!Objects.nonNull(assistantConfig.getAssistantSubType()) || assistantConfig.getAssistantSubType() != 5 || !StringUtils.isNotBlank((CharSequence)assistantConfig.getSkillId())) continue;
                String webUrl = (String)this.redisTemplate.opsForValue().get((Object)("last_webUrl_key:" + authoredUser.getUserId() + authoredUser.getTenantId() + assistantConfig.getSkillId()));
                if (StringUtils.isBlank((CharSequence)webUrl) && StringUtils.isNotBlank((CharSequence)(webUrl = this.kmHelper.getWebUrl(assistantConfig.getSkillId(), authoredUser.getToken())))) {
                    this.redisTemplate.opsForValue().set((Object)("last_webUrl_key:" + authoredUser.getUserId() + authoredUser.getTenantId() + assistantConfig.getSkillId()), (Object)webUrl, 30L, TimeUnit.MINUTES);
                }
                assistantConfig.setWebUrl(webUrl);
            }
        }
        if (CollectionUtils.isNotEmpty(assistantConfigList)) {
            boolean hasDifference = appIdList.stream().anyMatch(appId -> !assistantCodes.contains(appId));
            String type = hasDifference ? "OTHER" : (assistantConfigList.size() == 1 ? "ONLY_ASSISTANT" : "MULTIPLE_ASSISTANTS");
            assistantConfigListMap.put("type", type);
            assistantConfigListMap.put("assistantConfigList", assistantConfigList);
            assistantConfigListMap.put("assistantCount", assistantConfigList.size());
        } else {
            assistantConfigListMap.put("assistantConfigList", assistantConfigList);
            assistantConfigListMap.put("assistantCount", 0);
        }
        return assistantConfigListMap;
    }

    private boolean isPrivateScene(LanguageTemplateBO assistantScene) {
        if (Objects.equals(AssistantSceneTypeEnum.SCENE_TYPE_KNOWLEDGE.getType(), assistantScene.getType())) {
            return "private".equals(org.apache.commons.collections4.MapUtils.getString((Map)assistantScene.getKnowledgeBase(), (Object)"type"));
        }
        return false;
    }

    public Map<Object, Object> queryAssistantCount(String clientType) {
        Map map = this.queryAssistantConfigList(clientType, "zh_CN");
        map.remove("assistantConfigList");
        return map;
    }

    public List<String> queryAssistantAccidList(String clientType) {
        String accids = (String)this.redisTemplate.opsForValue().get((Object)"ASSISTANT:ALL:ACCID");
        return (List)JSON.parseObject((String)accids, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
    }

    public List<String> queryExistAssistant(Map<String, Map> mapMap, String clientType, List<String> curentAppList, String tenantVersion) {
        List assistantList;
        Iterator<String> iterator = curentAppList.iterator();
        while (iterator.hasNext()) {
            Map map = mapMap.get(iterator.next());
            DateTime expiredTime = DateUtil.parseDate((CharSequence)org.apache.commons.collections4.MapUtils.getString((Map)map, (Object)"expiredTime"));
            if (!expiredTime.before(new Date())) continue;
            iterator.remove();
        }
        ArrayList<String> assistantCodeList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(curentAppList) && CollectionUtils.isNotEmpty((Collection)(assistantList = this.assistantService.batchGetCacheAssistant(curentAppList, tenantVersion)))) {
            assistantList.stream().forEach(assistant -> {
                if (assistant.getStatus() == 1 && assistant.getClientType().contains(clientType) && assistant.getAssistantType() == 1) {
                    assistantCodeList.add(assistant.getAssistantCode());
                }
            });
        }
        return assistantCodeList;
    }

    private void customizeAssistantConfigForDiGiWinNaNaDemo(String tenantId, List<AssistantConfig> assistantConfigList, String langCode) {
        if ("DigiwinNaNaDemo".equals(tenantId)) {
            String assistantName = LocalsEnum.isTw((String)langCode) ? "\u5e74\u5831\u6578\u64da\u767c\u8a00\u4eba" : "\u5e74\u62a5\u6570\u636e\u53d1\u8a00\u4eba";
            String detailDescriptionTemplate = LocalsEnum.isTw((String)langCode) ? "\u4f5c\u70ba\u60a8\u7684\u5e74\u5831\u6578\u64da\u767c\u8a00\u4eba\uff0c\u6211\u6703\u5e6b\u60a8\u5f9e\u4f01\u696d\u7cfb\u7d71\u4e2d\u5c07\u6578\u64da\u64f7\u53d6\u3001\u6574\u7406\u51fa\u4f86\uff0c\u4ee5\u6700\u5408\u9069\u7684\u65b9\u5f0f\u70ba\u60a8\u5448\u73fe\u548c\u7e3d\u7d50\uff0c\u8acb\u5411\u6211\u63cf\u8ff0\u60a8\u9700\u8981\u7684\u6578\u64da\u3002" : "\u4f5c\u4e3a\u60a8\u7684\u5e74\u62a5\u6570\u636e\u53d1\u8a00\u4eba\uff0c\u6211\u4f1a\u5e2e\u60a8\u4ece\u4f01\u4e1a\u7cfb\u7edf\u4e2d\u5c06\u6570\u636e\u64b7\u53d6\u3001\u6574\u7406\u51fa\u6765\uff0c\u4ee5\u6700\u5408\u9002\u7684\u65b9\u5f0f\u4e3a\u60a8\u5448\u73b0\u548c\u603b\u7ed3\uff0c\u8bf7\u5411\u6211\u63cf\u8ff0\u60a8\u9700\u8981\u7684\u6570\u636e\u3002";
            assistantConfigList.stream().filter(item -> "asada".equals(item.getAssistantCode())).forEach(item -> {
                item.setAssistantName(assistantName);
                item.setDetailDescription(detailDescriptionTemplate);
            });
        }
    }

    public List<AssistantConfig> queryAssistantList(String tenantId, String language, Map<String, Map> currentAppIdMapList, String clientType, Set<String> appIdList, String tenantVersion) {
        return this.queryAssistantList(tenantId, language, currentAppIdMapList, clientType, appIdList, tenantVersion, null);
    }

    public List<AssistantConfig> queryAssistantList(String tenantId, String language, Map<String, Map> currentAppIdMapList, String clientType, Set<String> appIdList, String tenantVersion, String assistantId) {
        List<Assistant> assistantList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)assistantId)) {
            Assistant assistant = this.assistantService.getAssistant(assistantId, tenantVersion);
            if (Objects.nonNull(assistant) && !Objects.equals(0, assistant.getStatus())) {
                if (StringUtils.isNotBlank((CharSequence)clientType)) {
                    if (CollectionUtils.isNotEmpty((Collection)assistant.getClientType()) && assistant.getClientType().contains(clientType)) {
                        assistantList.add(assistant);
                    }
                } else {
                    assistantList.add(assistant);
                }
            }
        } else {
            AssistantMongoDto assistantMongoDto = AssistantMongoDto.constructAssistantList((String)tenantVersion, (String)clientType, (String)assistantId);
            assistantList = this.assistantMgDao.find(assistantMongoDto);
        }
        List assistantConfigList = AssistantManager.generateAssistantConfig(assistantList, (String)language);
        this.customizeAssistantConfigForDiGiWinNaNaDemo(tenantId, assistantConfigList, language);
        assistantConfigList.removeIf(assistantConfig -> {
            if (AssistantSubTypeEnum.COMPOSITE.getType().equals(assistantConfig.getAssistantSubType())) {
                return false;
            }
            String assistantCode = assistantConfig.getAssistantCode();
            if (!appIdList.contains(assistantCode)) {
                return true;
            }
            Map appMap = (Map)currentAppIdMapList.get(assistantCode);
            if (appMap == null) {
                return true;
            }
            DateTime expiredTime = DateUtil.parseDate((CharSequence)org.apache.commons.collections4.MapUtils.getString((Map)appMap, (Object)"expiredTime"));
            return expiredTime.before(new Date());
        });
        return assistantConfigList;
    }

    public static List<AssistantConfig> generateAssistantConfig(List<Assistant> assistantList, String langCode) {
        ArrayList assistantConfigList = Lists.newArrayList();
        for (Assistant assistant : assistantList) {
            Map prologueMap;
            AssistantConfig assistantConfig = new AssistantConfig();
            assistantConfig.setId(assistant.getId());
            assistantConfig.setAssistantAsaCode(assistant.getAssistantCode());
            assistantConfig.setAssistantSubType(assistant.getAssistantSubType());
            assistantConfig.setSourceCustom(assistant.getSourceCustom());
            assistantConfig.setInputModel(assistant.getInputModel());
            assistantConfig.setTenantId(assistant.getTenantId());
            assistantConfig.setClientType(assistant.getClientType());
            Map name = (Map)assistant.getLang().get("name");
            if (LocalsEnum.isTw((String)langCode)) {
                assistantConfig.setAssistantName((String)name.get("zh_TW"));
            } else if (LocalsEnum.isCn((String)langCode)) {
                assistantConfig.setAssistantName((String)name.get("zh_CN"));
            } else {
                assistantConfig.setAssistantName((String)name.get("en_US"));
            }
            Map descriptionMap = (Map)assistant.getLang().get("description");
            if (LocalsEnum.isTw((String)langCode)) {
                assistantConfig.setDetailDescription((String)descriptionMap.get("zh_TW"));
            } else if (LocalsEnum.isCn((String)langCode)) {
                assistantConfig.setDetailDescription((String)descriptionMap.get("zh_CN"));
            } else {
                assistantConfig.setDetailDescription((String)descriptionMap.get("en_US"));
            }
            Map briefDescriptionMap = (Map)assistant.getLang().get("briefDescription");
            if (Objects.nonNull(briefDescriptionMap)) {
                if (LocalsEnum.isTw((String)langCode)) {
                    assistantConfig.setBriefDescription((String)briefDescriptionMap.get("zh_TW"));
                } else if (LocalsEnum.isCn((String)langCode)) {
                    assistantConfig.setBriefDescription((String)briefDescriptionMap.get("zh_CN"));
                } else {
                    assistantConfig.setBriefDescription((String)briefDescriptionMap.get("en_US"));
                }
            }
            if (Objects.nonNull(prologueMap = (Map)assistant.getLang().get("prologue"))) {
                if (LocalsEnum.isTw((String)langCode)) {
                    assistantConfig.setPrologue((String)prologueMap.get("zh_TW"));
                } else if (LocalsEnum.isCn((String)langCode)) {
                    assistantConfig.setPrologue((String)prologueMap.get("zh_CN"));
                } else {
                    assistantConfig.setPrologue((String)prologueMap.get("en_US"));
                }
            } else {
                assistantConfig.setPrologue(assistantConfig.getDetailDescription());
            }
            assistantConfig.setAssistantCode(StringUtils.isEmpty((CharSequence)assistant.getAssistantAsaCode()) ? assistant.getAssistantCode() : assistant.getAssistantAsaCode());
            assistantConfig.setSkillType(StringUtils.isEmpty((CharSequence)assistant.getSkillType()) ? assistant.getAssistantCode() : assistant.getSkillType());
            assistantConfig.setIconUrl(assistant.getAssistantAvatar());
            assistantConfig.setIconType(assistant.getAvatarType());
            assistantConfig.setVersion(assistant.getVersion());
            assistantConfig.setSort(assistant.getSort());
            assistantConfig.setAccid(assistant.getAccid());
            assistantConfig.setKnowledgeType(assistant.getKnowledgeType());
            assistantConfig.setSkillId(assistant.getSkillId());
            assistantConfigList.add(assistantConfig);
        }
        return assistantConfigList;
    }

    public void saveUserLastAssistantMsgTime(String assistanceCode, String timestamp, AuthoredUser authoredUser) {
        if (StringUtils.isNotBlank((CharSequence)timestamp) && StringUtils.isNotBlank((CharSequence)assistanceCode)) {
            String userId = authoredUser.getUserId();
            JSONObject jsonObject = new JSONObject();
            jsonObject.fluentPut("timestamp", (Object)timestamp);
            this.redisTemplate.opsForValue().set((Object)("last_assistant_message_time_key:" + userId + assistanceCode), (Object)jsonObject.toJSONString());
        }
    }

    private String getLastAssistantMsgTimestamp(String userId, String assistantCode) {
        String timeStampJson = (String)this.redisTemplate.opsForValue().get((Object)("last_assistant_message_time_key:" + userId + assistantCode));
        if (StringUtils.isNotBlank((CharSequence)timeStampJson)) {
            JSONObject jsonObject = JSON.parseObject((String)timeStampJson);
            return jsonObject.getString("timestamp");
        }
        return "0";
    }

    public List<LanguageTemplateBO> buildAgileDataLanguageTemplate(AssistantConfig assistantConfig, AuthoredUser authoredUser) {
        ArrayList<LanguageTemplateBO> agileDataLanguageTemplates = new ArrayList<LanguageTemplateBO>();
        try {
            JSONArray commandIntentions = this.kmHelper.queryCommandIntentions(authoredUser);
            if (CollectionUtils.isNotEmpty((Collection)commandIntentions)) {
                String langStr = LocalsEnum.isTw((String)LanguageUtils.processLanguage()) ? LocalsEnum.TW.getCode() : LocalsEnum.CN.getCode();
                for (int i = 0; i < commandIntentions.size(); ++i) {
                    JSONObject commandIntention = commandIntentions.getJSONObject(i);
                    String intentionGroupName = commandIntention.getString("intentionGroupName");
                    LanguageTemplateBO languageTemplateBO = new LanguageTemplateBO();
                    languageTemplateBO.setAssistantCode(assistantConfig.getAssistantCode());
                    JSONObject lang = commandIntention.getJSONObject("lang");
                    if (null != lang && !lang.isEmpty()) {
                        JSONObject intentLang = lang.getJSONObject("intentionGroupName");
                        languageTemplateBO.setIntentName(org.apache.commons.collections4.MapUtils.getString((Map)intentLang, (Object)langStr, (String)intentionGroupName));
                    } else {
                        languageTemplateBO.setIntentName(commandIntention.getString("intentionGroupName"));
                    }
                    JSONArray intentions = commandIntention.getJSONArray("intentions");
                    ArrayList<String> texts = new ArrayList<String>();
                    if (CollectionUtils.isNotEmpty((Collection)intentions)) {
                        for (int j = 0; j < intentions.size(); ++j) {
                            JSONObject intention = intentions.getJSONObject(j);
                            String intentionName = intention.getString("intention");
                            if (!StringUtils.isNotBlank((CharSequence)intentionName)) continue;
                            JSONObject intentionLang = intention.getJSONObject("lang");
                            if (null != intentionLang && !intentionLang.isEmpty()) {
                                JSONObject intentionJSONObject = intentionLang.getJSONObject("intention");
                                intentionName = org.apache.commons.collections4.MapUtils.getString((Map)intentionJSONObject, (Object)langStr, (String)intentionName);
                            }
                            texts.add(intentionName);
                        }
                    }
                    if (!CollectionUtils.isNotEmpty(texts)) continue;
                    languageTemplateBO.setTexts(texts);
                    agileDataLanguageTemplates.add(languageTemplateBO);
                }
            }
        }
        catch (Exception e) {
            log.error("queryOpeningRemarksConfig error", (Throwable)e);
        }
        return agileDataLanguageTemplates;
    }

    private void cacheDataCommandIntentions(JSONArray commandIntentions, AuthoredUser authoredUser) {
        if (null == commandIntentions || commandIntentions.isEmpty()) {
            return;
        }
        String jsonStr = JSONUtil.toJsonStr((Object)commandIntentions);
        String key = "DATA_COMMAND_INTENTION:" + authoredUser.getUserId() + ":" + authoredUser.getTenantId();
        RedisUtils.cacheStrData((String)key, (String)jsonStr, (long)1L, (TimeUnit)TimeUnit.DAYS);
    }

    private JSONArray getDataCommandIntentions(AuthoredUser authoredUser) {
        String key = "DATA_COMMAND_INTENTION:" + authoredUser.getUserId() + ":" + authoredUser.getTenantId();
        String cacheStrData = RedisUtils.getCacheStrData((String)key);
        return StrUtil.isNotBlank((CharSequence)cacheStrData) ? JSONArray.parseArray((String)cacheStrData) : new JSONArray();
    }

    public ResultBean<String> deployerCache(AssistantDeployerDto assistantDeployer) {
        try {
            if (assistantDeployer.isCNaDeploy()) {
                List assistants = this.assistantMgDao.findList(new Query((CriteriaDefinition)Criteria.where((String)"assistantCode").is((Object)assistantDeployer.getAssistantCode())));
                this.redisTemplate.delete((Object)("ANIA:HIS:ASSISTANT:" + assistantDeployer.getAssistantCode()));
                if (CollectionUtils.isNotEmpty((Collection)assistants)) {
                    this.redisTemplate.opsForValue().set((Object)("ANIA:HIS:ASSISTANT:" + assistantDeployer.getAssistantCode()), (Object)JSON.toJSONString(assistants.get(0)));
                }
            } else {
                this.redisTemplate.delete((Object)("ANIA:HIS:ASSISTANT:1.0" + assistantDeployer.getAssistantCode()));
                this.redisTemplate.delete((Object)("ANIA:HIS:ASSISTANT:2.0" + assistantDeployer.getAssistantCode()));
                this.historyAssistantService.publish(assistantDeployer.getAssistantCode());
            }
            return ResultBean.success();
        }
        catch (Exception e) {
            return ResultBean.fail((String)e.getMessage());
        }
    }
}

