/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.assistant.impl;

import cn.hutool.core.lang.Assert;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.exception.FusionException;
import com.digiwin.athena.ania.dto.assistant.FusionAssistantQuestionVo;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantQuestionAddDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantQuestionDeleteDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantQuestionQueryDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantQuestionItem;
import com.digiwin.athena.ania.mongo.repository.FusionAssistantQuestionItemMgDao;
import com.digiwin.athena.ania.service.assistant.FusionAssistantQuestionService;
import com.digiwin.athena.ania.service.assistant.FusionAssistantService;
import com.digiwin.athena.ania.util.LanguageUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FusionAssistantQuestionServiceImpl
implements FusionAssistantQuestionService {
    @Autowired
    private FusionAssistantService fusionAssistantService;
    @Autowired
    private FusionAssistantQuestionItemMgDao fusionAssistantQuestionItemMgDao;

    public void add(FusionAssistantQuestionAddDto dto) {
        dto.check();
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        FusionAssistantVo fusionAssistantVo = this.fusionAssistantService.assistantBaseInfo(new FusionAssistantInfoDto(dto.getAssistantId(), Boolean.valueOf(true)), authoredUser);
        Assert.notNull((Object)fusionAssistantVo, () -> new FusionException(LocalsEnum.isTw((String)LanguageUtils.processLanguage()) ? "\u6c92\u6709\u52a9\u7406\u6b0a\u9650" : "\u6ca1\u6709\u52a9\u7406\u6743\u9650"));
        Long count = this.fusionAssistantQuestionItemMgDao.count(dto.getAssistantId(), authoredUser);
        if (count >= 50L) {
            throw new FusionException(LocalsEnum.isTw((String)LanguageUtils.processLanguage()) ? "\u5e38\u7528\u554f\u984c\u9650\u5236\u6dfb\u52a050\u689d" : "\u5e38\u7528\u95ee\u9898\u9650\u5236\u6dfb\u52a050\u6761");
        }
        Long repetition = this.fusionAssistantQuestionItemMgDao.find(dto, authoredUser);
        if (repetition > 0L) {
            throw new FusionException(LocalsEnum.isTw((String)LanguageUtils.processLanguage()) ? "\u5e38\u7528\u554f\u984c\u5df2\u5b58\u5728" : "\u5e38\u7528\u95ee\u9898\u5df2\u5b58\u5728");
        }
        FusionAssistantQuestionItem item = new FusionAssistantQuestionItem();
        item.setAssistantId(dto.getAssistantId());
        item.setQuestion(dto.getQuestion());
        item.setCreateTime(new Date());
        item.setUserId(authoredUser.getUserId());
        item.setTenantId(authoredUser.getTenantId());
        this.fusionAssistantQuestionItemMgDao.insert((Object)item);
    }

    public List<FusionAssistantQuestionVo> findByAssistantId(FusionAssistantQuestionQueryDto dto) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        List fusionAssistantQuestionItems = this.fusionAssistantQuestionItemMgDao.find(dto, authoredUser);
        return FusionAssistantQuestionVo.map((List)fusionAssistantQuestionItems);
    }

    public void deleteQuestionItemById(FusionAssistantQuestionDeleteDto dto) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        this.fusionAssistantQuestionItemMgDao.remove(dto, authoredUser);
    }
}

