/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.assistant.impl;

import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.dto.AssistantSkillDto;
import com.digiwin.athena.ania.helper.CacHelper;
import com.digiwin.athena.ania.helper.KmHelper;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.mongo.repository.AssistantSceneDao;
import com.digiwin.athena.ania.service.assistant.AssistantService;
import com.digiwin.athena.ania.service.assistant.SkillService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SkillServiceImpl
implements SkillService {
    @Autowired
    private AssistantSceneDao assistantSceneDao;
    @Autowired
    private CacHelper cacHelper;
    @Resource
    private KmHelper kmHelper;
    @Resource
    private AssistantService assistantService;
    public static final Integer APP_SUB_TYPE_KNOWLEDGE = 2;

    public List<AssistantSkillDto> querySkillsByAssistantCode(String assistantCode, String language, String tenantId, String tenantVersion) {
        List assistantScenes = this.assistantSceneDao.findAllByAssistantCodeAndVersion(assistantCode, tenantVersion);
        if (CollectionUtils.isEmpty((Collection)assistantScenes)) {
            return new ArrayList<AssistantSkillDto>();
        }
        ArrayList<Object> assistantSkillDtos = new ArrayList<Object>();
        for (AssistantScene assistantScene : assistantScenes) {
            Map map;
            AssistantSkillDto assistantSkillDto = new AssistantSkillDto();
            assistantSkillDto.setId(assistantScene.getId());
            assistantSkillDto.setTop(assistantScene.getTop());
            assistantSkillDto.setSkillCode(assistantScene.getCode());
            assistantSkillDto.setAccid(assistantScene.getAccid());
            assistantSkillDto.setDescription(assistantScene.getDescription());
            assistantSkillDto.setSort(assistantScene.getSort());
            Map map2 = assistantScene.getLang();
            if (null != map2 && !map2.isEmpty() && null != (map = (Map)map2.getOrDefault("name", null)) && !map.isEmpty()) {
                assistantSkillDto.setTraditionalSkillName(map.getOrDefault(LocalsEnum.TW.getCode(), "").toString());
                assistantSkillDto.setSkillName(LocalsEnum.isTw((String)language) ? map.getOrDefault(LocalsEnum.TW.getCode(), "").toString() : map.getOrDefault(LocalsEnum.CN.getCode(), "").toString());
            }
            assistantSkillDto.setLang(assistantScene.getLang());
            assistantSkillDtos.add(assistantSkillDto);
        }
        ArrayList<AssistantSkillDto> sortedAssistantSkillDtos = new ArrayList<AssistantSkillDto>();
        ArrayList<AssistantSkillDto> noSortAssistantSkillDtos = new ArrayList<AssistantSkillDto>();
        for (AssistantSkillDto assistantSkillDto : assistantSkillDtos) {
            if (!Objects.isNull(assistantSkillDto.getSort())) continue;
            noSortAssistantSkillDtos.add(assistantSkillDto);
        }
        ArrayList<AssistantSkillDto> hasSortAssistantSkillDtos = new ArrayList<AssistantSkillDto>();
        for (AssistantSkillDto assistantSkillDto : assistantSkillDtos) {
            if (!Objects.nonNull(assistantSkillDto.getSort())) continue;
            hasSortAssistantSkillDtos.add(assistantSkillDto);
        }
        if (CollectionUtils.isNotEmpty(hasSortAssistantSkillDtos)) {
            sortedAssistantSkillDtos.addAll(hasSortAssistantSkillDtos.stream().filter(item -> Objects.nonNull(item.getSort())).sorted(Comparator.comparing(AssistantSkillDto::getSort).thenComparing(AssistantSkillDto::getSort)).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(noSortAssistantSkillDtos)) {
            sortedAssistantSkillDtos.addAll(noSortAssistantSkillDtos);
        }
        return sortedAssistantSkillDtos;
    }

    public List<AssistantSkillDto> filterNoAuthScene(String assistantCode, List<AssistantSkillDto> skillDtos, String tenantVersion, List<String> curentAppList) {
        ArrayList<AssistantSkillDto> authorizedSceneList = new ArrayList();
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        Assistant assistant = this.assistantService.getAssistant(assistantCode, authoredUser.getTenantId(), tenantVersion);
        if (Objects.nonNull(assistant.getAssistantSubType()) && APP_SUB_TYPE_KNOWLEDGE.intValue() == assistant.getAssistantSubType().intValue()) {
            for (AssistantSkillDto skillDto : skillDtos) {
                String assistantSceneCode = skillDto.getSkillCode();
                if (!curentAppList.contains(assistantSceneCode)) continue;
                authorizedSceneList.add(skillDto);
            }
        } else {
            authorizedSceneList = skillDtos;
        }
        return authorizedSceneList;
    }
}

